/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jgit.api.errors.FilterFailedException;
import org.eclipse.jgit.attributes.AttributesNode;
import org.eclipse.jgit.attributes.FilterCommand;
import org.eclipse.jgit.attributes.FilterCommandRegistry;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig$CheckStat;
import org.eclipse.jgit.lib.CoreConfig$EolStreamType;
import org.eclipse.jgit.lib.CoreConfig$SymLinks;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.InstantComparator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk$OperationType;
import org.eclipse.jgit.treewalk.WorkingTreeIterator$Entry;
import org.eclipse.jgit.treewalk.WorkingTreeIterator$IteratorState;
import org.eclipse.jgit.treewalk.WorkingTreeIterator$MetadataDiff;
import org.eclipse.jgit.treewalk.WorkingTreeIterator$PerDirectoryAttributesNode;
import org.eclipse.jgit.treewalk.WorkingTreeIterator$PerDirectoryIgnoreNode;
import org.eclipse.jgit.treewalk.WorkingTreeIterator$RootIgnoreNode;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS$ExecutionResult;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.Holder;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.Paths;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.TemporaryBuffer$LocalFile;
import org.eclipse.jgit.util.io.EolStreamTypeUtil;
import org.eclipse.jgit.util.sha1.SHA1;

public abstract class WorkingTreeIterator
extends AbstractTreeIterator {
    private static final int MAX_EXCEPTION_TEXT_SIZE = 10240;
    protected static final WorkingTreeIterator$Entry[] EOF = new WorkingTreeIterator$Entry[0];
    static final int BUFFER_SIZE = 2048;
    private static final long MAXIMUM_FILE_SIZE_TO_READ_FULLY = 65536L;
    private final WorkingTreeIterator$IteratorState state;
    private byte[] contentId;
    private int contentIdFromPtr;
    private WorkingTreeIterator$Entry[] entries;
    private int entryCnt;
    private int ptr;
    private IgnoreNode ignoreNode;
    private Holder cleanFilterCommandHolder;
    private Holder eolStreamTypeHolder;
    protected Repository repository;
    private long canonLen = -1L;
    private int contentIdOffset;
    private final InstantComparator timestampComparator = new InstantComparator();
    private static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final byte[] hblob = Constants.encodedTypeString(3);
    private static final Comparator ENTRY_CMP = (workingTreeIterator$Entry, workingTreeIterator$Entry2) -> Paths.compare(workingTreeIterator$Entry.encodedName, 0, workingTreeIterator$Entry.encodedNameLen, workingTreeIterator$Entry.getMode().getBits(), workingTreeIterator$Entry2.encodedName, 0, workingTreeIterator$Entry2.encodedNameLen, workingTreeIterator$Entry2.getMode().getBits());

    protected WorkingTreeIterator(WorkingTreeOptions workingTreeOptions) {
        this.state = new WorkingTreeIterator$IteratorState(workingTreeOptions);
    }

    protected WorkingTreeIterator(String string, WorkingTreeOptions workingTreeOptions) {
        super(string);
        this.state = new WorkingTreeIterator$IteratorState(workingTreeOptions);
    }

    protected WorkingTreeIterator(WorkingTreeIterator workingTreeIterator) {
        super(workingTreeIterator);
        this.state = workingTreeIterator.state;
        this.repository = workingTreeIterator.repository;
    }

    protected void initRootIterator(Repository repository) {
        this.repository = repository;
        WorkingTreeIterator$Entry workingTreeIterator$Entry = this.ignoreNode instanceof WorkingTreeIterator$PerDirectoryIgnoreNode ? ((WorkingTreeIterator$PerDirectoryIgnoreNode)this.ignoreNode).entry : null;
        this.ignoreNode = new WorkingTreeIterator$RootIgnoreNode(workingTreeIterator$Entry, repository);
    }

    public void setDirCacheIterator(TreeWalk treeWalk, int n2) {
        this.state.walk = treeWalk;
        this.state.dirCacheTree = n2;
    }

    protected DirCacheIterator getDirCacheIterator() {
        if (this.state.dirCacheTree >= 0 && this.state.walk != null) {
            return (DirCacheIterator)this.state.walk.getTree(this.state.dirCacheTree, DirCacheIterator.class);
        }
        return null;
    }

    public void setWalkIgnoredDirectories(boolean bl2) {
        this.state.walkIgnored = bl2;
    }

    public boolean walksIgnoredDirectories() {
        return this.state.walkIgnored;
    }

    @Override
    public boolean hasId() {
        if (this.contentIdFromPtr == this.ptr) {
            return true;
        }
        return (this.mode & 0xF000) == 32768;
    }

    @Override
    public byte[] idBuffer() {
        if (this.contentIdFromPtr == this.ptr) {
            return this.contentId;
        }
        if (this.state.walk != null) {
            DirCacheIterator dirCacheIterator = (DirCacheIterator)this.state.walk.getTree(this.state.dirCacheTree, DirCacheIterator.class);
            if (dirCacheIterator != null) {
                DirCacheEntry dirCacheEntry = dirCacheIterator.getDirCacheEntry();
                if (dirCacheEntry != null && this.compareMetadata(dirCacheEntry) == WorkingTreeIterator$MetadataDiff.EQUAL && (dirCacheEntry.getFileMode().getBits() & 0xF000) != 57344) {
                    this.contentIdOffset = dirCacheIterator.idOffset();
                    this.contentIdFromPtr = this.ptr;
                    this.contentId = dirCacheIterator.idBuffer();
                    return this.contentId;
                }
                this.contentIdOffset = 0;
            } else {
                this.contentIdOffset = 0;
            }
        }
        switch (this.mode & 0xF000) {
            case 32768: 
            case 40960: {
                this.contentIdFromPtr = this.ptr;
                this.contentId = this.idBufferBlob(this.entries[this.ptr]);
                return this.contentId;
            }
            case 57344: {
                this.contentIdFromPtr = this.ptr;
                this.contentId = this.idSubmodule(this.entries[this.ptr]);
                return this.contentId;
            }
        }
        return zeroid;
    }

    @Override
    public boolean isWorkTree() {
        return true;
    }

    protected byte[] idSubmodule(WorkingTreeIterator$Entry workingTreeIterator$Entry) {
        File file;
        if (this.repository == null) {
            return zeroid;
        }
        try {
            file = this.repository.getWorkTree();
        }
        catch (NoWorkTreeException noWorkTreeException) {
            return zeroid;
        }
        return this.idSubmodule(file, workingTreeIterator$Entry);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] idSubmodule(File file, WorkingTreeIterator$Entry workingTreeIterator$Entry) {
        try (Repository repository = SubmoduleWalk.getSubmoduleRepository(file, workingTreeIterator$Entry.getName(), this.repository != null ? this.repository.getFS() : FS.DETECTED);){
            if (repository == null) {
                byte[] byArray = zeroid;
                return byArray;
            }
            ObjectId objectId = repository.resolve("HEAD");
            if (objectId == null) {
                byte[] byArray = zeroid;
                return byArray;
            }
            byte[] byArray = new byte[20];
            objectId.copyRawTo(byArray, 0);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (IOException iOException) {
            return zeroid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] idBufferBlob(WorkingTreeIterator$Entry workingTreeIterator$Entry) {
        byte[] byArray;
        InputStream inputStream = workingTreeIterator$Entry.openInputStream();
        if (inputStream == null) {
            return zeroid;
        }
        try {
            this.state.initializeReadBuffer();
            long l2 = workingTreeIterator$Entry.getLength();
            InputStream inputStream2 = this.possiblyFilteredInputStream(workingTreeIterator$Entry, inputStream, l2, TreeWalk$OperationType.CHECKIN_OP);
            byArray = this.computeHash(inputStream2, this.canonLen);
        }
        catch (Throwable throwable) {
            try {
                WorkingTreeIterator.safeClose(inputStream);
                throw throwable;
            }
            catch (IOException iOException) {
                return zeroid;
            }
        }
        WorkingTreeIterator.safeClose(inputStream);
        return byArray;
    }

    private InputStream possiblyFilteredInputStream(WorkingTreeIterator$Entry workingTreeIterator$Entry, InputStream inputStream, long l2) {
        return this.possiblyFilteredInputStream(workingTreeIterator$Entry, inputStream, l2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream possiblyFilteredInputStream(WorkingTreeIterator$Entry workingTreeIterator$Entry, InputStream inputStream, long l2, TreeWalk$OperationType treeWalk$OperationType) {
        if (this.getCleanFilterCommand() == null && this.getEolStreamType(treeWalk$OperationType) == CoreConfig$EolStreamType.DIRECT) {
            this.canonLen = l2;
            return inputStream;
        }
        if (l2 <= 65536L) {
            ByteBuffer byteBuffer = IO.readWholeStream(inputStream, (int)l2);
            byteBuffer = this.filterClean(byteBuffer.array(), byteBuffer.limit(), treeWalk$OperationType);
            this.canonLen = byteBuffer.limit();
            return new ByteArrayInputStream(byteBuffer.array(), 0, (int)this.canonLen);
        }
        if (this.getCleanFilterCommand() == null && WorkingTreeIterator.isBinary(workingTreeIterator$Entry)) {
            this.canonLen = l2;
            return inputStream;
        }
        InputStream inputStream2 = this.filterClean(workingTreeIterator$Entry.openInputStream(), treeWalk$OperationType);
        try {
            this.canonLen = WorkingTreeIterator.computeLength(inputStream2);
        }
        finally {
            WorkingTreeIterator.safeClose(inputStream2);
        }
        return this.filterClean(inputStream, treeWalk$OperationType);
    }

    private static void safeClose(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isBinary(WorkingTreeIterator$Entry workingTreeIterator$Entry) {
        InputStream inputStream = workingTreeIterator$Entry.openInputStream();
        try {
            boolean bl2 = RawText.isBinary(inputStream);
            return bl2;
        }
        finally {
            WorkingTreeIterator.safeClose(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer filterClean(byte[] byArray, int n2, TreeWalk$OperationType treeWalk$OperationType) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            ByteBuffer byteBuffer = IO.readWholeStream(this.filterClean(byteArrayInputStream, treeWalk$OperationType), n2);
            return byteBuffer;
        }
        finally {
            WorkingTreeIterator.safeClose(byteArrayInputStream);
        }
    }

    private InputStream filterClean(InputStream inputStream) {
        return this.filterClean(inputStream, null);
    }

    private InputStream filterClean(InputStream inputStream, TreeWalk$OperationType treeWalk$OperationType) {
        inputStream = this.handleAutoCRLF(inputStream, treeWalk$OperationType);
        String string = this.getCleanFilterCommand();
        if (string != null) {
            FS$ExecutionResult fS$ExecutionResult;
            if (FilterCommandRegistry.isRegistered(string)) {
                TemporaryBuffer$LocalFile temporaryBuffer$LocalFile = new TemporaryBuffer$LocalFile(null);
                FilterCommand filterCommand = FilterCommandRegistry.createFilterCommand(string, this.repository, inputStream, temporaryBuffer$LocalFile);
                while (filterCommand.run() != -1) {
                }
                return temporaryBuffer$LocalFile.openInputStreamWithAutoDestroy();
            }
            FS fS = this.repository.getFS();
            ProcessBuilder processBuilder = fS.runInShell(string, new String[0]);
            processBuilder.directory(this.repository.getWorkTree());
            processBuilder.environment().put("GIT_DIR", this.repository.getDirectory().getAbsolutePath());
            if (this.repository.hasCommonDirectory()) {
                processBuilder.environment().put("GIT_COMMON_DIR", this.repository.getCommonDirectory().getAbsolutePath());
            }
            try {
                fS$ExecutionResult = fS.execute(processBuilder, inputStream);
            }
            catch (IOException | InterruptedException exception) {
                throw new IOException(new FilterFailedException(exception, string, this.getEntryPathString()));
            }
            int n2 = fS$ExecutionResult.getRc();
            if (n2 != 0) {
                throw new IOException(new FilterFailedException(n2, string, this.getEntryPathString(), fS$ExecutionResult.getStdout().toByteArray(10240), fS$ExecutionResult.getStderr().toString(10240)));
            }
            return fS$ExecutionResult.getStdout().openInputStreamWithAutoDestroy();
        }
        return inputStream;
    }

    private InputStream handleAutoCRLF(InputStream inputStream, TreeWalk$OperationType treeWalk$OperationType) {
        return EolStreamTypeUtil.wrapInputStream(inputStream, this.getEolStreamType(treeWalk$OperationType));
    }

    public WorkingTreeOptions getOptions() {
        return this.state.options;
    }

    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public int idOffset() {
        return this.contentIdOffset;
    }

    @Override
    public void reset() {
        if (!this.first()) {
            this.ptr = 0;
            if (!this.eof()) {
                this.parseEntry();
            }
        }
    }

    @Override
    public boolean first() {
        return this.ptr == 0;
    }

    @Override
    public boolean eof() {
        return this.ptr == this.entryCnt;
    }

    @Override
    public void next(int n2) {
        this.ptr += n2;
        if (!this.eof()) {
            this.parseEntry();
        }
    }

    @Override
    public void back(int n2) {
        this.ptr -= n2;
        this.parseEntry();
    }

    private void parseEntry() {
        WorkingTreeIterator$Entry workingTreeIterator$Entry = this.entries[this.ptr];
        this.mode = workingTreeIterator$Entry.getMode().getBits();
        int n2 = workingTreeIterator$Entry.encodedNameLen;
        this.ensurePathCapacity(this.pathOffset + n2, this.pathOffset);
        System.arraycopy(workingTreeIterator$Entry.encodedName, 0, this.path, this.pathOffset, n2);
        this.pathLen = this.pathOffset + n2;
        this.canonLen = -1L;
        this.cleanFilterCommandHolder = null;
        this.eolStreamTypeHolder = null;
    }

    public long getEntryLength() {
        return this.current().getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEntryContentLength() {
        if (this.canonLen == -1L) {
            long l2 = this.getEntryLength();
            if (l2 == 0L) {
                this.canonLen = 0L;
            }
            InputStream inputStream = this.current().openInputStream();
            try {
                this.possiblyFilteredInputStream(this.current(), inputStream, this.current().getLength());
            }
            finally {
                WorkingTreeIterator.safeClose(inputStream);
            }
        }
        return this.canonLen;
    }

    @Deprecated
    public long getEntryLastModified() {
        return this.current().getLastModified();
    }

    public Instant getEntryLastModifiedInstant() {
        return this.current().getLastModifiedInstant();
    }

    public InputStream openEntryStream() {
        InputStream inputStream = this.current().openInputStream();
        if (this.getCleanFilterCommand() == null && this.getEolStreamType() == CoreConfig$EolStreamType.DIRECT) {
            return inputStream;
        }
        return this.filterClean(inputStream);
    }

    public boolean isEntryIgnored() {
        return this.isEntryIgnored(this.pathLen);
    }

    protected boolean isEntryIgnored(int n2) {
        return this.isEntryIgnored(n2, this.mode);
    }

    private boolean isEntryIgnored(int n2, int n3) {
        Boolean bl2;
        int n4 = 0 < this.pathOffset ? this.pathOffset - 1 : this.pathOffset;
        String string = TreeWalk.pathOf(this.path, n4, n2);
        String string2 = WorkingTreeIterator.getParentPath(string);
        if (this.isDirectoryIgnored(string2)) {
            return true;
        }
        IgnoreNode ignoreNode = this.getIgnoreNode();
        Boolean bl3 = bl2 = ignoreNode != null ? ignoreNode.checkIgnored(string, FileMode.TREE.equals(n3)) : null;
        if (bl2 != null) {
            return bl2;
        }
        return this.parent instanceof WorkingTreeIterator && ((WorkingTreeIterator)this.parent).isEntryIgnored(n2, n3);
    }

    private IgnoreNode getIgnoreNode() {
        if (this.ignoreNode instanceof WorkingTreeIterator$PerDirectoryIgnoreNode) {
            this.ignoreNode = ((WorkingTreeIterator$PerDirectoryIgnoreNode)this.ignoreNode).load();
        }
        return this.ignoreNode;
    }

    public AttributesNode getEntryAttributesNode() {
        if (this.attributesNode instanceof WorkingTreeIterator$PerDirectoryAttributesNode) {
            this.attributesNode = ((WorkingTreeIterator$PerDirectoryAttributesNode)this.attributesNode).load();
        }
        return this.attributesNode;
    }

    protected void init(WorkingTreeIterator$Entry[] workingTreeIterator$EntryArray) {
        this.entries = workingTreeIterator$EntryArray;
        CharsetEncoder charsetEncoder = this.state.nameEncoder;
        int n2 = 0;
        for (int i2 = 0; i2 < this.entries.length; ++i2) {
            String string;
            WorkingTreeIterator$Entry workingTreeIterator$Entry = this.entries[i2];
            if (workingTreeIterator$Entry == null || ".".equals(string = workingTreeIterator$Entry.getName()) || "..".equals(string) || ".git".equals(string)) continue;
            if (".gitignore".equals(string)) {
                this.ignoreNode = new WorkingTreeIterator$PerDirectoryIgnoreNode(TreeWalk.pathOf(this.path, 0, this.pathOffset) + ".gitignore", workingTreeIterator$Entry);
            }
            if (".gitattributes".equals(string)) {
                this.attributesNode = new WorkingTreeIterator$PerDirectoryAttributesNode(workingTreeIterator$Entry);
            }
            if (i2 != n2) {
                this.entries[n2] = workingTreeIterator$Entry;
            }
            workingTreeIterator$Entry.encodeName(charsetEncoder);
            ++n2;
        }
        this.entryCnt = n2;
        Arrays.sort(this.entries, 0, this.entryCnt, ENTRY_CMP);
        this.contentIdFromPtr = -1;
        this.ptr = 0;
        if (!this.eof()) {
            this.parseEntry();
        } else if (this.pathLen == 0) {
            this.pathLen = this.pathOffset;
        }
    }

    protected WorkingTreeIterator$Entry current() {
        return this.entries[this.ptr];
    }

    public boolean isModeDifferent(int n2) {
        int n3 = this.getEntryRawMode() ^ n2;
        if (n3 == 0) {
            return false;
        }
        if (this.getOptions().getSymLinks() == CoreConfig$SymLinks.FALSE && FileMode.SYMLINK.equals(n2)) {
            return false;
        }
        if (!this.state.options.isFileMode()) {
            n3 &= ~FileMode.EXECUTABLE_FILE.getBits();
        }
        return n3 != 0;
    }

    public WorkingTreeIterator$MetadataDiff compareMetadata(DirCacheEntry dirCacheEntry) {
        Instant instant;
        if (dirCacheEntry.isAssumeValid()) {
            return WorkingTreeIterator$MetadataDiff.EQUAL;
        }
        if (dirCacheEntry.isUpdateNeeded()) {
            return WorkingTreeIterator$MetadataDiff.DIFFER_BY_METADATA;
        }
        if (this.isModeDifferent(dirCacheEntry.getRawMode())) {
            return WorkingTreeIterator$MetadataDiff.DIFFER_BY_METADATA;
        }
        int n2 = this.mode & 0xF000;
        if (n2 == 16384 || n2 == 57344) {
            return WorkingTreeIterator$MetadataDiff.EQUAL;
        }
        if (!dirCacheEntry.isSmudged() && dirCacheEntry.getLength() != (int)this.getEntryLength()) {
            return WorkingTreeIterator$MetadataDiff.DIFFER_BY_METADATA;
        }
        Instant instant2 = dirCacheEntry.getLastModifiedInstant();
        if (this.timestampComparator.compare(instant2, instant = this.getEntryLastModifiedInstant(), this.getOptions().getCheckStat() == CoreConfig$CheckStat.MINIMAL) != 0) {
            return WorkingTreeIterator$MetadataDiff.DIFFER_BY_TIMESTAMP;
        }
        if (dirCacheEntry.isSmudged()) {
            return WorkingTreeIterator$MetadataDiff.SMUDGED;
        }
        return WorkingTreeIterator$MetadataDiff.EQUAL;
    }

    public boolean isModified(DirCacheEntry dirCacheEntry, boolean bl2, ObjectReader objectReader) {
        if (dirCacheEntry == null) {
            return !FileMode.MISSING.equals(this.getEntryFileMode());
        }
        WorkingTreeIterator$MetadataDiff workingTreeIterator$MetadataDiff = this.compareMetadata(dirCacheEntry);
        switch (workingTreeIterator$MetadataDiff) {
            case DIFFER_BY_TIMESTAMP: {
                if (bl2) {
                    return this.contentCheck(dirCacheEntry, objectReader);
                }
                return true;
            }
            case SMUDGED: {
                return this.contentCheck(dirCacheEntry, objectReader);
            }
            case EQUAL: {
                if (this.mode == FileMode.SYMLINK.getBits()) {
                    return this.contentCheck(dirCacheEntry, objectReader);
                }
                return false;
            }
            case DIFFER_BY_METADATA: {
                if (this.mode == FileMode.TREE.getBits() && dirCacheEntry.getFileMode().equals(FileMode.GITLINK)) {
                    byte[] byArray = this.idBuffer();
                    int n2 = this.idOffset();
                    if (dirCacheEntry.getObjectId().compareTo(byArray, n2) == 0) {
                        return true;
                    }
                    if (ObjectId.zeroId().compareTo(byArray, n2) == 0) {
                        Path path = this.repository.getWorkTree().toPath().resolve(dirCacheEntry.getPathString());
                        return FileUtils.hasFiles(path);
                    }
                    return false;
                }
                if (this.mode == FileMode.SYMLINK.getBits()) {
                    return this.contentCheck(dirCacheEntry, objectReader);
                }
                return true;
            }
        }
        throw new IllegalStateException(MessageFormat.format(JGitText.get().unexpectedCompareResult, workingTreeIterator$MetadataDiff.name()));
    }

    public FileMode getIndexFileMode(DirCacheIterator dirCacheIterator) {
        FileMode fileMode = this.getEntryFileMode();
        if (dirCacheIterator == null) {
            return fileMode;
        }
        FileMode fileMode2 = dirCacheIterator.getEntryFileMode();
        if (this.getOptions().isFileMode() && fileMode2 != FileMode.GITLINK && fileMode2 != FileMode.TREE) {
            return fileMode;
        }
        if (!this.getOptions().isFileMode()) {
            if (FileMode.REGULAR_FILE == fileMode && FileMode.EXECUTABLE_FILE == fileMode2) {
                return fileMode2;
            }
            if (FileMode.EXECUTABLE_FILE == fileMode && FileMode.REGULAR_FILE == fileMode2) {
                return fileMode2;
            }
        }
        if (FileMode.GITLINK == fileMode2 && FileMode.TREE == fileMode && !this.getOptions().isDirNoGitLinks()) {
            return fileMode2;
        }
        if (FileMode.TREE == fileMode2 && FileMode.GITLINK == fileMode) {
            return fileMode2;
        }
        return fileMode;
    }

    private boolean contentCheck(DirCacheEntry dirCacheEntry, ObjectReader objectReader) {
        if (this.getEntryObjectId().equals(dirCacheEntry.getObjectId())) {
            dirCacheEntry.setLength((int)this.getEntryLength());
            return false;
        }
        if (this.mode == FileMode.SYMLINK.getBits()) {
            return !new File(this.readSymlinkTarget(this.current())).equals(new File(WorkingTreeIterator.readContentAsNormalizedString(dirCacheEntry, objectReader)));
        }
        return true;
    }

    private static String readContentAsNormalizedString(DirCacheEntry dirCacheEntry, ObjectReader objectReader) {
        ObjectLoader objectLoader = objectReader.open(dirCacheEntry.getObjectId());
        byte[] byArray = objectLoader.getCachedBytes();
        return FS.detect().normalize(RawParseUtils.decode(byArray));
    }

    protected String readSymlinkTarget(WorkingTreeIterator$Entry workingTreeIterator$Entry) {
        if (!workingTreeIterator$Entry.getMode().equals(FileMode.SYMLINK)) {
            throw new NotLinkException(workingTreeIterator$Entry.getName());
        }
        long l2 = workingTreeIterator$Entry.getLength();
        byte[] byArray = new byte[(int)l2];
        try (InputStream inputStream = workingTreeIterator$Entry.openInputStream();){
            int n2 = IO.readFully(inputStream, byArray, 0);
            String string = FS.detect().normalize(RawParseUtils.decode(byArray, 0, n2));
            return string;
        }
    }

    private static long computeLength(InputStream inputStream) {
        long l2;
        long l3 = 0L;
        while ((l2 = inputStream.skip(0x100000L)) > 0L) {
            l3 += l2;
        }
        return l3;
    }

    private byte[] computeHash(InputStream inputStream, long l2) {
        int n2;
        SHA1 sHA1 = SHA1.newInstance();
        byte[] byArray = this.state.contentReadBuffer;
        sHA1.update(hblob);
        sHA1.update((byte)32);
        long l3 = l2;
        if (l3 == 0L) {
            sHA1.update((byte)48);
        } else {
            int n3 = n2 = byArray.length;
            do {
                byArray[--n3] = digits[(int)(l3 % 10L)];
            } while ((l3 /= 10L) > 0L);
            sHA1.update(byArray, n3, n2 - n3);
        }
        sHA1.update((byte)0);
        while ((n2 = inputStream.read(byArray)) > 0) {
            sHA1.update(byArray, 0, n2);
            l3 += (long)n2;
        }
        if (l3 != l2) {
            return zeroid;
        }
        return sHA1.digest();
    }

    public String getCleanFilterCommand() {
        if (this.cleanFilterCommandHolder == null) {
            String string = null;
            if (this.state.walk != null) {
                string = this.state.walk.getFilterCommand("clean");
            }
            this.cleanFilterCommandHolder = new Holder(string);
        }
        return (String)this.cleanFilterCommandHolder.get();
    }

    public CoreConfig$EolStreamType getEolStreamType() {
        return this.getEolStreamType(null);
    }

    private CoreConfig$EolStreamType getEolStreamType(TreeWalk$OperationType treeWalk$OperationType) {
        if (this.eolStreamTypeHolder == null) {
            CoreConfig$EolStreamType coreConfig$EolStreamType = null;
            if (this.state.walk != null) {
                TreeWalk$OperationType treeWalk$OperationType2;
                coreConfig$EolStreamType = this.state.walk.getEolStreamType(treeWalk$OperationType);
                TreeWalk$OperationType treeWalk$OperationType3 = treeWalk$OperationType2 = treeWalk$OperationType != null ? treeWalk$OperationType : this.state.walk.getOperationType();
                if (TreeWalk$OperationType.CHECKIN_OP.equals((Object)treeWalk$OperationType2) && CoreConfig$EolStreamType.AUTO_LF.equals((Object)coreConfig$EolStreamType) && this.hasCrLfInIndex(this.getDirCacheIterator())) {
                    coreConfig$EolStreamType = CoreConfig$EolStreamType.DIRECT;
                }
            } else {
                switch (this.getOptions().getAutoCRLF()) {
                    case FALSE: {
                        coreConfig$EolStreamType = CoreConfig$EolStreamType.DIRECT;
                        break;
                    }
                    case TRUE: 
                    case INPUT: {
                        coreConfig$EolStreamType = CoreConfig$EolStreamType.AUTO_LF;
                    }
                }
            }
            this.eolStreamTypeHolder = new Holder((Object)coreConfig$EolStreamType);
        }
        return (CoreConfig$EolStreamType)((Object)this.eolStreamTypeHolder.get());
    }

    /*
     * Exception decompiling
     */
    private boolean hasCrLfInIndex(DirCacheIterator var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isDirectoryIgnored(String string) {
        int n2 = 0 < this.pathOffset ? this.pathOffset - 1 : this.pathOffset;
        String string2 = TreeWalk.pathOf(this.path, 0, n2);
        String string3 = WorkingTreeIterator.concatPath(string2, string);
        return this.isDirectoryIgnored(string, string3);
    }

    private boolean isDirectoryIgnored(String string, String string2) {
        assert (string.length() == 0 || string.charAt(0) != '/' && string.charAt(string.length() - 1) != '/');
        assert (string2.length() == 0 || string2.charAt(0) != '/' && string2.charAt(string2.length() - 1) != '/');
        assert (string2.endsWith(string));
        Boolean bl2 = (Boolean)this.state.directoryToIgnored.get(string2);
        if (bl2 != null) {
            return bl2;
        }
        String string3 = WorkingTreeIterator.getParentPath(string);
        if (string3 != null && this.isDirectoryIgnored(string3)) {
            this.state.directoryToIgnored.put(string2, Boolean.TRUE);
            return true;
        }
        IgnoreNode ignoreNode = this.getIgnoreNode();
        Object object = string;
        while (ignoreNode != null && !"".equals(object)) {
            bl2 = ignoreNode.checkIgnored((String)object, true);
            if (bl2 != null) {
                this.state.directoryToIgnored.put(string2, bl2);
                return bl2;
            }
            object = WorkingTreeIterator.getParentPath((String)object);
        }
        if (!(this.parent instanceof WorkingTreeIterator)) {
            this.state.directoryToIgnored.put(string2, Boolean.FALSE);
            return false;
        }
        object = (WorkingTreeIterator)this.parent;
        String string4 = WorkingTreeIterator.concatPath(TreeWalk.pathOf(this.path, ((WorkingTreeIterator)object).pathOffset, this.pathOffset - 1), string);
        assert (WorkingTreeIterator.concatPath(TreeWalk.pathOf(((WorkingTreeIterator)object).path, 0, Math.max(0, ((WorkingTreeIterator)object).pathOffset - 1)), string4).equals(string2));
        return super.isDirectoryIgnored(string4, string2);
    }

    private static String getParentPath(String string) {
        int n2 = string.lastIndexOf(47, string.length() - 2);
        if (n2 > 0) {
            return string.substring(string.charAt(0) == '/' ? 1 : 0, n2);
        }
        return string.length() > 0 ? "" : null;
    }

    private static String concatPath(String string, String string2) {
        return string + (string.length() > 0 && string2.length() > 0 ? "/" : "") + string2;
    }
}

