/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.WorkingTreeIterator$Entry;
import org.eclipse.jgit.treewalk.WorkingTreeIterator$PerDirectoryIgnoreNode;
import org.eclipse.jgit.util.FS;

class WorkingTreeIterator$RootIgnoreNode
extends WorkingTreeIterator$PerDirectoryIgnoreNode {
    final Repository repository;

    WorkingTreeIterator$RootIgnoreNode(WorkingTreeIterator$Entry workingTreeIterator$Entry, Repository repository) {
        super(workingTreeIterator$Entry != null ? workingTreeIterator$Entry.getName() : null, workingTreeIterator$Entry);
        this.repository = repository;
    }

    @Override
    IgnoreNode load() {
        IgnoreNode ignoreNode;
        if (this.entry != null) {
            ignoreNode = super.load();
            if (ignoreNode == null) {
                ignoreNode = new IgnoreNode();
            }
        } else {
            ignoreNode = new IgnoreNode();
        }
        FS fS = this.repository.getFS();
        Path path = this.repository.getConfig().getPath("core", null, "excludesfile", fS, null, null);
        if (path != null) {
            WorkingTreeIterator$RootIgnoreNode.loadRulesFromFile(ignoreNode, path.toFile());
        }
        File file = this.repository.resolveDirectoryChild("info/exclude");
        WorkingTreeIterator$RootIgnoreNode.loadRulesFromFile(ignoreNode, file);
        return ignoreNode.getRules().isEmpty() ? null : ignoreNode;
    }

    private static void loadRulesFromFile(IgnoreNode ignoreNode, File file) {
        if (FS.DETECTED.exists(file)) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                ignoreNode.parse(file.getAbsolutePath(), fileInputStream);
            }
        }
    }
}

