/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.text.MessageFormat;
import java.time.Instant;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.FileMode;

public abstract class WorkingTreeIterator$Entry {
    byte[] encodedName;
    int encodedNameLen;

    void encodeName(CharsetEncoder charsetEncoder) {
        ByteBuffer byteBuffer;
        try {
            byteBuffer = charsetEncoder.encode(CharBuffer.wrap(this.getName()));
        }
        catch (CharacterCodingException characterCodingException) {
            throw new RuntimeException(MessageFormat.format(JGitText.get().unencodeableFile, this.getName()), characterCodingException);
        }
        this.encodedNameLen = byteBuffer.limit();
        if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
            this.encodedName = byteBuffer.array();
        } else {
            this.encodedName = new byte[this.encodedNameLen];
            byteBuffer.get(this.encodedName);
        }
    }

    public String toString() {
        return this.getMode().toString() + " " + this.getName();
    }

    public abstract FileMode getMode();

    public abstract long getLength();

    @Deprecated
    public abstract long getLastModified();

    public abstract Instant getLastModifiedInstant();

    public abstract String getName();

    public abstract InputStream openInputStream();
}

