/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.Attributes;
import org.eclipse.jgit.attributes.AttributesHandler;
import org.eclipse.jgit.attributes.AttributesNodeProvider;
import org.eclipse.jgit.attributes.AttributesProvider;
import org.eclipse.jgit.attributes.FilterCommandRegistry;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.CoreConfig$EolStreamType;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk$OperationType;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.QuotedString;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.io.EolStreamTypeUtil;

public class TreeWalk
implements AutoCloseable,
AttributesProvider {
    private static final AbstractTreeIterator[] NO_TREES = new AbstractTreeIterator[0];
    private TreeWalk$OperationType operationType = TreeWalk$OperationType.CHECKOUT_OP;
    private Map filterCommandsByNameDotType = new HashMap();
    private final ObjectReader reader;
    private final boolean closeReader;
    private final MutableObjectId idBuffer = new MutableObjectId();
    private TreeFilter filter;
    AbstractTreeIterator[] trees;
    private boolean recursive;
    private boolean postOrderTraversal;
    int depth;
    private boolean advance;
    private boolean postChildren;
    private AttributesNodeProvider attributesNodeProvider;
    AbstractTreeIterator currentHead;
    private Attributes attrs = null;
    private AttributesHandler attributesHandler;
    private Config config;
    private Set filterCommands;

    public void setOperationType(TreeWalk$OperationType treeWalk$OperationType) {
        this.operationType = treeWalk$OperationType;
    }

    public static TreeWalk forPath(ObjectReader objectReader, String string, AnyObjectId ... anyObjectIdArray) {
        return TreeWalk.forPath(null, objectReader, string, anyObjectIdArray);
    }

    public static TreeWalk forPath(@Nullable Repository repository, ObjectReader objectReader, String string, AnyObjectId ... anyObjectIdArray) {
        TreeWalk treeWalk = new TreeWalk(repository, objectReader);
        PathFilter pathFilter = PathFilter.create(string);
        treeWalk.setFilter(pathFilter);
        treeWalk.reset(anyObjectIdArray);
        treeWalk.setRecursive(false);
        while (treeWalk.next()) {
            if (pathFilter.isDone(treeWalk)) {
                return treeWalk;
            }
            if (!treeWalk.isSubtree()) continue;
            treeWalk.enterSubtree();
        }
        return null;
    }

    public static TreeWalk forPath(Repository repository, String string, AnyObjectId ... anyObjectIdArray) {
        try (ObjectReader objectReader = repository.newObjectReader();){
            TreeWalk treeWalk = TreeWalk.forPath(repository, objectReader, string, anyObjectIdArray);
            return treeWalk;
        }
    }

    public static TreeWalk forPath(Repository repository, String string, RevTree revTree) {
        return TreeWalk.forPath(repository, string, (AnyObjectId[])new ObjectId[]{revTree});
    }

    public TreeWalk(Repository repository) {
        this(repository, repository.newObjectReader(), true);
    }

    public TreeWalk(@Nullable Repository repository, ObjectReader objectReader) {
        this(repository, objectReader, false);
    }

    public TreeWalk(ObjectReader objectReader) {
        this(null, objectReader, false);
    }

    private TreeWalk(@Nullable Repository repository, ObjectReader objectReader, boolean bl2) {
        if (repository != null) {
            this.config = repository.getConfig();
            this.attributesNodeProvider = repository.createAttributesNodeProvider();
            this.filterCommands = FilterCommandRegistry.getRegisteredFilterCommands();
        } else {
            this.config = null;
            this.attributesNodeProvider = null;
        }
        this.reader = objectReader;
        this.filter = TreeFilter.ALL;
        this.trees = NO_TREES;
        this.closeReader = bl2;
    }

    public ObjectReader getObjectReader() {
        return this.reader;
    }

    public TreeWalk$OperationType getOperationType() {
        return this.operationType;
    }

    @Override
    public void close() {
        if (this.closeReader) {
            this.reader.close();
        }
    }

    public TreeFilter getFilter() {
        return this.filter;
    }

    public void setFilter(TreeFilter treeFilter) {
        this.filter = treeFilter != null ? treeFilter : TreeFilter.ALL;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean bl2) {
        this.recursive = bl2;
    }

    public boolean isPostOrderTraversal() {
        return this.postOrderTraversal;
    }

    public void setPostOrderTraversal(boolean bl2) {
        this.postOrderTraversal = bl2;
    }

    public void setAttributesNodeProvider(AttributesNodeProvider attributesNodeProvider) {
        this.attributesNodeProvider = attributesNodeProvider;
    }

    public AttributesNodeProvider getAttributesNodeProvider() {
        return this.attributesNodeProvider;
    }

    @Override
    public Attributes getAttributes() {
        if (this.attrs != null) {
            return this.attrs;
        }
        if (this.attributesNodeProvider == null) {
            throw new IllegalStateException("The tree walk should have one AttributesNodeProvider set in order to compute the git attributes.");
        }
        try {
            if (this.attributesHandler == null) {
                this.attributesHandler = new AttributesHandler(this);
            }
            this.attrs = this.attributesHandler.getAttributes();
            return this.attrs;
        }
        catch (IOException iOException) {
            throw new JGitInternalException("Error while parsing attributes", iOException);
        }
    }

    @Nullable
    public CoreConfig$EolStreamType getEolStreamType(TreeWalk$OperationType treeWalk$OperationType) {
        if (this.attributesNodeProvider == null || this.config == null) {
            return null;
        }
        return EolStreamTypeUtil.detectStreamType(treeWalk$OperationType != null ? treeWalk$OperationType : this.operationType, (WorkingTreeOptions)this.config.get(WorkingTreeOptions.KEY), this.getAttributes());
    }

    public void reset() {
        this.attrs = null;
        this.attributesHandler = null;
        this.trees = NO_TREES;
        this.advance = false;
        this.depth = 0;
    }

    public void reset(AnyObjectId anyObjectId) {
        if (this.trees.length == 1) {
            AbstractTreeIterator abstractTreeIterator = this.trees[0];
            while (abstractTreeIterator.parent != null) {
                abstractTreeIterator = abstractTreeIterator.parent;
            }
            if (abstractTreeIterator instanceof CanonicalTreeParser) {
                abstractTreeIterator.matches = null;
                abstractTreeIterator.matchShift = 0;
                ((CanonicalTreeParser)abstractTreeIterator).reset(this.reader, anyObjectId);
                this.trees[0] = abstractTreeIterator;
            } else {
                this.trees[0] = this.parserFor(anyObjectId);
            }
        } else {
            this.trees = new AbstractTreeIterator[]{this.parserFor(anyObjectId)};
        }
        this.advance = false;
        this.depth = 0;
        this.attrs = null;
    }

    public void reset(AnyObjectId ... anyObjectIdArray) {
        int n2 = anyObjectIdArray.length;
        int n3 = this.trees.length;
        AbstractTreeIterator[] abstractTreeIteratorArray = n2 == n3 ? this.trees : new AbstractTreeIterator[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            AbstractTreeIterator abstractTreeIterator;
            if (i2 < n3) {
                abstractTreeIterator = this.trees[i2];
                while (abstractTreeIterator.parent != null) {
                    abstractTreeIterator = abstractTreeIterator.parent;
                }
                if (abstractTreeIterator instanceof CanonicalTreeParser && abstractTreeIterator.pathOffset == 0) {
                    abstractTreeIterator.matches = null;
                    abstractTreeIterator.matchShift = 0;
                    ((CanonicalTreeParser)abstractTreeIterator).reset(this.reader, anyObjectIdArray[i2]);
                    abstractTreeIteratorArray[i2] = abstractTreeIterator;
                    continue;
                }
            }
            abstractTreeIteratorArray[i2] = abstractTreeIterator = this.parserFor(anyObjectIdArray[i2]);
        }
        this.trees = abstractTreeIteratorArray;
        this.advance = false;
        this.depth = 0;
        this.attrs = null;
    }

    public int addTree(AnyObjectId anyObjectId) {
        return this.addTree(this.parserFor(anyObjectId));
    }

    public int addTree(AbstractTreeIterator abstractTreeIterator) {
        int n2 = this.trees.length;
        AbstractTreeIterator[] abstractTreeIteratorArray = new AbstractTreeIterator[n2 + 1];
        System.arraycopy(this.trees, 0, abstractTreeIteratorArray, 0, n2);
        abstractTreeIteratorArray[n2] = abstractTreeIterator;
        abstractTreeIterator.matches = null;
        abstractTreeIterator.matchShift = 0;
        this.trees = abstractTreeIteratorArray;
        return n2;
    }

    public int getTreeCount() {
        return this.trees.length;
    }

    public boolean next() {
        try {
            if (this.advance) {
                this.advance = false;
                this.postChildren = false;
                this.popEntriesEqual();
            }
            while (true) {
                this.attrs = null;
                AbstractTreeIterator abstractTreeIterator = this.min();
                if (abstractTreeIterator.eof()) {
                    if (this.depth > 0) {
                        this.exitSubtree();
                        if (this.postOrderTraversal) {
                            this.advance = true;
                            this.postChildren = true;
                            return true;
                        }
                        this.popEntriesEqual();
                        continue;
                    }
                    return false;
                }
                this.currentHead = abstractTreeIterator;
                if (this.filter.matchFilter(this) == 1) {
                    this.skipEntriesEqual();
                    continue;
                }
                if (!this.recursive || !FileMode.TREE.equals(abstractTreeIterator.mode)) break;
                this.enterSubtree();
            }
            this.advance = true;
            return true;
        }
        catch (StopWalkException stopWalkException) {
            this.stopWalk();
            return false;
        }
    }

    void stopWalk() {
        for (AbstractTreeIterator abstractTreeIterator : this.trees) {
            abstractTreeIterator.stopWalk();
        }
    }

    public AbstractTreeIterator getTree(int n2, Class clazz) {
        AbstractTreeIterator abstractTreeIterator = this.trees[n2];
        return abstractTreeIterator.matches == this.currentHead ? abstractTreeIterator : null;
    }

    public int getRawMode(int n2) {
        AbstractTreeIterator abstractTreeIterator = this.trees[n2];
        return abstractTreeIterator.matches == this.currentHead ? abstractTreeIterator.mode : 0;
    }

    public FileMode getFileMode(int n2) {
        return FileMode.fromBits(this.getRawMode(n2));
    }

    public FileMode getFileMode() {
        return FileMode.fromBits(this.currentHead.mode);
    }

    public ObjectId getObjectId(int n2) {
        AbstractTreeIterator abstractTreeIterator = this.trees[n2];
        return abstractTreeIterator.matches == this.currentHead ? abstractTreeIterator.getEntryObjectId() : ObjectId.zeroId();
    }

    public void getObjectId(MutableObjectId mutableObjectId, int n2) {
        AbstractTreeIterator abstractTreeIterator = this.trees[n2];
        if (abstractTreeIterator.matches == this.currentHead) {
            abstractTreeIterator.getEntryObjectId(mutableObjectId);
        } else {
            mutableObjectId.clear();
        }
    }

    public boolean idEqual(int n2, int n3) {
        AbstractTreeIterator abstractTreeIterator = this.currentHead;
        AbstractTreeIterator abstractTreeIterator2 = this.trees[n2];
        AbstractTreeIterator abstractTreeIterator3 = this.trees[n3];
        if (abstractTreeIterator2.matches != abstractTreeIterator && abstractTreeIterator3.matches != abstractTreeIterator) {
            return true;
        }
        if (!abstractTreeIterator2.hasId() || !abstractTreeIterator3.hasId()) {
            return false;
        }
        if (abstractTreeIterator2.matches == abstractTreeIterator && abstractTreeIterator3.matches == abstractTreeIterator) {
            return abstractTreeIterator2.idEqual(abstractTreeIterator3);
        }
        return false;
    }

    public String getNameString() {
        AbstractTreeIterator abstractTreeIterator = this.currentHead;
        int n2 = abstractTreeIterator.pathOffset;
        int n3 = abstractTreeIterator.pathLen;
        return RawParseUtils.decode(StandardCharsets.UTF_8, abstractTreeIterator.path, n2, n3);
    }

    public String getPathString() {
        return TreeWalk.pathOf(this.currentHead);
    }

    public byte[] getRawPath() {
        AbstractTreeIterator abstractTreeIterator = this.currentHead;
        int n2 = abstractTreeIterator.pathLen;
        byte[] byArray = new byte[n2];
        System.arraycopy(abstractTreeIterator.path, 0, byArray, 0, n2);
        return byArray;
    }

    public int getRawPathLength() {
        return this.currentHead.pathLen;
    }

    public byte[] getRawPathWritable() {
        return this.currentHead.path;
    }

    public int getPathLength() {
        return this.currentHead.pathLen;
    }

    public int isPathMatch(byte[] byArray, int n2) {
        int n3;
        AbstractTreeIterator abstractTreeIterator = this.currentHead;
        byte[] byArray2 = abstractTreeIterator.path;
        int n4 = abstractTreeIterator.pathLen;
        for (n3 = 0; n3 < n4 && n3 < n2; ++n3) {
            int n5 = (byArray2[n3] & 0xFF) - (byArray[n3] & 0xFF);
            if (n5 == 0) continue;
            return 1;
        }
        if (n3 < n4) {
            return byArray2[n3] == 47 ? 0 : 1;
        }
        if (n3 < n2) {
            return byArray[n3] == 47 && FileMode.TREE.equals(abstractTreeIterator.mode) ? -1 : 1;
        }
        return 0;
    }

    public int isPathPrefix(byte[] byArray, int n2) {
        int n3;
        AbstractTreeIterator abstractTreeIterator = this.currentHead;
        byte[] byArray2 = abstractTreeIterator.path;
        int n4 = abstractTreeIterator.pathLen;
        for (n3 = 0; n3 < n4 && n3 < n2; ++n3) {
            int n5 = (byArray2[n3] & 0xFF) - (byArray[n3] & 0xFF);
            if (n5 == 0) continue;
            return n5;
        }
        if (n3 < n4) {
            return byArray2[n3] == 47 ? 0 : -1;
        }
        if (n3 < n2) {
            return byArray[n3] == 47 && FileMode.TREE.equals(abstractTreeIterator.mode) ? 0 : -1;
        }
        return 0;
    }

    public boolean isPathSuffix(byte[] byArray, int n2) {
        AbstractTreeIterator abstractTreeIterator = this.currentHead;
        byte[] byArray2 = abstractTreeIterator.path;
        int n3 = abstractTreeIterator.pathLen;
        for (int i2 = 1; i2 <= n2; ++i2) {
            if (i2 > n3) {
                return false;
            }
            if (byArray2[n3 - i2] == byArray[n2 - i2]) continue;
            return false;
        }
        return true;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isSubtree() {
        return FileMode.TREE.equals(this.currentHead.mode);
    }

    public boolean isPostChildren() {
        return this.postChildren && this.isSubtree();
    }

    public void enterSubtree() {
        this.attrs = null;
        AbstractTreeIterator abstractTreeIterator = this.currentHead;
        AbstractTreeIterator[] abstractTreeIteratorArray = new AbstractTreeIterator[this.trees.length];
        for (int i2 = 0; i2 < this.trees.length; ++i2) {
            AbstractTreeIterator abstractTreeIterator2 = this.trees[i2];
            AbstractTreeIterator abstractTreeIterator3 = abstractTreeIterator2.matches == abstractTreeIterator && !abstractTreeIterator2.eof() && (FileMode.TREE.equals(abstractTreeIterator2.mode) || FileMode.GITLINK.equals(abstractTreeIterator2.mode) && abstractTreeIterator2.isWorkTree()) ? abstractTreeIterator2.createSubtreeIterator(this.reader, this.idBuffer) : abstractTreeIterator2.createEmptyTreeIterator();
            abstractTreeIteratorArray[i2] = abstractTreeIterator3;
        }
        ++this.depth;
        this.advance = false;
        System.arraycopy(abstractTreeIteratorArray, 0, this.trees, 0, this.trees.length);
    }

    AbstractTreeIterator min() {
        int n2 = 0;
        AbstractTreeIterator abstractTreeIterator = this.trees[n2];
        while (abstractTreeIterator.eof() && ++n2 < this.trees.length) {
            abstractTreeIterator = this.trees[n2];
        }
        if (abstractTreeIterator.eof()) {
            return abstractTreeIterator;
        }
        abstractTreeIterator.matches = abstractTreeIterator;
        while (++n2 < this.trees.length) {
            AbstractTreeIterator abstractTreeIterator2 = this.trees[n2];
            if (abstractTreeIterator2.eof()) continue;
            int n3 = abstractTreeIterator2.pathCompare(abstractTreeIterator);
            if (n3 < 0) {
                abstractTreeIterator2.matches = abstractTreeIterator2;
                abstractTreeIterator = abstractTreeIterator2;
                continue;
            }
            if (n3 != 0) continue;
            abstractTreeIterator2.matches = abstractTreeIterator;
        }
        return abstractTreeIterator;
    }

    void popEntriesEqual() {
        AbstractTreeIterator abstractTreeIterator = this.currentHead;
        for (AbstractTreeIterator abstractTreeIterator2 : this.trees) {
            if (abstractTreeIterator2.matches != abstractTreeIterator) continue;
            abstractTreeIterator2.next(1);
            abstractTreeIterator2.matches = null;
        }
    }

    void skipEntriesEqual() {
        AbstractTreeIterator abstractTreeIterator = this.currentHead;
        for (AbstractTreeIterator abstractTreeIterator2 : this.trees) {
            if (abstractTreeIterator2.matches != abstractTreeIterator) continue;
            abstractTreeIterator2.skip();
            abstractTreeIterator2.matches = null;
        }
    }

    void exitSubtree() {
        --this.depth;
        for (int i2 = 0; i2 < this.trees.length; ++i2) {
            this.trees[i2] = this.trees[i2].parent;
        }
        AbstractTreeIterator abstractTreeIterator = null;
        for (AbstractTreeIterator abstractTreeIterator2 : this.trees) {
            if (abstractTreeIterator2.matches != abstractTreeIterator2 || abstractTreeIterator != null && abstractTreeIterator2.pathCompare(abstractTreeIterator) >= 0) continue;
            abstractTreeIterator = abstractTreeIterator2;
        }
        this.currentHead = abstractTreeIterator;
    }

    private CanonicalTreeParser parserFor(AnyObjectId anyObjectId) {
        CanonicalTreeParser canonicalTreeParser = new CanonicalTreeParser();
        canonicalTreeParser.reset(this.reader, anyObjectId);
        return canonicalTreeParser;
    }

    static String pathOf(AbstractTreeIterator abstractTreeIterator) {
        return RawParseUtils.decode(StandardCharsets.UTF_8, abstractTreeIterator.path, 0, abstractTreeIterator.pathLen);
    }

    static String pathOf(byte[] byArray, int n2, int n3) {
        return RawParseUtils.decode(StandardCharsets.UTF_8, byArray, n2, n3);
    }

    public AbstractTreeIterator getTree(Class clazz) {
        for (AbstractTreeIterator abstractTreeIterator : this.trees) {
            if (!clazz.isInstance(abstractTreeIterator)) continue;
            return (AbstractTreeIterator)clazz.cast(abstractTreeIterator);
        }
        return null;
    }

    public String getFilterCommand(String string) {
        Attributes attributes = this.getAttributes();
        Attribute attribute = attributes.get("filter");
        if (attribute == null) {
            return null;
        }
        String string2 = attribute.getValue();
        if (string2 == null) {
            return null;
        }
        String string3 = this.getFilterCommandDefinition(string2, string);
        if (string3 == null) {
            return null;
        }
        return string3.replaceAll("%f", Matcher.quoteReplacement(QuotedString.BOURNE.quote(this.getPathString())));
    }

    private String getFilterCommandDefinition(String string, String string2) {
        String string3 = string + "." + string2;
        String string4 = (String)this.filterCommandsByNameDotType.get(string3);
        if (string4 != null) {
            return string4;
        }
        string4 = this.config.getString("filter", string, string2);
        boolean bl2 = this.config.getBoolean("filter", string, "useJGitBuiltin", false);
        if (bl2) {
            String string5 = "jgit://builtin/" + string + '/' + string2;
            if (this.filterCommands != null && this.filterCommands.contains(string5)) {
                string4 = string5;
            }
        }
        if (string4 != null) {
            this.filterCommandsByNameDotType.put(string3, string4);
        }
        return string4;
    }
}

