/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;

public class NameConflictTreeWalk
extends TreeWalk {
    private static final int TREE_MODE = FileMode.TREE.getBits();
    private boolean fastMinHasMatch;
    private AbstractTreeIterator dfConflict;

    public NameConflictTreeWalk(Repository repository) {
        super(repository);
    }

    public NameConflictTreeWalk(@Nullable Repository repository, ObjectReader objectReader) {
        super(repository, objectReader);
    }

    public NameConflictTreeWalk(ObjectReader objectReader) {
        super(objectReader);
    }

    @Override
    AbstractTreeIterator min() {
        AbstractTreeIterator abstractTreeIterator;
        block4: {
            block0: while (true) {
                abstractTreeIterator = this.fastMin();
                if (this.fastMinHasMatch) {
                    return abstractTreeIterator;
                }
                if (!NameConflictTreeWalk.isTree(abstractTreeIterator)) break block4;
                if (!this.skipEntry(abstractTreeIterator)) break;
                AbstractTreeIterator[] abstractTreeIteratorArray = this.trees;
                int n2 = abstractTreeIteratorArray.length;
                int n3 = 0;
                while (true) {
                    if (n3 >= n2) continue block0;
                    AbstractTreeIterator abstractTreeIterator2 = abstractTreeIteratorArray[n3];
                    if (abstractTreeIterator2.matches == abstractTreeIterator) {
                        abstractTreeIterator2.next(1);
                        abstractTreeIterator2.matches = null;
                    }
                    ++n3;
                }
                break;
            }
            return abstractTreeIterator;
        }
        return this.combineDF(abstractTreeIterator);
    }

    private AbstractTreeIterator fastMin() {
        this.fastMinHasMatch = true;
        int n2 = 0;
        AbstractTreeIterator abstractTreeIterator = this.trees[n2];
        while (abstractTreeIterator.eof() && ++n2 < this.trees.length) {
            abstractTreeIterator = this.trees[n2];
        }
        if (abstractTreeIterator.eof()) {
            return abstractTreeIterator;
        }
        boolean bl2 = false;
        abstractTreeIterator.matches = abstractTreeIterator;
        while (++n2 < this.trees.length) {
            AbstractTreeIterator abstractTreeIterator2 = this.trees[n2];
            if (abstractTreeIterator2.eof()) continue;
            int n3 = abstractTreeIterator2.pathCompare(abstractTreeIterator);
            if (n3 < 0) {
                if (this.fastMinHasMatch && NameConflictTreeWalk.isTree(abstractTreeIterator) && !NameConflictTreeWalk.isTree(abstractTreeIterator2) && NameConflictTreeWalk.nameEqual(abstractTreeIterator, abstractTreeIterator2)) {
                    abstractTreeIterator2.matches = abstractTreeIterator;
                    bl2 = true;
                    continue;
                }
                this.fastMinHasMatch = false;
                abstractTreeIterator2.matches = abstractTreeIterator2;
                abstractTreeIterator = abstractTreeIterator2;
                continue;
            }
            if (n3 == 0) {
                abstractTreeIterator2.matches = abstractTreeIterator;
                continue;
            }
            if (this.fastMinHasMatch && NameConflictTreeWalk.isTree(abstractTreeIterator2) && !NameConflictTreeWalk.isTree(abstractTreeIterator) && !this.isGitlink(abstractTreeIterator) && NameConflictTreeWalk.nameEqual(abstractTreeIterator2, abstractTreeIterator)) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    AbstractTreeIterator abstractTreeIterator3 = this.trees[i2];
                    if (abstractTreeIterator3.matches != abstractTreeIterator) continue;
                    abstractTreeIterator3.matches = abstractTreeIterator2;
                }
                abstractTreeIterator2.matches = abstractTreeIterator2;
                abstractTreeIterator = abstractTreeIterator2;
                bl2 = true;
                continue;
            }
            this.fastMinHasMatch = false;
        }
        if (bl2 && this.fastMinHasMatch && this.dfConflict == null) {
            this.dfConflict = abstractTreeIterator;
        }
        return abstractTreeIterator;
    }

    private static boolean nameEqual(AbstractTreeIterator abstractTreeIterator, AbstractTreeIterator abstractTreeIterator2) {
        return abstractTreeIterator.pathCompare(abstractTreeIterator2, TREE_MODE) == 0;
    }

    private boolean isGitlink(AbstractTreeIterator abstractTreeIterator) {
        return FileMode.GITLINK.equals(abstractTreeIterator.mode);
    }

    private static boolean isTree(AbstractTreeIterator abstractTreeIterator) {
        return FileMode.TREE.equals(abstractTreeIterator.mode);
    }

    private boolean skipEntry(AbstractTreeIterator abstractTreeIterator) {
        for (AbstractTreeIterator abstractTreeIterator2 : this.trees) {
            int n2;
            if (abstractTreeIterator2.matches == abstractTreeIterator || abstractTreeIterator2.first()) continue;
            int n3 = 0;
            do {
                ++n3;
                abstractTreeIterator2.back(1);
                n2 = abstractTreeIterator2.pathCompare(abstractTreeIterator, 0);
                if (n2 != 0) continue;
                abstractTreeIterator2.next(n3);
                return true;
            } while (n2 >= 0 && !abstractTreeIterator2.first());
            abstractTreeIterator2.next(n3);
        }
        return false;
    }

    private AbstractTreeIterator combineDF(AbstractTreeIterator abstractTreeIterator) {
        AbstractTreeIterator abstractTreeIterator2 = null;
        block0: for (AbstractTreeIterator abstractTreeIterator3 : this.trees) {
            int n2;
            if (abstractTreeIterator3.matches == abstractTreeIterator || abstractTreeIterator3.eof()) continue;
            while ((n2 = abstractTreeIterator3.pathCompare(abstractTreeIterator, TREE_MODE)) < 0) {
                ++abstractTreeIterator3.matchShift;
                abstractTreeIterator3.next(1);
                if (!abstractTreeIterator3.eof()) continue;
                abstractTreeIterator3.back(abstractTreeIterator3.matchShift);
                abstractTreeIterator3.matchShift = 0;
                continue block0;
            }
            if (n2 == 0) {
                abstractTreeIterator3.matches = abstractTreeIterator;
                abstractTreeIterator2 = abstractTreeIterator3;
                continue;
            }
            if (abstractTreeIterator3.matchShift == 0) continue;
            abstractTreeIterator3.back(abstractTreeIterator3.matchShift);
            abstractTreeIterator3.matchShift = 0;
        }
        if (abstractTreeIterator2 != null) {
            for (AbstractTreeIterator abstractTreeIterator3 : this.trees) {
                if (abstractTreeIterator3.matches != abstractTreeIterator) continue;
                abstractTreeIterator3.matches = abstractTreeIterator2;
            }
            if (this.dfConflict == null && !this.isGitlink(abstractTreeIterator)) {
                this.dfConflict = abstractTreeIterator2;
            }
            return abstractTreeIterator2;
        }
        return abstractTreeIterator;
    }

    @Override
    void popEntriesEqual() {
        AbstractTreeIterator abstractTreeIterator = this.currentHead;
        for (AbstractTreeIterator abstractTreeIterator2 : this.trees) {
            if (abstractTreeIterator2.matches != abstractTreeIterator) continue;
            if (abstractTreeIterator2.matchShift == 0) {
                abstractTreeIterator2.next(1);
            } else {
                abstractTreeIterator2.back(abstractTreeIterator2.matchShift);
                abstractTreeIterator2.matchShift = 0;
            }
            abstractTreeIterator2.matches = null;
        }
        if (abstractTreeIterator == this.dfConflict) {
            this.dfConflict = null;
        }
    }

    @Override
    void skipEntriesEqual() {
        AbstractTreeIterator abstractTreeIterator = this.currentHead;
        for (AbstractTreeIterator abstractTreeIterator2 : this.trees) {
            if (abstractTreeIterator2.matches != abstractTreeIterator) continue;
            if (abstractTreeIterator2.matchShift == 0) {
                abstractTreeIterator2.skip();
            } else {
                abstractTreeIterator2.back(abstractTreeIterator2.matchShift);
                abstractTreeIterator2.matchShift = 0;
            }
            abstractTreeIterator2.matches = null;
        }
        if (abstractTreeIterator == this.dfConflict) {
            this.dfConflict = null;
        }
    }

    @Override
    void stopWalk() {
        if (!this.needsStopWalk()) {
            return;
        }
        while (true) {
            AbstractTreeIterator abstractTreeIterator;
            if ((abstractTreeIterator = this.min()).eof()) {
                if (this.depth > 0) {
                    this.exitSubtree();
                    this.popEntriesEqual();
                    continue;
                }
                return;
            }
            this.currentHead = abstractTreeIterator;
            this.skipEntriesEqual();
        }
    }

    private boolean needsStopWalk() {
        for (AbstractTreeIterator abstractTreeIterator : this.trees) {
            if (!abstractTreeIterator.needsStopWalk()) continue;
            return true;
        }
        return false;
    }

    public boolean isDirectoryFileConflict() {
        return this.dfConflict != null;
    }
}

