/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.File;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator$DefaultFileModeStrategy;
import org.eclipse.jgit.treewalk.FileTreeIterator$FileEntry;
import org.eclipse.jgit.treewalk.FileTreeIterator$FileModeStrategy;
import org.eclipse.jgit.treewalk.FileTreeIterator$NoGitlinksStrategy;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator$Entry;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.FS;

public class FileTreeIterator
extends WorkingTreeIterator {
    protected final File directory;
    protected final FS fs;
    protected final FileTreeIterator$FileModeStrategy fileModeStrategy;

    public FileTreeIterator(Repository repository) {
        this(repository, ((WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY)).isDirNoGitLinks() ? FileTreeIterator$NoGitlinksStrategy.INSTANCE : FileTreeIterator$DefaultFileModeStrategy.INSTANCE);
    }

    public FileTreeIterator(Repository repository, FileTreeIterator$FileModeStrategy fileTreeIterator$FileModeStrategy) {
        this(repository.getWorkTree(), repository.getFS(), (WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY), fileTreeIterator$FileModeStrategy);
        this.initRootIterator(repository);
    }

    public FileTreeIterator(File file, FS fS, WorkingTreeOptions workingTreeOptions) {
        this(file, fS, workingTreeOptions, (FileTreeIterator$FileModeStrategy)FileTreeIterator$DefaultFileModeStrategy.INSTANCE);
    }

    public FileTreeIterator(File file, FS fS, WorkingTreeOptions workingTreeOptions, FileTreeIterator$FileModeStrategy fileTreeIterator$FileModeStrategy) {
        super(workingTreeOptions);
        this.directory = file;
        this.fs = fS;
        this.fileModeStrategy = fileTreeIterator$FileModeStrategy;
        this.init(this.entries());
    }

    protected FileTreeIterator(FileTreeIterator fileTreeIterator, File file, FS fS) {
        this(fileTreeIterator, file, fS, fileTreeIterator.fileModeStrategy);
    }

    protected FileTreeIterator(WorkingTreeIterator workingTreeIterator, File file, FS fS, FileTreeIterator$FileModeStrategy fileTreeIterator$FileModeStrategy) {
        super(workingTreeIterator);
        this.directory = file;
        this.fs = fS;
        this.fileModeStrategy = fileTreeIterator$FileModeStrategy;
        this.init(this.entries());
    }

    @Override
    public AbstractTreeIterator createSubtreeIterator(ObjectReader objectReader) {
        DirCacheIterator dirCacheIterator;
        if (!this.walksIgnoredDirectories() && this.isEntryIgnored() && (dirCacheIterator = this.getDirCacheIterator()) == null) {
            return new EmptyTreeIterator(this);
        }
        return this.enterSubtree();
    }

    protected AbstractTreeIterator enterSubtree() {
        return new FileTreeIterator(this, ((FileTreeIterator$FileEntry)this.current()).getFile(), this.fs, this.fileModeStrategy);
    }

    private WorkingTreeIterator$Entry[] entries() {
        return this.fs.list(this.directory, this.fileModeStrategy);
    }

    public File getDirectory() {
        return this.directory;
    }

    public File getEntryFile() {
        return ((FileTreeIterator$FileEntry)this.current()).getFile();
    }

    @Override
    protected byte[] idSubmodule(WorkingTreeIterator$Entry workingTreeIterator$Entry) {
        return this.idSubmodule(this.getDirectory(), workingTreeIterator$Entry);
    }

    @Override
    protected String readSymlinkTarget(WorkingTreeIterator$Entry workingTreeIterator$Entry) {
        return this.fs.readSymLink(this.getEntryFile());
    }
}

