/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.treewalk.FileTreeIterator$DefaultFileModeStrategy;
import org.eclipse.jgit.treewalk.FileTreeIterator$FileModeStrategy;
import org.eclipse.jgit.treewalk.WorkingTreeIterator$Entry;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS$Attributes;

public class FileTreeIterator$FileEntry
extends WorkingTreeIterator$Entry {
    private final FileMode mode;
    private FS$Attributes attributes;
    private FS fs;

    public FileTreeIterator$FileEntry(File file, FS fS) {
        this(file, fS, FileTreeIterator$DefaultFileModeStrategy.INSTANCE);
    }

    public FileTreeIterator$FileEntry(File file, FS fS, FileTreeIterator$FileModeStrategy fileTreeIterator$FileModeStrategy) {
        this.fs = fS;
        file = fS.normalize(file);
        this.attributes = fS.getAttributes(file);
        this.mode = fileTreeIterator$FileModeStrategy.getMode(file, this.attributes);
    }

    public FileTreeIterator$FileEntry(File file, FS fS, FS$Attributes attributes, FileTreeIterator$FileModeStrategy fileTreeIterator$FileModeStrategy) {
        this.fs = fS;
        this.attributes = attributes;
        file = fS.normalize(file);
        this.mode = fileTreeIterator$FileModeStrategy.getMode(file, attributes);
    }

    @Override
    public FileMode getMode() {
        return this.mode;
    }

    @Override
    public String getName() {
        return this.attributes.getName();
    }

    @Override
    public long getLength() {
        return this.attributes.getLength();
    }

    @Override
    @Deprecated
    public long getLastModified() {
        return this.attributes.getLastModifiedInstant().toEpochMilli();
    }

    @Override
    public Instant getLastModifiedInstant() {
        return this.attributes.getLastModifiedInstant();
    }

    @Override
    public InputStream openInputStream() {
        if (this.attributes.isSymbolicLink()) {
            return new ByteArrayInputStream(this.fs.readSymLink(this.getFile()).getBytes(StandardCharsets.UTF_8));
        }
        return new FileInputStream(this.getFile());
    }

    public File getFile() {
        return this.attributes.getFile();
    }
}

