/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.util.Arrays;
import java.util.Collections;
import org.eclipse.jgit.attributes.AttributesNode;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;

public class CanonicalTreeParser
extends AbstractTreeIterator {
    private static final byte[] EMPTY = new byte[0];
    private static final byte[] ATTRS = Constants.encode(".gitattributes");
    private byte[] raw;
    private int prevPtr;
    private int currPtr;
    private int nextPtr;

    public CanonicalTreeParser() {
        this.reset(EMPTY);
    }

    public CanonicalTreeParser(byte[] byArray, ObjectReader objectReader, AnyObjectId anyObjectId) {
        super(byArray);
        this.reset(objectReader, anyObjectId);
    }

    private CanonicalTreeParser(CanonicalTreeParser canonicalTreeParser) {
        super(canonicalTreeParser);
    }

    @Deprecated
    public CanonicalTreeParser getParent() {
        return (CanonicalTreeParser)this.parent;
    }

    public void reset(byte[] byArray) {
        this.attributesNode = null;
        this.raw = byArray;
        this.prevPtr = -1;
        this.currPtr = 0;
        if (this.eof()) {
            this.nextPtr = 0;
        } else {
            this.parseEntry();
        }
    }

    public CanonicalTreeParser resetRoot(ObjectReader objectReader, AnyObjectId anyObjectId) {
        CanonicalTreeParser canonicalTreeParser = this;
        while (canonicalTreeParser.parent != null) {
            canonicalTreeParser = (CanonicalTreeParser)canonicalTreeParser.parent;
        }
        canonicalTreeParser.reset(objectReader, anyObjectId);
        return canonicalTreeParser;
    }

    public CanonicalTreeParser next() {
        CanonicalTreeParser canonicalTreeParser = this;
        while (canonicalTreeParser.nextPtr == canonicalTreeParser.raw.length) {
            if (canonicalTreeParser.parent == null) {
                canonicalTreeParser.currPtr = canonicalTreeParser.nextPtr;
                return canonicalTreeParser;
            }
            canonicalTreeParser = (CanonicalTreeParser)canonicalTreeParser.parent;
        }
        canonicalTreeParser.prevPtr = canonicalTreeParser.currPtr;
        canonicalTreeParser.currPtr = canonicalTreeParser.nextPtr;
        canonicalTreeParser.parseEntry();
        return canonicalTreeParser;
    }

    public void reset(ObjectReader objectReader, AnyObjectId anyObjectId) {
        this.reset(objectReader.open(anyObjectId, 2).getCachedBytes());
    }

    @Override
    public CanonicalTreeParser createSubtreeIterator(ObjectReader objectReader, MutableObjectId mutableObjectId) {
        mutableObjectId.fromRaw(this.idBuffer(), this.idOffset());
        if (!FileMode.TREE.equals(this.mode)) {
            ObjectId objectId = mutableObjectId.toObjectId();
            throw new IncorrectObjectTypeException(objectId, "tree");
        }
        return this.createSubtreeIterator0(objectReader, mutableObjectId);
    }

    public final CanonicalTreeParser createSubtreeIterator0(ObjectReader objectReader, AnyObjectId anyObjectId) {
        CanonicalTreeParser canonicalTreeParser = new CanonicalTreeParser(this);
        canonicalTreeParser.reset(objectReader, anyObjectId);
        return canonicalTreeParser;
    }

    @Override
    public CanonicalTreeParser createSubtreeIterator(ObjectReader objectReader) {
        return this.createSubtreeIterator(objectReader, new MutableObjectId());
    }

    @Override
    public boolean hasId() {
        return true;
    }

    @Override
    public byte[] idBuffer() {
        return this.raw;
    }

    @Override
    public int idOffset() {
        return this.nextPtr - 20;
    }

    @Override
    public void reset() {
        if (!this.first()) {
            this.reset(this.raw);
        }
    }

    @Override
    public boolean first() {
        return this.currPtr == 0;
    }

    @Override
    public boolean eof() {
        return this.currPtr == this.raw.length;
    }

    @Override
    public void next(int n2) {
        int n3;
        if (n2 == 1) {
            this.prevPtr = this.currPtr;
            this.currPtr = this.nextPtr;
            if (!this.eof()) {
                this.parseEntry();
            }
            return;
        }
        int n4 = this.raw.length;
        for (n3 = this.nextPtr; --n2 > 0 && n3 != n4; n3 += 21) {
            this.prevPtr = n3;
            while (this.raw[n3] != 0) {
                ++n3;
            }
        }
        if (n2 != 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        this.currPtr = n3;
        if (!this.eof()) {
            this.parseEntry();
        }
    }

    @Override
    public void back(int n2) {
        if (n2 == 1 && 0 <= this.prevPtr) {
            this.currPtr = this.prevPtr;
            this.prevPtr = -1;
            if (!this.eof()) {
                this.parseEntry();
            }
            return;
        }
        if (n2 <= 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        int[] nArray = new int[n2 + 1];
        Arrays.fill(nArray, -1);
        for (int i2 = 0; i2 != this.currPtr; i2 += 21) {
            System.arraycopy(nArray, 1, nArray, 0, n2);
            nArray[n2] = i2;
            while (this.raw[i2] != 0) {
                ++i2;
            }
        }
        if (nArray[1] == -1) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        this.prevPtr = nArray[0];
        this.currPtr = nArray[1];
        this.parseEntry();
    }

    private void parseEntry() {
        int n2 = this.currPtr;
        byte by = this.raw[n2++];
        int n3 = by - 48;
        while (32 != (by = this.raw[n2++])) {
            n3 <<= 3;
            n3 += by - 48;
        }
        this.mode = n3;
        n3 = this.pathOffset;
        while ((by = this.raw[n2++]) != 0) {
            if (n3 >= this.path.length) {
                this.growPath(n3);
            }
            this.path[n3] = by;
            ++n3;
        }
        this.pathLen = n3;
        this.nextPtr = n2 + 20;
    }

    public AttributesNode getEntryAttributesNode(ObjectReader objectReader) {
        if (this.attributesNode == null) {
            this.attributesNode = this.findAttributes(objectReader);
        }
        return this.attributesNode.getRules().isEmpty() ? null : this.attributesNode;
    }

    private AttributesNode findAttributes(ObjectReader objectReader) {
        CanonicalTreeParser canonicalTreeParser = new CanonicalTreeParser();
        canonicalTreeParser.reset(this.raw);
        if (canonicalTreeParser.findFile(ATTRS)) {
            return CanonicalTreeParser.loadAttributes(objectReader, canonicalTreeParser.getEntryObjectId());
        }
        return CanonicalTreeParser.noAttributes();
    }

    private static AttributesNode loadAttributes(ObjectReader objectReader, AnyObjectId anyObjectId) {
        AttributesNode attributesNode = new AttributesNode();
        try (ObjectStream objectStream = objectReader.open(anyObjectId, 3).openStream();){
            attributesNode.parse(objectStream);
        }
        return attributesNode.getRules().isEmpty() ? CanonicalTreeParser.noAttributes() : attributesNode;
    }

    private static AttributesNode noAttributes() {
        return new AttributesNode(Collections.emptyList());
    }
}

