/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.attributes.AttributesNode;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.Paths;

public abstract class AbstractTreeIterator {
    protected static final int DEFAULT_PATH_SIZE = 128;
    protected static final byte[] zeroid = new byte[20];
    public final AbstractTreeIterator parent;
    AbstractTreeIterator matches;
    protected AttributesNode attributesNode;
    int matchShift;
    protected int mode;
    protected byte[] path;
    protected final int pathOffset;
    protected int pathLen;

    protected AbstractTreeIterator() {
        this.parent = null;
        this.path = new byte[128];
        this.pathOffset = 0;
    }

    protected AbstractTreeIterator(String string) {
        this.parent = null;
        if (string != null && string.length() > 0) {
            ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(CharBuffer.wrap(string));
            this.pathLen = byteBuffer.limit();
            this.path = new byte[Math.max(128, this.pathLen + 1)];
            byteBuffer.get(this.path, 0, this.pathLen);
            if (this.path[this.pathLen - 1] != 47) {
                this.path[this.pathLen++] = 47;
            }
            this.pathOffset = this.pathLen;
        } else {
            this.path = new byte[128];
            this.pathOffset = 0;
        }
    }

    protected AbstractTreeIterator(byte[] byArray) {
        this.parent = null;
        if (byArray != null && byArray.length > 0) {
            this.pathLen = byArray.length;
            this.path = new byte[Math.max(128, this.pathLen + 1)];
            System.arraycopy(byArray, 0, this.path, 0, this.pathLen);
            if (this.path[this.pathLen - 1] != 47) {
                this.path[this.pathLen++] = 47;
            }
            this.pathOffset = this.pathLen;
        } else {
            this.path = new byte[128];
            this.pathOffset = 0;
        }
    }

    protected AbstractTreeIterator(AbstractTreeIterator abstractTreeIterator) {
        this.parent = abstractTreeIterator;
        this.path = abstractTreeIterator.path;
        this.pathOffset = abstractTreeIterator.pathLen + 1;
        if (this.pathOffset > this.path.length) {
            this.growPath(abstractTreeIterator.pathLen);
        }
        this.path[this.pathOffset - 1] = 47;
    }

    protected AbstractTreeIterator(AbstractTreeIterator abstractTreeIterator, byte[] byArray, int n2) {
        this.parent = abstractTreeIterator;
        this.path = byArray;
        this.pathOffset = n2;
    }

    protected void growPath(int n2) {
        this.setPathCapacity(this.path.length << 1, n2);
    }

    protected void ensurePathCapacity(int n2, int n3) {
        int n4;
        int n5;
        if (this.path.length >= n2) {
            return;
        }
        byte[] byArray = this.path;
        for (n5 = n4 = byArray.length; n5 < n2 && n5 > 0; n5 <<= 1) {
        }
        this.setPathCapacity(n5, n3);
    }

    private void setPathCapacity(int n2, int n3) {
        byte[] byArray = this.path;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        AbstractTreeIterator abstractTreeIterator = this;
        while (abstractTreeIterator != null && abstractTreeIterator.path == byArray) {
            abstractTreeIterator.path = byArray2;
            abstractTreeIterator = abstractTreeIterator.parent;
        }
    }

    public int pathCompare(AbstractTreeIterator abstractTreeIterator) {
        return this.pathCompare(abstractTreeIterator, abstractTreeIterator.mode);
    }

    int pathCompare(AbstractTreeIterator abstractTreeIterator, int n2) {
        int n3 = AbstractTreeIterator.alreadyMatch(this, abstractTreeIterator);
        return this.pathCompare(abstractTreeIterator.path, n3, abstractTreeIterator.pathLen, n2, n3);
    }

    public boolean findFile(String string) {
        return this.findFile(Constants.encode(string));
    }

    public boolean findFile(byte[] byArray) {
        while (!this.eof()) {
            int n2 = this.pathCompare(byArray, 0, byArray.length, 0, this.pathOffset);
            if (n2 == 0) {
                return true;
            }
            if (n2 > 0) {
                return false;
            }
            this.next(1);
        }
        return false;
    }

    public int pathCompare(byte[] byArray, int n2, int n3, int n4) {
        return this.pathCompare(byArray, n2, n3, n4, 0);
    }

    private int pathCompare(byte[] byArray, int n2, int n3, int n4, int n5) {
        return Paths.compare(this.path, n5, this.pathLen, this.mode, byArray, n2, n3, n4);
    }

    private static int alreadyMatch(AbstractTreeIterator abstractTreeIterator, AbstractTreeIterator abstractTreeIterator2) {
        while (true) {
            AbstractTreeIterator abstractTreeIterator3 = abstractTreeIterator.parent;
            AbstractTreeIterator abstractTreeIterator4 = abstractTreeIterator2.parent;
            if (abstractTreeIterator3 == null || abstractTreeIterator4 == null) {
                return 0;
            }
            if (abstractTreeIterator3.matches == abstractTreeIterator4.matches) {
                return abstractTreeIterator.pathOffset;
            }
            abstractTreeIterator = abstractTreeIterator3;
            abstractTreeIterator2 = abstractTreeIterator4;
        }
    }

    public boolean idEqual(AbstractTreeIterator abstractTreeIterator) {
        return ObjectId.equals(this.idBuffer(), this.idOffset(), abstractTreeIterator.idBuffer(), abstractTreeIterator.idOffset());
    }

    public abstract boolean hasId();

    public ObjectId getEntryObjectId() {
        return ObjectId.fromRaw(this.idBuffer(), this.idOffset());
    }

    public void getEntryObjectId(MutableObjectId mutableObjectId) {
        mutableObjectId.fromRaw(this.idBuffer(), this.idOffset());
    }

    public FileMode getEntryFileMode() {
        return FileMode.fromBits(this.mode);
    }

    public int getEntryRawMode() {
        return this.mode;
    }

    public String getEntryPathString() {
        return TreeWalk.pathOf(this);
    }

    public byte[] getEntryPathBuffer() {
        return this.path;
    }

    public int getEntryPathLength() {
        return this.pathLen;
    }

    public int getEntryPathHashCode() {
        int n2 = 0;
        for (int i2 = Math.max(0, this.pathLen - 16); i2 < this.pathLen; ++i2) {
            byte by = this.path[i2];
            if (by == 32) continue;
            n2 = (n2 >>> 2) + (by << 24);
        }
        return n2;
    }

    public abstract byte[] idBuffer();

    public abstract int idOffset();

    public abstract AbstractTreeIterator createSubtreeIterator(ObjectReader var1);

    public EmptyTreeIterator createEmptyTreeIterator() {
        return new EmptyTreeIterator(this);
    }

    public AbstractTreeIterator createSubtreeIterator(ObjectReader objectReader, MutableObjectId mutableObjectId) {
        return this.createSubtreeIterator(objectReader);
    }

    public void reset() {
        while (!this.first()) {
            this.back(1);
        }
    }

    public abstract boolean first();

    public abstract boolean eof();

    public abstract void next(int var1);

    public abstract void back(int var1);

    public void skip() {
        this.next(1);
    }

    public void stopWalk() {
    }

    protected boolean needsStopWalk() {
        return false;
    }

    public int getNameLength() {
        return this.pathLen - this.pathOffset;
    }

    public int getNameOffset() {
        return this.pathOffset;
    }

    public void getName(byte[] byArray, int n2) {
        System.arraycopy(this.path, this.pathOffset, byArray, n2, this.pathLen - this.pathOffset);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getEntryPathString() + "]";
    }

    public boolean isWorkTree() {
        return false;
    }
}

