/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport.resolver;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.lib.RepositoryCache$FileKey;
import org.eclipse.jgit.transport.resolver.RepositoryResolver;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.eclipse.jgit.util.FS;

public class FileResolver
implements RepositoryResolver {
    private volatile boolean exportAll;
    private final Map exports = new ConcurrentHashMap();
    private final Collection exportBase = new CopyOnWriteArrayList();

    public FileResolver() {
    }

    public FileResolver(File file, boolean bl2) {
        this();
        this.exportDirectory(file);
        this.setExportAll(bl2);
    }

    @Override
    public Repository open(Object object, String string) {
        if (FileResolver.isUnreasonableName(string)) {
            throw new RepositoryNotFoundException(string);
        }
        Repository repository = (Repository)this.exports.get(FileResolver.nameWithDotGit(string));
        if (repository != null) {
            repository.incrementOpen();
            return repository;
        }
        for (File file : this.exportBase) {
            File file2 = RepositoryCache$FileKey.resolve(new File(file, string), FS.DETECTED);
            if (file2 == null) continue;
            try {
                RepositoryCache$FileKey repositoryCache$FileKey = RepositoryCache$FileKey.exact(file2, FS.DETECTED);
                repository = RepositoryCache.open(repositoryCache$FileKey, true);
            }
            catch (IOException iOException) {
                throw new RepositoryNotFoundException(string, (Throwable)iOException);
            }
            try {
                if (this.isExportOk(object, string, repository)) {
                    return repository;
                }
                throw new ServiceNotEnabledException();
            }
            catch (IOException | RuntimeException exception) {
                repository.close();
                throw new RepositoryNotFoundException(string, (Throwable)exception);
            }
            catch (ServiceNotEnabledException serviceNotEnabledException) {
                repository.close();
                throw serviceNotEnabledException;
            }
        }
        if (this.exportBase.size() == 1) {
            File file = new File((File)this.exportBase.iterator().next(), string);
            throw new RepositoryNotFoundException(string, (Throwable)new RepositoryNotFoundException(file));
        }
        throw new RepositoryNotFoundException(string);
    }

    public boolean isExportAll() {
        return this.exportAll;
    }

    public void setExportAll(boolean bl2) {
        this.exportAll = bl2;
    }

    public void exportRepository(String string, Repository repository) {
        this.exports.put(FileResolver.nameWithDotGit(string), repository);
    }

    public void exportDirectory(File file) {
        this.exportBase.add(file);
    }

    protected boolean isExportOk(Object object, String string, Repository repository) {
        if (this.isExportAll()) {
            return true;
        }
        if (repository.getDirectory() != null) {
            return new File(repository.getDirectory(), "git-daemon-export-ok").exists();
        }
        return false;
    }

    private static String nameWithDotGit(String string) {
        if (string.endsWith(".git")) {
            return string;
        }
        return string + ".git";
    }

    private static boolean isUnreasonableName(String string) {
        if (string.length() == 0) {
            return true;
        }
        if (string.indexOf(92) >= 0) {
            return true;
        }
        if (new File(string).isAbsolute()) {
            return true;
        }
        if (string.startsWith("../")) {
            return true;
        }
        if (string.contains("/../")) {
            return true;
        }
        if (string.contains("/./")) {
            return true;
        }
        return string.contains("//");
    }
}

