/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledNonTag;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledTag;
import org.eclipse.jgit.lib.ObjectIdRef$Unpeeled;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase$FileStream;

abstract class WalkRemoteObjectDatabase {
    static final String ROOT_DIR = "../";
    static final String INFO_PACKS = "info/packs";
    static final String INFO_REFS = "../info/refs";

    WalkRemoteObjectDatabase() {
    }

    abstract URIish getURI();

    abstract Collection getPackNames();

    abstract Collection getAlternates();

    abstract WalkRemoteObjectDatabase$FileStream open(String var1);

    abstract WalkRemoteObjectDatabase openAlternate(String var1);

    abstract void close();

    void deleteFile(String string) {
        throw new IOException(MessageFormat.format(JGitText.get().deletingNotSupported, string));
    }

    OutputStream writeFile(String string, ProgressMonitor progressMonitor, String string2) {
        throw new IOException(MessageFormat.format(JGitText.get().writingNotSupported, string));
    }

    void writeFile(String string, byte[] byArray) {
        try (OutputStream outputStream = this.writeFile(string, null, null);){
            outputStream.write(byArray);
        }
    }

    void deleteRef(String string) {
        this.deleteFile(ROOT_DIR + string);
    }

    void deleteRefLog(String string) {
        this.deleteFile("../logs/" + string);
    }

    void writeRef(String string, ObjectId objectId) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(41);
        objectId.copyTo(byteArrayOutputStream);
        byteArrayOutputStream.write(10);
        this.writeFile(ROOT_DIR + string, byteArrayOutputStream.toByteArray());
    }

    void writeInfoPacks(Collection collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : collection) {
            stringBuilder.append("P ");
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        this.writeFile(INFO_PACKS, Constants.encodeASCII(stringBuilder.toString()));
    }

    BufferedReader openReader(String string) {
        InputStream inputStream = this.open((String)string).in;
        return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    Collection readAlternates(String string) {
        try (BufferedReader bufferedReader = this.openReader(string);){
            Object object;
            ArrayList<WalkRemoteObjectDatabase> arrayList = new ArrayList<WalkRemoteObjectDatabase>();
            while ((object = bufferedReader.readLine()) != null) {
                if (!((String)object).endsWith("/")) {
                    object = (String)object + "/";
                }
                arrayList.add(this.openAlternate((String)object));
            }
            object = arrayList;
            return object;
        }
    }

    protected void readPackedRefs(Map map) {
        try (BufferedReader bufferedReader = this.openReader("../packed-refs");){
            this.readPackedRefsImpl(map, bufferedReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            throw new TransportException(this.getURI(), JGitText.get().errorInPackedRefs, iOException);
        }
    }

    private void readPackedRefsImpl(Map map, BufferedReader bufferedReader) {
        String string;
        Ref ref = null;
        boolean bl2 = false;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.charAt(0) == '#') {
                if (!string.startsWith("# pack-refs with:")) continue;
                string = string.substring("# pack-refs with:".length());
                bl2 = string.contains(" peeled");
                continue;
            }
            if (string.charAt(0) == '^') {
                if (ref == null) {
                    throw new TransportException(JGitText.get().peeledLineBeforeRef);
                }
                ObjectId objectId = ObjectId.fromString(string.substring(1));
                ref = new ObjectIdRef$PeeledTag(Ref$Storage.PACKED, ref.getName(), ref.getObjectId(), objectId);
                map.put(ref.getName(), ref);
                continue;
            }
            int n2 = string.indexOf(32);
            if (n2 < 0) {
                throw new TransportException(MessageFormat.format(JGitText.get().unrecognizedRef, string));
            }
            ObjectId objectId = ObjectId.fromString(string.substring(0, n2));
            String string2 = string.substring(n2 + 1);
            ref = bl2 ? new ObjectIdRef$PeeledNonTag(Ref$Storage.PACKED, string2, objectId) : new ObjectIdRef$Unpeeled(Ref$Storage.PACKED, string2, objectId);
            map.put(ref.getName(), ref);
        }
    }
}

