/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef$Unpeeled;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BaseConnection;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.RemoteRefUpdate$Status;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.WalkPushConnection$1;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase;
import org.eclipse.jgit.transport.WalkTransport;

class WalkPushConnection
extends BaseConnection
implements PushConnection {
    private final Repository local;
    private final URIish uri;
    final WalkRemoteObjectDatabase dest;
    private final Transport transport;
    private LinkedHashMap packNames;
    private Map newRefs;
    private Collection packedRefUpdates;

    WalkPushConnection(WalkTransport walkTransport, WalkRemoteObjectDatabase walkRemoteObjectDatabase) {
        this.transport = (Transport)((Object)walkTransport);
        this.local = this.transport.local;
        this.uri = this.transport.getURI();
        this.dest = walkRemoteObjectDatabase;
    }

    @Override
    public void push(ProgressMonitor progressMonitor, Map map) {
        this.push(progressMonitor, map, null);
    }

    @Override
    public void push(ProgressMonitor progressMonitor, Map map, OutputStream outputStream) {
        this.markStartedOperation();
        this.packNames = null;
        this.newRefs = new TreeMap(this.getRefsMap());
        this.packedRefUpdates = new ArrayList(map.size());
        ArrayList<RemoteRefUpdate> arrayList = new ArrayList<RemoteRefUpdate>();
        for (RemoteRefUpdate object : map.values()) {
            Object object2 = object.getRemoteName();
            if (!((String)object2).startsWith("refs/") || !Repository.isValidRefName((String)object2)) {
                object.setStatus(RemoteRefUpdate$Status.REJECTED_OTHER_REASON);
                object.setMessage(JGitText.get().funnyRefname);
                continue;
            }
            if (AnyObjectId.isEqual(ObjectId.zeroId(), object.getNewObjectId())) {
                this.deleteCommand(object);
                continue;
            }
            arrayList.add(object);
        }
        if (!arrayList.isEmpty()) {
            this.sendpack(arrayList, progressMonitor);
        }
        for (RemoteRefUpdate iOException : arrayList) {
            this.updateCommand(iOException);
        }
        if (!arrayList.isEmpty() && this.isNewRepository()) {
            this.createNewRepository(arrayList);
        }
        WalkPushConnection$1 walkPushConnection$1 = new WalkPushConnection$1(this, this.newRefs.values());
        if (!this.packedRefUpdates.isEmpty()) {
            try {
                walkPushConnection$1.writePackedRefs();
                for (Object object2 : this.packedRefUpdates) {
                    ((RemoteRefUpdate)object2).setStatus(RemoteRefUpdate$Status.OK);
                }
            }
            catch (IOException iOException) {
                for (RemoteRefUpdate remoteRefUpdate : this.packedRefUpdates) {
                    remoteRefUpdate.setStatus(RemoteRefUpdate$Status.REJECTED_OTHER_REASON);
                    remoteRefUpdate.setMessage(iOException.getMessage());
                }
                throw new TransportException(this.uri, JGitText.get().failedUpdatingRefs, iOException);
            }
        }
        try {
            walkPushConnection$1.writeInfoRefs();
        }
        catch (IOException iOException) {
            throw new TransportException(this.uri, JGitText.get().failedUpdatingRefs, iOException);
        }
    }

    @Override
    public void close() {
        this.dest.close();
    }

    private void sendpack(List list, ProgressMonitor progressMonitor) {
        PackFile packFile = null;
        PackFile packFile2 = null;
        try (PackWriter packWriter = new PackWriter(this.transport.getPackConfig(), this.local.newObjectReader());){
            Object object2;
            HashSet<ObjectId> hashSet = new HashSet<ObjectId>();
            HashSet<ObjectId> hashSet2 = new HashSet<ObjectId>();
            for (Object object2 : list) {
                hashSet.add(((RemoteRefUpdate)object2).getNewObjectId());
            }
            for (Object object2 : this.getRefs()) {
                hashSet2.add(object2.getObjectId());
                if (object2.getPeeledObjectId() == null) continue;
                hashSet2.add(object2.getPeeledObjectId());
            }
            packWriter.preparePack(progressMonitor, hashSet, hashSet2);
            if (packWriter.getObjectCount() == 0L) {
                return;
            }
            this.packNames = new LinkedHashMap();
            for (Object object2 : this.dest.getPackNames()) {
                this.packNames.put(object2, object2);
            }
            File file = new File("pack");
            packFile = new PackFile(file, packWriter.computeName(), PackExt.PACK);
            packFile2 = packFile.create(PackExt.INDEX);
            if (this.packNames.remove(packFile.getName()) != null) {
                this.dest.writeInfoPacks(this.packNames.keySet());
                this.dest.deleteFile(packFile2.getPath());
            }
            object2 = "Put " + packFile.getName().substring(0, 12);
            try (Object object3 = new BufferedOutputStream(this.dest.writeFile(packFile.getPath(), progressMonitor, (String)object2 + "." + packFile.getPackExt().getExtension()));){
                packWriter.writePack(progressMonitor, progressMonitor, (OutputStream)object3);
            }
            object3 = new BufferedOutputStream(this.dest.writeFile(packFile2.getPath(), progressMonitor, (String)object2 + "." + packFile2.getPackExt().getExtension()));
            var12_16 = null;
            try {
                packWriter.writeIndex((OutputStream)object3);
            }
            catch (Throwable throwable) {
                var12_16 = throwable;
                throw throwable;
            }
            finally {
                if (object3 != null) {
                    if (var12_16 != null) {
                        try {
                            ((OutputStream)object3).close();
                        }
                        catch (Throwable throwable) {
                            var12_16.addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)object3).close();
                    }
                }
            }
            object3 = new ArrayList();
            ((ArrayList)object3).add(packFile.getName());
            ((ArrayList)object3).addAll(this.packNames.keySet());
            this.dest.writeInfoPacks((Collection)object3);
        }
        catch (IOException iOException) {
            this.safeDelete(packFile2);
            this.safeDelete(packFile);
            throw new TransportException(this.uri, JGitText.get().cannotStoreObjects, iOException);
        }
    }

    private void safeDelete(File file) {
        if (file != null) {
            try {
                this.dest.deleteFile(file.getPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void deleteCommand(RemoteRefUpdate remoteRefUpdate) {
        Ref ref = (Ref)this.newRefs.remove(remoteRefUpdate.getRemoteName());
        if (ref == null) {
            remoteRefUpdate.setStatus(RemoteRefUpdate$Status.OK);
            return;
        }
        if (ref.getStorage().isPacked()) {
            this.packedRefUpdates.add(remoteRefUpdate);
        }
        if (ref.getStorage().isLoose()) {
            try {
                this.dest.deleteRef(remoteRefUpdate.getRemoteName());
                remoteRefUpdate.setStatus(RemoteRefUpdate$Status.OK);
            }
            catch (IOException iOException) {
                remoteRefUpdate.setStatus(RemoteRefUpdate$Status.REJECTED_OTHER_REASON);
                remoteRefUpdate.setMessage(iOException.getMessage());
            }
        }
        try {
            this.dest.deleteRefLog(remoteRefUpdate.getRemoteName());
        }
        catch (IOException iOException) {
            remoteRefUpdate.setStatus(RemoteRefUpdate$Status.REJECTED_OTHER_REASON);
            remoteRefUpdate.setMessage(iOException.getMessage());
        }
    }

    private void updateCommand(RemoteRefUpdate remoteRefUpdate) {
        try {
            this.dest.writeRef(remoteRefUpdate.getRemoteName(), remoteRefUpdate.getNewObjectId());
            this.newRefs.put(remoteRefUpdate.getRemoteName(), new ObjectIdRef$Unpeeled(Ref$Storage.LOOSE, remoteRefUpdate.getRemoteName(), remoteRefUpdate.getNewObjectId()));
            remoteRefUpdate.setStatus(RemoteRefUpdate$Status.OK);
        }
        catch (IOException iOException) {
            remoteRefUpdate.setStatus(RemoteRefUpdate$Status.REJECTED_OTHER_REASON);
            remoteRefUpdate.setMessage(iOException.getMessage());
        }
    }

    private boolean isNewRepository() {
        return this.getRefsMap().isEmpty() && this.packNames != null && this.packNames.isEmpty();
    }

    private void createNewRepository(List list) {
        byte[] byArray;
        String string;
        try {
            string = "ref: " + WalkPushConnection.pickHEAD(list) + "\n";
            byArray = Constants.encode(string);
            this.dest.writeFile("../HEAD", byArray);
        }
        catch (IOException iOException) {
            throw new TransportException(this.uri, JGitText.get().cannotCreateHEAD, iOException);
        }
        try {
            string = "[core]\n\trepositoryformatversion = 0\n";
            byArray = Constants.encode("[core]\n\trepositoryformatversion = 0\n");
            this.dest.writeFile("../config", byArray);
        }
        catch (IOException iOException) {
            throw new TransportException(this.uri, JGitText.get().cannotCreateConfig, iOException);
        }
    }

    private static String pickHEAD(List list) {
        String string;
        for (RemoteRefUpdate remoteRefUpdate : list) {
            string = remoteRefUpdate.getRemoteName();
            if (!string.equals("refs/heads/master")) continue;
            return string;
        }
        for (RemoteRefUpdate remoteRefUpdate : list) {
            string = remoteRefUpdate.getRemoteName();
            if (!string.startsWith("refs/heads/")) continue;
            return string;
        }
        return ((RemoteRefUpdate)list.get(0)).getRemoteName();
    }
}

