/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.CompoundException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.UnpackedObject;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.DateRevQueue;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.BaseFetchConnection;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.WalkFetchConnection$RemotePack;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase;
import org.eclipse.jgit.transport.WalkTransport;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.FileUtils;

class WalkFetchConnection
extends BaseFetchConnection {
    final Repository local;
    final ObjectChecker objCheck;
    private final List remotes;
    private int lastRemoteIdx;
    private final RevWalk revWalk;
    private final TreeWalk treeWalk;
    private final RevFlag COMPLETE;
    private final RevFlag IN_WORK_QUEUE;
    private final RevFlag LOCALLY_SEEN;
    private final DateRevQueue localCommitQueue;
    private LinkedList workQueue;
    private final LinkedList noPacksYet;
    private final LinkedList noAlternatesYet;
    private final LinkedList unfetchedPacks;
    private final Set packsConsidered;
    private final MutableObjectId idBuffer = new MutableObjectId();
    private final HashMap fetchErrors;
    String lockMessage;
    final List packLocks;
    final ObjectInserter inserter;
    private final ObjectReader reader;

    WalkFetchConnection(WalkTransport walkTransport, WalkRemoteObjectDatabase walkRemoteObjectDatabase) {
        Transport transport = (Transport)((Object)walkTransport);
        this.local = transport.local;
        this.objCheck = transport.getObjectChecker();
        this.inserter = this.local.newObjectInserter();
        this.reader = this.inserter.newReader();
        this.remotes = new ArrayList();
        this.remotes.add(walkRemoteObjectDatabase);
        this.unfetchedPacks = new LinkedList();
        this.packsConsidered = new HashSet();
        this.noPacksYet = new LinkedList();
        this.noPacksYet.add(walkRemoteObjectDatabase);
        this.noAlternatesYet = new LinkedList();
        this.noAlternatesYet.add(walkRemoteObjectDatabase);
        this.fetchErrors = new HashMap();
        this.packLocks = new ArrayList(4);
        this.revWalk = new RevWalk(this.reader);
        this.revWalk.setRetainBody(false);
        this.treeWalk = new TreeWalk(this.reader);
        this.COMPLETE = this.revWalk.newFlag("COMPLETE");
        this.IN_WORK_QUEUE = this.revWalk.newFlag("IN_WORK_QUEUE");
        this.LOCALLY_SEEN = this.revWalk.newFlag("LOCALLY_SEEN");
        this.localCommitQueue = new DateRevQueue();
        this.workQueue = new LinkedList();
    }

    @Override
    public boolean didFetchTestConnectivity() {
        return true;
    }

    @Override
    protected void doFetch(ProgressMonitor progressMonitor, Collection collection, Set set) {
        this.markLocalRefsComplete(set);
        this.queueWants(collection);
        while (!progressMonitor.isCancelled() && !this.workQueue.isEmpty()) {
            ObjectId objectId = (ObjectId)this.workQueue.removeFirst();
            if (!(objectId instanceof RevObject) || !((RevObject)objectId).has(this.COMPLETE)) {
                this.downloadObject(progressMonitor, objectId);
            }
            this.process(objectId);
        }
        try {
            this.inserter.flush();
        }
        catch (IOException iOException) {
            throw new TransportException(iOException.getMessage(), iOException);
        }
    }

    @Override
    public Collection getPackLocks() {
        return this.packLocks;
    }

    @Override
    public void setPackLockMessage(String string) {
        this.lockMessage = string;
    }

    @Override
    public void close() {
        this.inserter.close();
        this.reader.close();
        for (Object object : this.unfetchedPacks) {
            if (((WalkFetchConnection$RemotePack)object).tmpIdx == null) continue;
            ((WalkFetchConnection$RemotePack)object).tmpIdx.delete();
        }
        for (Object object : this.remotes) {
            ((WalkRemoteObjectDatabase)object).close();
        }
    }

    private void queueWants(Collection collection) {
        HashSet<ObjectId> hashSet = new HashSet<ObjectId>();
        for (Ref ref : collection) {
            ObjectId objectId = ref.getObjectId();
            if (objectId == null) {
                throw new NullPointerException(MessageFormat.format(JGitText.get().transportProvidedRefWithNoObjectId, ref.getName()));
            }
            try {
                RevObject revObject = this.revWalk.parseAny(objectId);
                if (revObject.has(this.COMPLETE) || !hashSet.add(objectId)) continue;
                revObject.add(this.IN_WORK_QUEUE);
                this.workQueue.add(revObject);
            }
            catch (MissingObjectException missingObjectException) {
                if (!hashSet.add(objectId)) continue;
                this.workQueue.add(objectId);
            }
            catch (IOException iOException) {
                throw new TransportException(MessageFormat.format(JGitText.get().cannotRead, objectId.name()), iOException);
            }
        }
    }

    private void process(ObjectId objectId) {
        RevObject revObject;
        try {
            if (objectId instanceof RevObject) {
                revObject = (RevObject)objectId;
                if (revObject.has(this.COMPLETE)) {
                    return;
                }
                this.revWalk.parseHeaders(revObject);
            } else {
                revObject = this.revWalk.parseAny(objectId);
                if (revObject.has(this.COMPLETE)) {
                    return;
                }
            }
        }
        catch (IOException iOException) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotRead, objectId.name()), iOException);
        }
        switch (revObject.getType()) {
            case 3: {
                this.processBlob(revObject);
                break;
            }
            case 2: {
                this.processTree(revObject);
                break;
            }
            case 1: {
                this.processCommit(revObject);
                break;
            }
            case 4: {
                this.processTag(revObject);
                break;
            }
            default: {
                throw new TransportException(MessageFormat.format(JGitText.get().unknownObjectType, objectId.name()));
            }
        }
        this.fetchErrors.remove(objectId);
    }

    private void processBlob(RevObject revObject) {
        try {
            if (!this.reader.has(revObject, 3)) {
                throw new TransportException(MessageFormat.format(JGitText.get().cannotReadBlob, revObject.name()), new MissingObjectException((ObjectId)revObject, "blob"));
            }
            revObject.add(this.COMPLETE);
        }
        catch (IOException iOException) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotReadBlob, revObject.name()), iOException);
        }
    }

    private void processTree(RevObject revObject) {
        try {
            this.treeWalk.reset((AnyObjectId)revObject);
            block5: while (this.treeWalk.next()) {
                FileMode fileMode = this.treeWalk.getFileMode(0);
                int n2 = fileMode.getObjectType();
                switch (n2) {
                    case 2: 
                    case 3: {
                        this.treeWalk.getObjectId(this.idBuffer, 0);
                        this.needs(this.revWalk.lookupAny(this.idBuffer, n2));
                        continue block5;
                    }
                }
                if (FileMode.GITLINK.equals(fileMode)) continue;
                this.treeWalk.getObjectId(this.idBuffer, 0);
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().invalidModeFor, fileMode, this.idBuffer.name(), this.treeWalk.getPathString(), revObject.getId().name()));
            }
        }
        catch (IOException iOException) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotReadTree, revObject.name()), iOException);
        }
        revObject.add(this.COMPLETE);
    }

    private void processCommit(RevObject revObject) {
        RevCommit revCommit = (RevCommit)revObject;
        this.markLocalCommitsComplete(revCommit.getCommitTime());
        this.needs(revCommit.getTree());
        for (RevCommit revCommit2 : revCommit.getParents()) {
            this.needs(revCommit2);
        }
        revObject.add(this.COMPLETE);
    }

    private void processTag(RevObject revObject) {
        RevTag revTag = (RevTag)revObject;
        this.needs(revTag.getObject());
        revObject.add(this.COMPLETE);
    }

    private void needs(RevObject revObject) {
        if (revObject.has(this.COMPLETE)) {
            return;
        }
        if (!revObject.has(this.IN_WORK_QUEUE)) {
            revObject.add(this.IN_WORK_QUEUE);
            this.workQueue.add(revObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadObject(ProgressMonitor progressMonitor, AnyObjectId anyObjectId) {
        Object object;
        Object object2;
        if (this.alreadyHave(anyObjectId)) {
            return;
        }
        block5: while (true) {
            int n2;
            if (this.downloadPackedObject(progressMonitor, anyObjectId)) {
                return;
            }
            String string = anyObjectId.name();
            String string2 = string.substring(0, 2);
            String string3 = string.substring(2);
            String string4 = string2 + "/" + string3;
            for (n2 = this.lastRemoteIdx; n2 < this.remotes.size(); ++n2) {
                if (!this.downloadLooseObject(anyObjectId, string4, (WalkRemoteObjectDatabase)this.remotes.get(n2))) continue;
                this.lastRemoteIdx = n2;
                return;
            }
            for (n2 = 0; n2 < this.lastRemoteIdx; ++n2) {
                if (!this.downloadLooseObject(anyObjectId, string4, (WalkRemoteObjectDatabase)this.remotes.get(n2))) continue;
                this.lastRemoteIdx = n2;
                return;
            }
            while (!this.noPacksYet.isEmpty()) {
                WalkRemoteObjectDatabase walkRemoteObjectDatabase = (WalkRemoteObjectDatabase)this.noPacksYet.removeFirst();
                try {
                    progressMonitor.beginTask(JGitText.get().listingPacks, 0);
                    object2 = walkRemoteObjectDatabase.getPackNames();
                }
                catch (IOException iOException) {
                    this.recordError(anyObjectId, iOException);
                    continue;
                }
                finally {
                    progressMonitor.endTask();
                    continue;
                }
                if (object2 == null || object2.isEmpty()) continue;
                object = object2.iterator();
                while (object.hasNext()) {
                    String string5 = (String)object.next();
                    if (!this.packsConsidered.add(string5)) continue;
                    this.unfetchedPacks.add(new WalkFetchConnection$RemotePack(this, walkRemoteObjectDatabase, string5));
                }
                if (!this.downloadPackedObject(progressMonitor, anyObjectId)) continue;
                return;
            }
            Collection collection = this.expandOneAlternate(anyObjectId, progressMonitor);
            if (collection == null || collection.isEmpty()) break;
            object2 = collection.iterator();
            while (true) {
                if (!object2.hasNext()) continue block5;
                object = (WalkRemoteObjectDatabase)object2.next();
                this.remotes.add(object);
                this.noPacksYet.add(object);
                this.noAlternatesYet.add(object);
            }
            break;
        }
        object2 = (List)this.fetchErrors.get(anyObjectId);
        object = new TransportException(MessageFormat.format(JGitText.get().cannotGet, anyObjectId.name()));
        if (object2 != null && !object2.isEmpty()) {
            if (object2.size() == 1) {
                ((Throwable)object).initCause((Throwable)object2.get(0));
            } else {
                ((Throwable)object).initCause(new CompoundException((Collection)object2));
            }
        }
        throw object;
    }

    private boolean alreadyHave(AnyObjectId anyObjectId) {
        try {
            return this.reader.has(anyObjectId);
        }
        catch (IOException iOException) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotReadObject, anyObjectId.name()), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadPackedObject(ProgressMonitor progressMonitor, AnyObjectId anyObjectId) {
        Iterator iterator = this.unfetchedPacks.iterator();
        while (iterator.hasNext() && !progressMonitor.isCancelled()) {
            WalkFetchConnection$RemotePack walkFetchConnection$RemotePack = (WalkFetchConnection$RemotePack)iterator.next();
            try {
                walkFetchConnection$RemotePack.openIndex(progressMonitor);
            }
            catch (IOException iOException) {
                this.recordError(anyObjectId, iOException);
                iterator.remove();
                continue;
            }
            if (progressMonitor.isCancelled()) {
                return false;
            }
            if (!walkFetchConnection$RemotePack.index.hasObject(anyObjectId)) continue;
            IOException iOException = null;
            try {
                walkFetchConnection$RemotePack.downloadPack(progressMonitor);
            }
            catch (IOException iOException2) {
                this.recordError(anyObjectId, iOException2);
                iOException = iOException2;
                continue;
            }
            finally {
                try {
                    if (walkFetchConnection$RemotePack.tmpIdx != null) {
                        FileUtils.delete(walkFetchConnection$RemotePack.tmpIdx);
                    }
                }
                catch (IOException iOException3) {
                    if (iOException != null) {
                        iOException3.addSuppressed(iOException);
                    }
                    throw new TransportException(iOException3.getMessage(), iOException3);
                }
                iterator.remove();
                continue;
            }
            if (!this.alreadyHave(anyObjectId)) {
                this.recordError(anyObjectId, new FileNotFoundException(MessageFormat.format(JGitText.get().objectNotFoundIn, anyObjectId.name(), walkFetchConnection$RemotePack.packName)));
                continue;
            }
            Iterator iterator2 = this.swapFetchQueue();
            while (iterator2.hasNext()) {
                ObjectId objectId = (ObjectId)iterator2.next();
                if (walkFetchConnection$RemotePack.index.hasObject(objectId)) {
                    iterator2.remove();
                    this.process(objectId);
                    continue;
                }
                this.workQueue.add(objectId);
            }
            return true;
        }
        return false;
    }

    private Iterator swapFetchQueue() {
        Iterator iterator = this.workQueue.iterator();
        this.workQueue = new LinkedList();
        return iterator;
    }

    private boolean downloadLooseObject(AnyObjectId anyObjectId, String string, WalkRemoteObjectDatabase walkRemoteObjectDatabase) {
        try {
            byte[] byArray = walkRemoteObjectDatabase.open(string).toArray();
            this.verifyAndInsertLooseObject(anyObjectId, byArray);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.recordError(anyObjectId, fileNotFoundException);
            return false;
        }
        catch (IOException iOException) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotDownload, anyObjectId.name()), iOException);
        }
    }

    private void verifyAndInsertLooseObject(AnyObjectId anyObjectId, byte[] byArray) {
        ObjectId objectId;
        ObjectLoader objectLoader;
        try {
            objectLoader = UnpackedObject.parse(byArray, anyObjectId);
        }
        catch (CorruptObjectException corruptObjectException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(anyObjectId.name());
            fileNotFoundException.initCause(corruptObjectException);
            throw fileNotFoundException;
        }
        int n2 = objectLoader.getType();
        byte[] byArray2 = objectLoader.getCachedBytes();
        if (this.objCheck != null) {
            try {
                this.objCheck.check(anyObjectId, n2, byArray2);
            }
            catch (CorruptObjectException corruptObjectException) {
                throw new TransportException(MessageFormat.format(JGitText.get().transportExceptionInvalid, Constants.typeString(n2), anyObjectId.name(), corruptObjectException.getMessage()));
            }
        }
        if (!AnyObjectId.isEqual(anyObjectId, objectId = this.inserter.insert(n2, byArray2))) {
            throw new TransportException(MessageFormat.format(JGitText.get().incorrectHashFor, anyObjectId.name(), objectId.name(), Constants.typeString(n2), byArray.length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection expandOneAlternate(AnyObjectId anyObjectId, ProgressMonitor progressMonitor) {
        while (!this.noAlternatesYet.isEmpty()) {
            WalkRemoteObjectDatabase walkRemoteObjectDatabase = (WalkRemoteObjectDatabase)this.noAlternatesYet.removeFirst();
            try {
                progressMonitor.beginTask(JGitText.get().listingAlternates, 0);
                Collection collection = walkRemoteObjectDatabase.getAlternates();
                if (collection == null || collection.isEmpty()) continue;
                Collection collection2 = collection;
                return collection2;
            }
            catch (IOException iOException) {
                this.recordError(anyObjectId, iOException);
            }
            finally {
                progressMonitor.endTask();
            }
        }
        return null;
    }

    private void markLocalRefsComplete(Set set) {
        List list;
        try {
            list = this.local.getRefDatabase().getRefs();
        }
        catch (IOException iOException) {
            throw new TransportException(iOException.getMessage(), iOException);
        }
        for (Object object : list) {
            try {
                this.markLocalObjComplete(this.revWalk.parseAny(object.getObjectId()));
            }
            catch (IOException iOException) {
                throw new TransportException(MessageFormat.format(JGitText.get().localRefIsMissingObjects, object.getName()), iOException);
            }
        }
        for (Object object : set) {
            try {
                this.markLocalObjComplete(this.revWalk.parseAny((AnyObjectId)object));
            }
            catch (IOException iOException) {
                throw new TransportException(MessageFormat.format(JGitText.get().transportExceptionMissingAssumed, ((AnyObjectId)object).name()), iOException);
            }
        }
    }

    private void markLocalObjComplete(RevObject revObject) {
        while (revObject.getType() == 4) {
            revObject.add(this.COMPLETE);
            revObject = ((RevTag)revObject).getObject();
            this.revWalk.parseHeaders(revObject);
        }
        switch (revObject.getType()) {
            case 3: {
                revObject.add(this.COMPLETE);
                break;
            }
            case 1: {
                this.pushLocalCommit((RevCommit)revObject);
                break;
            }
            case 2: {
                this.markTreeComplete((RevTree)revObject);
            }
        }
    }

    private void markLocalCommitsComplete(int n2) {
        try {
            block2: while (true) {
                RevCommit revCommit;
                if ((revCommit = this.localCommitQueue.peek()) == null || revCommit.getCommitTime() < n2) {
                    return;
                }
                this.localCommitQueue.next();
                this.markTreeComplete(revCommit.getTree());
                RevCommit[] revCommitArray = revCommit.getParents();
                int n3 = revCommitArray.length;
                int n4 = 0;
                while (true) {
                    if (n4 >= n3) continue block2;
                    RevCommit revCommit2 = revCommitArray[n4];
                    this.pushLocalCommit(revCommit2);
                    ++n4;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new TransportException(JGitText.get().localObjectsIncomplete, iOException);
        }
    }

    private void pushLocalCommit(RevCommit revCommit) {
        if (revCommit.has(this.LOCALLY_SEEN)) {
            return;
        }
        this.revWalk.parseHeaders(revCommit);
        revCommit.add(this.LOCALLY_SEEN);
        revCommit.add(this.COMPLETE);
        revCommit.carry(this.COMPLETE);
        this.localCommitQueue.add(revCommit);
    }

    private void markTreeComplete(RevTree revTree) {
        if (revTree.has(this.COMPLETE)) {
            return;
        }
        revTree.add(this.COMPLETE);
        this.treeWalk.reset((AnyObjectId)revTree);
        block4: while (this.treeWalk.next()) {
            FileMode fileMode = this.treeWalk.getFileMode(0);
            int n2 = fileMode.getObjectType();
            switch (n2) {
                case 3: {
                    this.treeWalk.getObjectId(this.idBuffer, 0);
                    this.revWalk.lookupAny(this.idBuffer, n2).add(this.COMPLETE);
                    continue block4;
                }
                case 2: {
                    this.treeWalk.getObjectId(this.idBuffer, 0);
                    RevObject revObject = this.revWalk.lookupAny(this.idBuffer, n2);
                    if (revObject.has(this.COMPLETE)) continue block4;
                    revObject.add(this.COMPLETE);
                    this.treeWalk.enterSubtree();
                    continue block4;
                }
            }
            if (FileMode.GITLINK.equals(fileMode)) continue;
            this.treeWalk.getObjectId(this.idBuffer, 0);
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().corruptObjectInvalidMode3, fileMode, this.idBuffer.name(), this.treeWalk.getPathString(), revTree.name()));
        }
    }

    private void recordError(AnyObjectId anyObjectId, Throwable throwable) {
        ObjectId objectId = anyObjectId.copy();
        ArrayList<Throwable> arrayList = (ArrayList<Throwable>)this.fetchErrors.get(objectId);
        if (arrayList == null) {
            arrayList = new ArrayList<Throwable>(2);
            this.fetchErrors.put(objectId, arrayList);
        }
        arrayList.add(throwable);
    }
}

