/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackLock;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.transport.WalkFetchConnection;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase$FileStream;
import org.eclipse.jgit.util.FileUtils;

class WalkFetchConnection$RemotePack {
    final WalkRemoteObjectDatabase connection;
    final String packName;
    final String idxName;
    File tmpIdx;
    PackIndex index;
    final /* synthetic */ WalkFetchConnection this$0;

    WalkFetchConnection$RemotePack(WalkFetchConnection walkFetchConnection, WalkRemoteObjectDatabase walkRemoteObjectDatabase, String string) {
        this.this$0 = walkFetchConnection;
        this.connection = walkRemoteObjectDatabase;
        this.packName = string;
        String string2 = this.idxName = this.packName.substring(0, this.packName.length() - 5) + ".idx";
        if (string2.startsWith("pack-")) {
            string2 = string2.substring(5);
        }
        if (string2.endsWith(".idx")) {
            string2 = string2.substring(0, string2.length() - 4);
        }
        if (walkFetchConnection.local.getObjectDatabase() instanceof ObjectDirectory) {
            this.tmpIdx = new File(((ObjectDirectory)walkFetchConnection.local.getObjectDatabase()).getDirectory(), "walk-" + string2 + ".walkidx");
        }
    }

    void openIndex(ProgressMonitor progressMonitor) {
        if (this.index != null) {
            return;
        }
        if (this.tmpIdx == null) {
            this.tmpIdx = File.createTempFile("jgit-walk-", ".idx");
        } else if (this.tmpIdx.isFile()) {
            try {
                this.index = PackIndex.open(this.tmpIdx);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        WalkRemoteObjectDatabase$FileStream walkRemoteObjectDatabase$FileStream = this.connection.open("pack/" + this.idxName);
        progressMonitor.beginTask("Get " + this.idxName.substring(0, 12) + "..idx", walkRemoteObjectDatabase$FileStream.length < 0L ? 0 : (int)(walkRemoteObjectDatabase$FileStream.length / 1024L));
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.tmpIdx);){
            int n2;
            byte[] byArray = new byte[2048];
            while (!progressMonitor.isCancelled() && (n2 = walkRemoteObjectDatabase$FileStream.in.read(byArray)) >= 0) {
                fileOutputStream.write(byArray, 0, n2);
                progressMonitor.update(n2 / 1024);
            }
        }
        catch (IOException iOException) {
            FileUtils.delete(this.tmpIdx);
            throw iOException;
        }
        finally {
            walkRemoteObjectDatabase$FileStream.in.close();
        }
        progressMonitor.endTask();
        if (progressMonitor.isCancelled()) {
            FileUtils.delete(this.tmpIdx);
            return;
        }
        try {
            this.index = PackIndex.open(this.tmpIdx);
        }
        catch (IOException iOException) {
            FileUtils.delete(this.tmpIdx);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void downloadPack(ProgressMonitor progressMonitor) {
        String string = "pack/" + this.packName;
        WalkRemoteObjectDatabase$FileStream walkRemoteObjectDatabase$FileStream = this.connection.open(string);
        try {
            PackParser packParser = this.this$0.inserter.newPackParser(walkRemoteObjectDatabase$FileStream.in);
            packParser.setAllowThin(false);
            packParser.setObjectChecker(this.this$0.objCheck);
            packParser.setLockMessage(this.this$0.lockMessage);
            PackLock packLock = packParser.parse(progressMonitor);
            if (packLock != null) {
                this.this$0.packLocks.add(packLock);
            }
        }
        finally {
            walkRemoteObjectDatabase$FileStream.in.close();
        }
    }
}

