/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.transport.WalkEncryption$JGitV1;
import org.eclipse.jgit.transport.WalkEncryption$JGitV2;
import org.eclipse.jgit.transport.WalkEncryption$JetS3tV2;
import org.eclipse.jgit.transport.WalkEncryption$NoEncryption;

abstract class WalkEncryption {
    static final WalkEncryption NONE = new WalkEncryption$NoEncryption();
    static final String JETS3T_CRYPTO_VER = "jets3t-crypto-ver";
    static final String JETS3T_CRYPTO_ALG = "jets3t-crypto-alg";

    WalkEncryption() {
    }

    abstract OutputStream encrypt(OutputStream var1);

    abstract void request(HttpURLConnection var1, String var2);

    abstract void validate(HttpURLConnection var1, String var2);

    abstract InputStream decrypt(InputStream var1);

    protected void validateImpl(HttpURLConnection httpURLConnection, String string, String string2, String string3) {
        String string4 = httpURLConnection.getHeaderField(string + JETS3T_CRYPTO_VER);
        if (string4 == null) {
            string4 = "";
        }
        if (!string2.equals(string4)) {
            throw new IOException(MessageFormat.format(JGitText.get().unsupportedEncryptionVersion, string4));
        }
        string4 = httpURLConnection.getHeaderField(string + JETS3T_CRYPTO_ALG);
        if (string4 == null) {
            string4 = "";
        }
        if (!string3.equalsIgnoreCase(string4)) {
            throw new IOException(MessageFormat.format(JGitText.get().unsupportedEncryptionAlgorithm, string4));
        }
    }

    IOException error(Throwable throwable) {
        return new IOException(MessageFormat.format(JGitText.get().encryptionError, throwable.getMessage()), throwable);
    }

    static GeneralSecurityException securityError(String string, Throwable throwable) {
        GeneralSecurityException generalSecurityException = new GeneralSecurityException(MessageFormat.format(JGitText.get().encryptionError, string));
        generalSecurityException.initCause(throwable);
        return generalSecurityException;
    }

    static WalkEncryption instance(Properties properties) {
        String string = properties.getProperty("crypto.algorithm", "PBEWithMD5AndDES");
        String string2 = properties.getProperty("crypto.version", "0");
        String string3 = properties.getProperty("password");
        if (string3 == null) {
            return NONE;
        }
        switch (string2) {
            case "0": {
                return new WalkEncryption$JetS3tV2(string, string3);
            }
            case "1": {
                return new WalkEncryption$JGitV1(string, string3);
            }
            case "2": {
                return new WalkEncryption$JGitV2(properties);
            }
        }
        throw new GeneralSecurityException(MessageFormat.format(JGitText.get().unsupportedEncryptionVersion, string2));
    }
}

