/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.transport.InsecureCipherFactory;
import org.eclipse.jgit.transport.WalkEncryption;
import org.eclipse.jgit.transport.WalkEncryption$Keys;
import org.eclipse.jgit.transport.WalkEncryption$Vals;
import org.eclipse.jgit.util.Base64;
import org.eclipse.jgit.util.Hex;

abstract class WalkEncryption$SymmetricEncryption
extends WalkEncryption
implements WalkEncryption$Keys,
WalkEncryption$Vals {
    final String profile;
    final String version;
    final String cipherAlgo;
    final String paramsAlgo;
    final SecretKey secretKey;
    volatile String context;
    volatile Cipher decryptCipher;

    WalkEncryption$SymmetricEncryption(Properties properties) {
        byte[] byArray;
        int n2;
        int n3;
        this.profile = properties.getProperty("crypto.algorithm");
        this.version = properties.getProperty("crypto.version");
        String string = properties.getProperty("password");
        this.cipherAlgo = properties.getProperty(this.profile + ".algo", "PBEWithMD5AndDES");
        String string2 = properties.getProperty(this.profile + ".key.algo", "PBEWithMD5AndDES");
        String string3 = properties.getProperty(this.profile + ".key.size", DEFAULT_KEY_SIZE);
        String string4 = properties.getProperty(this.profile + ".key.iter", DEFAULT_KEY_ITER);
        String string5 = properties.getProperty(this.profile + ".key.salt", DEFAULT_KEY_SALT);
        Cipher cipher = InsecureCipherFactory.create(this.cipherAlgo);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string2);
        try {
            n3 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            throw WalkEncryption$SymmetricEncryption.securityError(".key.size" + string3, exception);
        }
        try {
            n2 = Integer.parseInt(string4);
        }
        catch (Exception exception) {
            throw WalkEncryption$SymmetricEncryption.securityError(".key.iter" + string4, exception);
        }
        try {
            byArray = Hex.decode(string5.replaceAll("\\s+", ""));
        }
        catch (Exception exception) {
            throw WalkEncryption$SymmetricEncryption.securityError(".key.salt" + string5, exception);
        }
        PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray(), byArray, n2, n3);
        SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        String string6 = this.cipherAlgo.toUpperCase(Locale.ROOT);
        Matcher matcher = Pattern.compile("(PBE).*(WITH).+(AND).+").matcher(string6);
        Matcher matcher2 = Pattern.compile("(.+)/(.+)/(.+)").matcher(string6);
        if (matcher.matches()) {
            this.paramsAlgo = this.cipherAlgo;
            this.secretKey = secretKey;
        } else if (matcher2.find()) {
            this.paramsAlgo = matcher2.group(1);
            this.secretKey = new SecretKeySpec(secretKey.getEncoded(), this.paramsAlgo);
        } else {
            throw new GeneralSecurityException(MessageFormat.format(JGitText.get().unsupportedEncryptionAlgorithm, this.cipherAlgo));
        }
        cipher.init(1, this.secretKey);
        cipher.doFinal();
    }

    @Override
    OutputStream encrypt(OutputStream outputStream) {
        try {
            Cipher cipher = InsecureCipherFactory.create(this.cipherAlgo);
            cipher.init(1, this.secretKey);
            AlgorithmParameters algorithmParameters = cipher.getParameters();
            this.context = algorithmParameters == null ? "" : Base64.encodeBytes(algorithmParameters.getEncoded());
            return new CipherOutputStream(outputStream, cipher);
        }
        catch (Exception exception) {
            throw this.error(exception);
        }
    }

    @Override
    void request(HttpURLConnection httpURLConnection, String string) {
        httpURLConnection.setRequestProperty(string + "jgit-crypto-profile", this.profile);
        httpURLConnection.setRequestProperty(string + "jgit-crypto-version", this.version);
        httpURLConnection.setRequestProperty(string + "jgit-crypto-context", this.context);
    }

    @Override
    void validate(HttpURLConnection httpURLConnection, String string) {
        String string2 = httpURLConnection.getHeaderField(string + "jgit-crypto-profile");
        String string3 = httpURLConnection.getHeaderField(string + "jgit-crypto-version");
        String string4 = httpURLConnection.getHeaderField(string + "jgit-crypto-context");
        if (string2 == null) {
            throw new IOException(MessageFormat.format(JGitText.get().encryptionError, "jgit-crypto-profile"));
        }
        if (string3 == null) {
            throw new IOException(MessageFormat.format(JGitText.get().encryptionError, "jgit-crypto-version"));
        }
        if (string4 == null) {
            throw new IOException(MessageFormat.format(JGitText.get().encryptionError, "jgit-crypto-context"));
        }
        if (!this.profile.equals(string2)) {
            throw new IOException(MessageFormat.format(JGitText.get().unsupportedEncryptionAlgorithm, string2));
        }
        if (!this.version.equals(string3)) {
            throw new IOException(MessageFormat.format(JGitText.get().unsupportedEncryptionVersion, string3));
        }
        try {
            this.decryptCipher = InsecureCipherFactory.create(this.cipherAlgo);
            if (string4.isEmpty()) {
                this.decryptCipher.init(2, this.secretKey);
            } else {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.paramsAlgo);
                algorithmParameters.init(Base64.decode(string4));
                this.decryptCipher.init(2, (Key)this.secretKey, algorithmParameters);
            }
        }
        catch (Exception exception) {
            throw this.error(exception);
        }
    }

    @Override
    InputStream decrypt(InputStream inputStream) {
        try {
            CipherInputStream cipherInputStream = new CipherInputStream(inputStream, this.decryptCipher);
            return cipherInputStream;
        }
        finally {
            this.decryptCipher = null;
        }
    }
}

