/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.transport.InsecureCipherFactory;
import org.eclipse.jgit.transport.WalkEncryption;

class WalkEncryption$JetS3tV2
extends WalkEncryption {
    static final String VERSION = "2";
    static final String ALGORITHM = "PBEWithMD5AndDES";
    static final int ITERATIONS = 5000;
    static final int KEY_SIZE = 32;
    static final byte[] SALT = new byte[]{-92, 11, -56, 52, -42, -107, -13, 19};
    static final byte[] ZERO_AES_IV = new byte[16];
    private static final String CRYPTO_VER = "2";
    private final String cryptoAlg;
    private final SecretKey secretKey;
    private final AlgorithmParameterSpec paramSpec;

    WalkEncryption$JetS3tV2(String string, String string2) {
        this.cryptoAlg = string;
        Cipher cipher = InsecureCipherFactory.create(this.cryptoAlg);
        String string3 = this.cryptoAlg.toUpperCase(Locale.ROOT);
        if (!string3.startsWith("PBE")) {
            throw new GeneralSecurityException(JGitText.get().encryptionOnlyPBE);
        }
        PBEKeySpec pBEKeySpec = new PBEKeySpec(string2.toCharArray(), SALT, 5000, 32);
        this.secretKey = SecretKeyFactory.getInstance(string).generateSecret(pBEKeySpec);
        boolean bl2 = string3.contains("AES");
        if (bl2) {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ZERO_AES_IV);
            this.paramSpec = new PBEParameterSpec(SALT, 5000, ivParameterSpec);
        } else {
            this.paramSpec = new PBEParameterSpec(SALT, 5000);
        }
        cipher.init(1, (Key)this.secretKey, this.paramSpec);
        cipher.doFinal();
    }

    @Override
    void request(HttpURLConnection httpURLConnection, String string) {
        httpURLConnection.setRequestProperty(string + "jets3t-crypto-ver", "2");
        httpURLConnection.setRequestProperty(string + "jets3t-crypto-alg", this.cryptoAlg);
    }

    @Override
    void validate(HttpURLConnection httpURLConnection, String string) {
        this.validateImpl(httpURLConnection, string, "2", this.cryptoAlg);
    }

    @Override
    OutputStream encrypt(OutputStream outputStream) {
        try {
            Cipher cipher = InsecureCipherFactory.create(this.cryptoAlg);
            cipher.init(1, (Key)this.secretKey, this.paramSpec);
            return new CipherOutputStream(outputStream, cipher);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw this.error(generalSecurityException);
        }
    }

    @Override
    InputStream decrypt(InputStream inputStream) {
        try {
            Cipher cipher = InsecureCipherFactory.create(this.cryptoAlg);
            cipher.init(2, (Key)this.secretKey, this.paramSpec);
            return new CipherInputStream(inputStream, cipher);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw this.error(generalSecurityException);
        }
    }
}

