/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Arrays;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialItem$Password;
import org.eclipse.jgit.transport.CredentialItem$StringType;
import org.eclipse.jgit.transport.CredentialItem$Username;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class UsernamePasswordCredentialsProvider
extends CredentialsProvider {
    private String username;
    private char[] password;

    public UsernamePasswordCredentialsProvider(String string, String string2) {
        this(string, string2.toCharArray());
    }

    public UsernamePasswordCredentialsProvider(String string, char[] cArray) {
        this.username = string;
        this.password = cArray;
    }

    @Override
    public boolean isInteractive() {
        return false;
    }

    @Override
    public boolean supports(CredentialItem ... credentialItemArray) {
        for (CredentialItem credentialItem : credentialItemArray) {
            if (credentialItem instanceof CredentialItem.InformationalMessage || credentialItem instanceof CredentialItem$Username || credentialItem instanceof CredentialItem$Password || credentialItem instanceof CredentialItem$StringType && credentialItem.getPromptText().equals("Password: ")) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean get(URIish uRIish, CredentialItem ... credentialItemArray) {
        for (CredentialItem credentialItem : credentialItemArray) {
            if (credentialItem instanceof CredentialItem.InformationalMessage) continue;
            if (credentialItem instanceof CredentialItem$Username) {
                ((CredentialItem$Username)credentialItem).setValue(this.username);
                continue;
            }
            if (credentialItem instanceof CredentialItem$Password) {
                ((CredentialItem$Password)credentialItem).setValue(this.password);
                continue;
            }
            if (credentialItem instanceof CredentialItem$StringType && credentialItem.getPromptText().equals("Password: ")) {
                ((CredentialItem$StringType)credentialItem).setValue(new String(this.password));
                continue;
            }
            throw new UnsupportedCredentialItem(uRIish, credentialItem.getClass().getName() + ":" + credentialItem.getPromptText());
        }
        return true;
    }

    public void clear() {
        this.username = null;
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
            this.password = null;
        }
    }
}

