/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Set;
import org.eclipse.jgit.util.StringUtils;

public class UserAgent {
    private static volatile String userAgent = UserAgent.computeUserAgent();

    private static String computeUserAgent() {
        return UserAgent.clean("JGit/" + UserAgent.computeVersion());
    }

    private static String computeVersion() {
        String string;
        Package package_ = UserAgent.class.getPackage();
        if (package_ != null && !StringUtils.isEmptyOrNull(string = package_.getImplementationVersion())) {
            return string;
        }
        return "unknown";
    }

    static String clean(String string) {
        string = string.trim();
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 <= ' ' || c2 >= '\u007f') {
                if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == '.') continue;
                c2 = '.';
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    public static String get() {
        return userAgent;
    }

    public static void set(String string) {
        userAgent = StringUtils.isEmptyOrNull(string) ? null : UserAgent.clean(string);
    }

    static String getAgent(Set set, String string) {
        if (set == null || set.isEmpty()) {
            return string;
        }
        for (String string2 : set) {
            if (!string2.startsWith("agent") || string2.length() <= "agent".length() || string2.charAt("agent".length()) != '=') continue;
            return string2.substring("agent".length() + 1);
        }
        return string;
    }

    static boolean hasAgent(Set set) {
        return UserAgent.getAgent(set, null) != null;
    }

    private UserAgent() {
    }
}

