/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.pack.CachedPackUriProvider;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.internal.storage.pack.PackWriter$PackfileUriConfig;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.AsyncRevObjectQueue;
import org.eclipse.jgit.revwalk.DepthWalk$Commit;
import org.eclipse.jgit.revwalk.DepthWalk$RevWalk;
import org.eclipse.jgit.revwalk.ObjectReachabilityChecker;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.ReachabilityChecker;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.storage.pack.PackStatistics;
import org.eclipse.jgit.storage.pack.PackStatistics$Accumulator;
import org.eclipse.jgit.transport.AdvertiseRefsHook;
import org.eclipse.jgit.transport.CapabilitiesV2Request;
import org.eclipse.jgit.transport.FetchRequest;
import org.eclipse.jgit.transport.FetchV0Request;
import org.eclipse.jgit.transport.FetchV2Request;
import org.eclipse.jgit.transport.FilterSpec;
import org.eclipse.jgit.transport.GitProtocolConstants$MultiAck;
import org.eclipse.jgit.transport.LsRefsV2Request;
import org.eclipse.jgit.transport.ObjectInfoRequest;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.PostUploadHook;
import org.eclipse.jgit.transport.PreUploadHook;
import org.eclipse.jgit.transport.ProtocolV0Parser;
import org.eclipse.jgit.transport.ProtocolV2Hook;
import org.eclipse.jgit.transport.ProtocolV2Parser;
import org.eclipse.jgit.transport.RefAdvertiser;
import org.eclipse.jgit.transport.RefAdvertiser$PacketLineOutRefAdvertiser;
import org.eclipse.jgit.transport.RefFilter;
import org.eclipse.jgit.transport.RequestNotYetReadException;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.SideBandOutputStream;
import org.eclipse.jgit.transport.SideBandProgressMonitor;
import org.eclipse.jgit.transport.TransferConfig;
import org.eclipse.jgit.transport.TransferConfig$ProtocolVersion;
import org.eclipse.jgit.transport.UploadPack$AdvertisedRequestValidator;
import org.eclipse.jgit.transport.UploadPack$AnyRequestValidator;
import org.eclipse.jgit.transport.UploadPack$ErrorWriter;
import org.eclipse.jgit.transport.UploadPack$IOConsumer;
import org.eclipse.jgit.transport.UploadPack$Option;
import org.eclipse.jgit.transport.UploadPack$PackProtocolErrorWriter;
import org.eclipse.jgit.transport.UploadPack$ReachableCommitRequestValidator;
import org.eclipse.jgit.transport.UploadPack$ReachableCommitTipRequestValidator;
import org.eclipse.jgit.transport.UploadPack$RequestPolicy;
import org.eclipse.jgit.transport.UploadPack$RequestValidator;
import org.eclipse.jgit.transport.UploadPack$ResponseBufferedOutputStream;
import org.eclipse.jgit.transport.UploadPack$SideBandErrorWriter;
import org.eclipse.jgit.transport.UploadPack$TipRequestValidator;
import org.eclipse.jgit.transport.UploadPackInternalServerErrorException;
import org.eclipse.jgit.transport.UserAgent;
import org.eclipse.jgit.transport.WantNotValidException;
import org.eclipse.jgit.util.RefMap;
import org.eclipse.jgit.util.io.InterruptTimer;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.eclipse.jgit.util.io.TimeoutInputStream;
import org.eclipse.jgit.util.io.TimeoutOutputStream;

public class UploadPack
implements Closeable {
    private final Repository db;
    private final RevWalk walk;
    private PackConfig packConfig;
    private TransferConfig transferConfig;
    private int timeout;
    private boolean biDirectionalPipe = true;
    private InterruptTimer timer;
    private boolean clientRequestedV2;
    private InputStream rawIn;
    private UploadPack$ResponseBufferedOutputStream rawOut;
    private PacketLineIn pckIn;
    private OutputStream msgOut = NullOutputStream.INSTANCE;
    private UploadPack$ErrorWriter errOut = new UploadPack$PackProtocolErrorWriter(this);
    private Map refs;
    private ProtocolV2Hook protocolV2Hook = ProtocolV2Hook.DEFAULT;
    private AdvertiseRefsHook advertiseRefsHook = AdvertiseRefsHook.DEFAULT;
    private boolean advertiseRefsHookCalled;
    private RefFilter refFilter = RefFilter.DEFAULT;
    private PreUploadHook preUploadHook = PreUploadHook.NULL;
    private PostUploadHook postUploadHook = PostUploadHook.NULL;
    String userAgent;
    private Set wantIds = new HashSet();
    private final Set wantAll = new HashSet();
    private final Set commonBase = new HashSet();
    private int oldestTime;
    private Boolean okToGiveUp;
    private boolean sentReady;
    private Set advertised;
    private final RevFlag WANT;
    private final RevFlag PEER_HAS;
    private final RevFlag COMMON;
    private final RevFlag SATISFIED;
    private final RevFlagSet SAVE;
    private UploadPack$RequestValidator requestValidator = new UploadPack$AdvertisedRequestValidator();
    private GitProtocolConstants$MultiAck multiAck = GitProtocolConstants$MultiAck.OFF;
    private boolean noDone;
    private PackStatistics statistics;
    private FetchRequest currentRequest;
    private CachedPackUriProvider cachedPackUriProvider;

    public UploadPack(Repository repository) {
        this.db = repository;
        this.walk = new RevWalk(this.db);
        this.walk.setRetainBody(false);
        this.WANT = this.walk.newFlag("WANT");
        this.PEER_HAS = this.walk.newFlag("PEER_HAS");
        this.COMMON = this.walk.newFlag("COMMON");
        this.SATISFIED = this.walk.newFlag("SATISFIED");
        this.walk.carry(this.PEER_HAS);
        this.SAVE = new RevFlagSet();
        this.SAVE.add(this.WANT);
        this.SAVE.add(this.PEER_HAS);
        this.SAVE.add(this.COMMON);
        this.SAVE.add(this.SATISFIED);
        this.setTransferConfig(null);
    }

    public final Repository getRepository() {
        return this.db;
    }

    public final RevWalk getRevWalk() {
        return this.walk;
    }

    public final Map getAdvertisedRefs() {
        return this.refs;
    }

    public void setAdvertisedRefs(@Nullable Map map) {
        this.refs = map != null ? map : this.db.getAllRefs();
        this.refs = this.refFilter == RefFilter.DEFAULT ? this.transferConfig.getRefFilter().filter(this.refs) : this.refFilter.filter(this.refs);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n2) {
        this.timeout = n2;
    }

    public boolean isBiDirectionalPipe() {
        return this.biDirectionalPipe;
    }

    public void setBiDirectionalPipe(boolean bl2) {
        this.biDirectionalPipe = bl2;
    }

    public UploadPack$RequestPolicy getRequestPolicy() {
        if (this.requestValidator instanceof UploadPack$AdvertisedRequestValidator) {
            return UploadPack$RequestPolicy.ADVERTISED;
        }
        if (this.requestValidator instanceof UploadPack$ReachableCommitRequestValidator) {
            return UploadPack$RequestPolicy.REACHABLE_COMMIT;
        }
        if (this.requestValidator instanceof UploadPack$TipRequestValidator) {
            return UploadPack$RequestPolicy.TIP;
        }
        if (this.requestValidator instanceof UploadPack$ReachableCommitTipRequestValidator) {
            return UploadPack$RequestPolicy.REACHABLE_COMMIT_TIP;
        }
        if (this.requestValidator instanceof UploadPack$AnyRequestValidator) {
            return UploadPack$RequestPolicy.ANY;
        }
        return null;
    }

    public void setRequestPolicy(UploadPack$RequestPolicy uploadPack$RequestPolicy) {
        switch (uploadPack$RequestPolicy) {
            default: {
                this.requestValidator = new UploadPack$AdvertisedRequestValidator();
                break;
            }
            case REACHABLE_COMMIT: {
                this.requestValidator = new UploadPack$ReachableCommitRequestValidator();
                break;
            }
            case TIP: {
                this.requestValidator = new UploadPack$TipRequestValidator();
                break;
            }
            case REACHABLE_COMMIT_TIP: {
                this.requestValidator = new UploadPack$ReachableCommitTipRequestValidator();
                break;
            }
            case ANY: {
                this.requestValidator = new UploadPack$AnyRequestValidator();
            }
        }
    }

    public void setRequestValidator(@Nullable UploadPack$RequestValidator uploadPack$RequestValidator) {
        this.requestValidator = uploadPack$RequestValidator != null ? uploadPack$RequestValidator : new UploadPack$AdvertisedRequestValidator();
    }

    public AdvertiseRefsHook getAdvertiseRefsHook() {
        return this.advertiseRefsHook;
    }

    public RefFilter getRefFilter() {
        return this.refFilter;
    }

    public void setAdvertiseRefsHook(@Nullable AdvertiseRefsHook advertiseRefsHook) {
        this.advertiseRefsHook = advertiseRefsHook != null ? advertiseRefsHook : AdvertiseRefsHook.DEFAULT;
    }

    public void setProtocolV2Hook(@Nullable ProtocolV2Hook protocolV2Hook) {
        this.protocolV2Hook = protocolV2Hook != null ? protocolV2Hook : ProtocolV2Hook.DEFAULT;
    }

    public ProtocolV2Hook getProtocolV2Hook() {
        return this.protocolV2Hook != null ? this.protocolV2Hook : ProtocolV2Hook.DEFAULT;
    }

    public void setRefFilter(@Nullable RefFilter refFilter) {
        this.refFilter = refFilter != null ? refFilter : RefFilter.DEFAULT;
    }

    public PreUploadHook getPreUploadHook() {
        return this.preUploadHook;
    }

    public void setPreUploadHook(@Nullable PreUploadHook preUploadHook) {
        this.preUploadHook = preUploadHook != null ? preUploadHook : PreUploadHook.NULL;
    }

    public PostUploadHook getPostUploadHook() {
        return this.postUploadHook;
    }

    public void setPostUploadHook(@Nullable PostUploadHook postUploadHook) {
        this.postUploadHook = postUploadHook != null ? postUploadHook : PostUploadHook.NULL;
    }

    public void setPackConfig(@Nullable PackConfig packConfig) {
        this.packConfig = packConfig;
    }

    public void setTransferConfig(@Nullable TransferConfig transferConfig) {
        TransferConfig transferConfig2 = this.transferConfig = transferConfig != null ? transferConfig : new TransferConfig(this.db);
        if (this.transferConfig.isAllowTipSha1InWant()) {
            this.setRequestPolicy(this.transferConfig.isAllowReachableSha1InWant() ? UploadPack$RequestPolicy.REACHABLE_COMMIT_TIP : UploadPack$RequestPolicy.TIP);
        } else {
            this.setRequestPolicy(this.transferConfig.isAllowReachableSha1InWant() ? UploadPack$RequestPolicy.REACHABLE_COMMIT : UploadPack$RequestPolicy.ADVERTISED);
        }
    }

    public boolean isSideBand() {
        if (this.currentRequest == null) {
            throw new RequestNotYetReadException();
        }
        Set set = this.currentRequest.getClientCapabilities();
        return set.contains("side-band") || set.contains("side-band-64k");
    }

    public void setExtraParameters(Collection collection) {
        this.clientRequestedV2 = collection.contains("version=2");
    }

    public void setCachedPackUriProvider(@Nullable CachedPackUriProvider cachedPackUriProvider) {
        this.cachedPackUriProvider = cachedPackUriProvider;
    }

    private boolean useProtocolV2() {
        return (this.transferConfig.protocolVersion == null || TransferConfig$ProtocolVersion.V2.equals((Object)this.transferConfig.protocolVersion)) && this.clientRequestedV2;
    }

    @Override
    public void close() {
        if (this.timer != null) {
            try {
                this.timer.terminate();
            }
            finally {
                this.timer = null;
            }
        }
    }

    public void upload(InputStream inputStream, OutputStream outputStream, @Nullable OutputStream outputStream2) {
        try {
            this.uploadWithExceptionPropagation(inputStream, outputStream, outputStream2);
        }
        catch (ServiceMayNotContinueException serviceMayNotContinueException) {
            if (!serviceMayNotContinueException.isOutput() && serviceMayNotContinueException.getMessage() != null) {
                try {
                    this.errOut.writeError(serviceMayNotContinueException.getMessage());
                }
                catch (IOException iOException) {
                    serviceMayNotContinueException.addSuppressed(iOException);
                    throw serviceMayNotContinueException;
                }
                serviceMayNotContinueException.setOutput();
            }
            throw serviceMayNotContinueException;
        }
        catch (IOException | Error | RuntimeException throwable) {
            if (this.rawOut != null) {
                String string = throwable instanceof PackProtocolException ? throwable.getMessage() : JGitText.get().internalServerError;
                try {
                    this.errOut.writeError(string);
                }
                catch (IOException iOException) {
                    throwable.addSuppressed(iOException);
                    throw throwable;
                }
                throw new UploadPackInternalServerErrorException(throwable);
            }
            throw throwable;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadWithExceptionPropagation(InputStream inputStream, OutputStream outputStream, @Nullable OutputStream outputStream2) {
        try {
            Object object;
            this.rawIn = inputStream;
            if (outputStream2 != null) {
                this.msgOut = outputStream2;
            }
            if (this.timeout > 0) {
                object = Thread.currentThread();
                this.timer = new InterruptTimer(((Thread)object).getName() + "-Timer");
                TimeoutInputStream timeoutInputStream = new TimeoutInputStream(this.rawIn, this.timer);
                TimeoutOutputStream timeoutOutputStream = new TimeoutOutputStream(outputStream, this.timer);
                timeoutInputStream.setTimeout(this.timeout * 1000);
                timeoutOutputStream.setTimeout(this.timeout * 1000);
                this.rawIn = timeoutInputStream;
                outputStream = timeoutOutputStream;
            }
            this.rawOut = new UploadPack$ResponseBufferedOutputStream(outputStream);
            if (this.biDirectionalPipe) {
                this.rawOut.stopBuffering();
            }
            this.pckIn = new PacketLineIn(this.rawIn);
            object = new PacketLineOut(this.rawOut);
            if (this.useProtocolV2()) {
                this.serviceV2((PacketLineOut)object);
            } else {
                this.service((PacketLineOut)object);
            }
        }
        finally {
            this.msgOut = NullOutputStream.INSTANCE;
            this.walk.close();
        }
    }

    public PackStatistics getStatistics() {
        return this.statistics;
    }

    private Map getAdvertisedOrDefaultRefs() {
        if (this.refs != null) {
            return this.refs;
        }
        if (!this.advertiseRefsHookCalled) {
            this.advertiseRefsHook.advertiseRefs(this);
            this.advertiseRefsHookCalled = true;
        }
        if (this.refs == null) {
            this.setAdvertisedRefs((Map)this.db.getRefDatabase().getRefs().stream().collect(RefMap.toRefMap((ref, ref2) -> ref2)));
        }
        return this.refs;
    }

    private Map getFilteredRefs(Collection collection) {
        if (collection.isEmpty()) {
            return this.getAdvertisedOrDefaultRefs();
        }
        if (this.refs == null && !this.advertiseRefsHookCalled) {
            this.advertiseRefsHook.advertiseRefs(this);
            this.advertiseRefsHookCalled = true;
        }
        if (this.refs == null) {
            String[] stringArray = collection.toArray(new String[0]);
            Map map = (Map)this.db.getRefDatabase().getRefsByPrefix(stringArray).stream().collect(RefMap.toRefMap((ref, ref2) -> ref2));
            if (this.refFilter != RefFilter.DEFAULT) {
                return this.refFilter.filter(map);
            }
            return this.transferConfig.getRefFilter().filter(map);
        }
        return (Map)this.refs.values().stream().filter(ref -> collection.stream().anyMatch(ref.getName()::startsWith)).collect(RefMap.toRefMap((ref, ref2) -> ref2));
    }

    @NonNull
    private static Map mapRefs(Map map, List list) {
        return Collections.unmodifiableMap((Map)list.stream().map(map::get).filter(Objects::nonNull).collect(RefMap.toRefMap((ref, ref2) -> ref2)));
    }

    @NonNull
    private Map exactRefs(List list) {
        if (this.refs != null) {
            return UploadPack.mapRefs(this.refs, list);
        }
        if (!this.advertiseRefsHookCalled) {
            this.advertiseRefsHook.advertiseRefs(this);
            this.advertiseRefsHookCalled = true;
        }
        if (this.refs == null && this.refFilter == RefFilter.DEFAULT && this.transferConfig.hasDefaultRefFilter()) {
            String[] stringArray = list.toArray(new String[0]);
            return Collections.unmodifiableMap(this.db.getRefDatabase().exactRef(stringArray));
        }
        return UploadPack.mapRefs(this.getAdvertisedOrDefaultRefs(), list);
    }

    @Nullable
    private Ref findRef(String string) {
        if (this.refs != null) {
            return RefDatabase.findRef(this.refs, string);
        }
        if (!this.advertiseRefsHookCalled) {
            this.advertiseRefsHook.advertiseRefs(this);
            this.advertiseRefsHookCalled = true;
        }
        if (this.refs == null && this.refFilter == RefFilter.DEFAULT && this.transferConfig.hasDefaultRefFilter()) {
            return this.db.getRefDatabase().findRef(string);
        }
        return RefDatabase.findRef(this.getAdvertisedOrDefaultRefs(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void service(PacketLineOut packetLineOut) {
        block16: {
            boolean bl2 = false;
            PackStatistics$Accumulator packStatistics$Accumulator = new PackStatistics$Accumulator();
            ArrayList arrayList = new ArrayList();
            try {
                if (this.biDirectionalPipe) {
                    this.sendAdvertisedRefs(new RefAdvertiser$PacketLineOutRefAdvertiser(packetLineOut));
                } else {
                    this.advertised = this.requestValidator instanceof UploadPack$AnyRequestValidator ? Collections.emptySet() : UploadPack.refIdSet(this.getAdvertisedOrDefaultRefs().values());
                }
                Instant instant = Instant.now();
                packStatistics$Accumulator.advertised = this.advertised.size();
                ProtocolV0Parser protocolV0Parser = new ProtocolV0Parser(this.transferConfig);
                FetchV0Request fetchV0Request = protocolV0Parser.recvWants(this.pckIn);
                this.currentRequest = fetchV0Request;
                this.wantIds = fetchV0Request.getWantIds();
                if (fetchV0Request.getWantIds().isEmpty()) {
                    this.preUploadHook.onBeginNegotiateRound(this, fetchV0Request.getWantIds(), 0);
                    this.preUploadHook.onEndNegotiateRound(this, fetchV0Request.getWantIds(), 0, 0, false);
                }
                packStatistics$Accumulator.wants = fetchV0Request.getWantIds().size();
                if (fetchV0Request.getClientCapabilities().contains("multi_ack_detailed")) {
                    this.multiAck = GitProtocolConstants$MultiAck.DETAILED;
                    this.noDone = fetchV0Request.getClientCapabilities().contains("no-done");
                } else {
                    this.multiAck = fetchV0Request.getClientCapabilities().contains("multi_ack") ? GitProtocolConstants$MultiAck.CONTINUE : GitProtocolConstants$MultiAck.OFF;
                }
                if (!fetchV0Request.getClientShallowCommits().isEmpty()) {
                    this.verifyClientShallow(fetchV0Request.getClientShallowCommits());
                }
                if (fetchV0Request.getDepth() != 0 || fetchV0Request.getDeepenSince() != 0) {
                    this.computeShallowsAndUnshallows(fetchV0Request, objectId -> packetLineOut.writeString("shallow " + objectId.name() + '\n'), objectId -> {
                        packetLineOut.writeString("unshallow " + objectId.name() + '\n');
                        arrayList.add(objectId);
                    }, Collections.emptyList());
                    packetLineOut.end();
                }
                if (!fetchV0Request.getClientShallowCommits().isEmpty()) {
                    this.walk.assumeShallow(fetchV0Request.getClientShallowCommits());
                }
                bl2 = this.negotiate(fetchV0Request, packStatistics$Accumulator, packetLineOut);
                packStatistics$Accumulator.timeNegotiating = Duration.between(instant, Instant.now()).toMillis();
                if (!bl2) {
                }
                if (this.biDirectionalPipe) {
                }
                int n2 = this.rawIn.read();
                if (0 <= n2) {
                    bl2 = false;
                    throw new CorruptObjectException(MessageFormat.format(JGitText.get().expectedEOFReceived, "\\x" + Integer.toHexString(n2)));
                }
            }
            finally {
                if (bl2 || this.biDirectionalPipe) break block16;
            }
            while (0L < this.rawIn.skip(2048L) || 0 <= this.rawIn.read()) {
            }
        }
        this.rawOut.stopBuffering();
    }

    private void lsRefsV2(PacketLineOut packetLineOut) {
        ProtocolV2Parser protocolV2Parser = new ProtocolV2Parser(this.transferConfig);
        LsRefsV2Request lsRefsV2Request = protocolV2Parser.parseLsRefsRequest(this.pckIn);
        this.protocolV2Hook.onLsRefs(lsRefsV2Request);
        this.rawOut.stopBuffering();
        RefAdvertiser$PacketLineOutRefAdvertiser refAdvertiser$PacketLineOutRefAdvertiser = new RefAdvertiser$PacketLineOutRefAdvertiser(packetLineOut);
        refAdvertiser$PacketLineOutRefAdvertiser.init(this.db);
        refAdvertiser$PacketLineOutRefAdvertiser.setUseProtocolV2(true);
        if (lsRefsV2Request.getPeel()) {
            refAdvertiser$PacketLineOutRefAdvertiser.setDerefTags(true);
        }
        Map map = this.getFilteredRefs(lsRefsV2Request.getRefPrefixes());
        if (lsRefsV2Request.getSymrefs()) {
            UploadPack.findSymrefs(refAdvertiser$PacketLineOutRefAdvertiser, map);
        }
        refAdvertiser$PacketLineOutRefAdvertiser.send(map.values());
        refAdvertiser$PacketLineOutRefAdvertiser.end();
    }

    private Map wantedRefs(FetchV2Request fetchV2Request) {
        TreeMap<String, ObjectId> treeMap = new TreeMap<String, ObjectId>();
        List list = fetchV2Request.getWantedRefs();
        Map map = this.exactRefs(list);
        for (String string : list) {
            Ref ref = (Ref)map.get(string);
            if (ref == null) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidRefName, string));
            }
            ObjectId objectId = ref.getObjectId();
            if (objectId == null) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidRefName, string));
            }
            treeMap.put(string, objectId);
        }
        return treeMap;
    }

    private void fetchV2(PacketLineOut packetLineOut) {
        this.advertised = this.requestValidator instanceof UploadPack$TipRequestValidator || this.requestValidator instanceof UploadPack$ReachableCommitTipRequestValidator || this.requestValidator instanceof UploadPack$AnyRequestValidator ? Collections.emptySet() : UploadPack.refIdSet(this.getAdvertisedOrDefaultRefs().values());
        PackStatistics$Accumulator packStatistics$Accumulator = new PackStatistics$Accumulator();
        Instant instant = Instant.now();
        ProtocolV2Parser protocolV2Parser = new ProtocolV2Parser(this.transferConfig);
        FetchV2Request fetchV2Request = protocolV2Parser.parseFetchRequest(this.pckIn);
        this.currentRequest = fetchV2Request;
        this.rawOut.stopBuffering();
        this.protocolV2Hook.onFetch(fetchV2Request);
        if (fetchV2Request.getSidebandAll()) {
            packetLineOut.setUsingSideband(true);
        }
        ArrayList<ObjectId> arrayList = new ArrayList<ObjectId>();
        for (String string : fetchV2Request.getDeepenNotRefs()) {
            Ref ref = this.findRef(string);
            if (ref == null) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidRefName, string));
            }
            arrayList.add(ref.getObjectId());
        }
        Map map = this.wantedRefs(fetchV2Request);
        fetchV2Request.getWantIds().addAll(map.values());
        this.wantIds = fetchV2Request.getWantIds();
        boolean bl2 = false;
        boolean bl3 = fetchV2Request.getDepth() != 0 || fetchV2Request.getDeepenSince() != 0 || !fetchV2Request.getDeepenNotRefs().isEmpty();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        if (!fetchV2Request.getClientShallowCommits().isEmpty()) {
            this.verifyClientShallow(fetchV2Request.getClientShallowCommits());
        }
        if (bl3) {
            this.computeShallowsAndUnshallows(fetchV2Request, objectId -> arrayList2.add(objectId), objectId -> arrayList3.add(objectId), arrayList);
        }
        if (!fetchV2Request.getClientShallowCommits().isEmpty()) {
            this.walk.assumeShallow(fetchV2Request.getClientShallowCommits());
        }
        if (fetchV2Request.wasDoneReceived()) {
            this.processHaveLines(fetchV2Request.getPeerHas(), ObjectId.zeroId(), new PacketLineOut(NullOutputStream.INSTANCE, false), packStatistics$Accumulator, fetchV2Request.wasWaitForDoneReceived() ? UploadPack$Option.WAIT_FOR_DONE : UploadPack$Option.NONE);
        } else {
            packetLineOut.writeString("acknowledgments\n");
            for (ObjectId object : fetchV2Request.getPeerHas()) {
                if (!this.walk.getObjectReader().has(object)) continue;
                packetLineOut.writeString("ACK " + object.getName() + "\n");
            }
            this.processHaveLines(fetchV2Request.getPeerHas(), ObjectId.zeroId(), new PacketLineOut(NullOutputStream.INSTANCE, false), packStatistics$Accumulator, UploadPack$Option.NONE);
            if (!fetchV2Request.wasWaitForDoneReceived() && this.okToGiveUp()) {
                packetLineOut.writeString("ready\n");
            } else if (this.commonBase.isEmpty()) {
                packetLineOut.writeString("NAK\n");
            }
            bl2 = true;
        }
        if (fetchV2Request.wasDoneReceived() || !fetchV2Request.wasWaitForDoneReceived() && this.okToGiveUp()) {
            if (bl3) {
                if (bl2) {
                    packetLineOut.writeDelim();
                }
                packetLineOut.writeString("shallow-info\n");
                for (ObjectId objectId2 : arrayList2) {
                    packetLineOut.writeString("shallow " + objectId2.getName() + '\n');
                }
                for (ObjectId objectId3 : arrayList3) {
                    packetLineOut.writeString("unshallow " + objectId3.getName() + '\n');
                }
                bl2 = true;
            }
            if (!map.isEmpty()) {
                if (bl2) {
                    packetLineOut.writeDelim();
                }
                packetLineOut.writeString("wanted-refs\n");
                for (Map.Entry entry : map.entrySet()) {
                    packetLineOut.writeString(((ObjectId)entry.getValue()).getName() + ' ' + (String)entry.getKey() + '\n');
                }
                bl2 = true;
            }
            if (bl2) {
                packetLineOut.writeDelim();
            }
            if (!packetLineOut.isUsingSideband()) {
                packetLineOut.writeString("packfile\n");
            }
            packStatistics$Accumulator.timeNegotiating = Duration.between(instant, Instant.now()).toMillis();
            this.sendPack(packStatistics$Accumulator, fetchV2Request, fetchV2Request.getClientCapabilities().contains("include-tag") ? this.db.getRefDatabase().getRefsByPrefix("refs/tags/") : null, arrayList3, arrayList, packetLineOut);
        } else {
            packetLineOut.end();
        }
    }

    private void objectInfo(PacketLineOut packetLineOut) {
        ProtocolV2Parser protocolV2Parser = new ProtocolV2Parser(this.transferConfig);
        ObjectInfoRequest objectInfoRequest = protocolV2Parser.parseObjectInfoRequest(this.pckIn);
        this.protocolV2Hook.onObjectInfo(objectInfoRequest);
        ObjectReader objectReader = this.getRepository().newObjectReader();
        packetLineOut.writeString("size");
        for (ObjectId objectId : objectInfoRequest.getObjectIDs()) {
            long l2;
            try {
                l2 = objectReader.getObjectSize(objectId, -1);
            }
            catch (MissingObjectException missingObjectException) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().missingObject, objectId.name()), missingObjectException);
            }
            packetLineOut.writeString(objectId.getName() + " " + l2);
        }
        packetLineOut.end();
    }

    private boolean serveOneCommandV2(PacketLineOut packetLineOut) {
        String string;
        try {
            string = this.pckIn.readString();
        }
        catch (EOFException eOFException) {
            return true;
        }
        if (PacketLineIn.isEnd(string)) {
            return true;
        }
        if (string.equals("command=ls-refs")) {
            this.lsRefsV2(packetLineOut);
            return false;
        }
        if (string.equals("command=fetch")) {
            this.fetchV2(packetLineOut);
            return false;
        }
        if (string.equals("command=object-info")) {
            this.objectInfo(packetLineOut);
            return false;
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().unknownTransportCommand, string));
    }

    private List getV2CapabilityAdvertisement() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("version 2");
        arrayList.add("ls-refs");
        boolean bl2 = this.transferConfig.isAllowRefInWant() && this.db.getConfig().getBoolean("uploadpack", null, "advertiserefinwant", true);
        arrayList.add("fetch=" + (this.transferConfig.isAllowFilter() ? "filter " : "") + (bl2 ? "ref-in-want " : "") + (this.transferConfig.isAdvertiseSidebandAll() ? "sideband-all " : "") + (this.cachedPackUriProvider != null ? "packfile-uris " : "") + (this.transferConfig.isAdvertiseWaitForDone() ? "wait-for-done " : "") + "shallow");
        arrayList.add("server-option");
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceV2(PacketLineOut packetLineOut) {
        block7: {
            if (this.biDirectionalPipe) {
                this.protocolV2Hook.onCapabilities(CapabilitiesV2Request.builder().build());
                for (String string : this.getV2CapabilityAdvertisement()) {
                    packetLineOut.writeString(string + "\n");
                }
                packetLineOut.end();
                while (!this.serveOneCommandV2(packetLineOut)) {
                }
                return;
            }
            try {
                this.serveOneCommandV2(packetLineOut);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            while (0L < this.rawIn.skip(2048L) || 0 <= this.rawIn.read()) {
            }
            break block7;
            while (0L < this.rawIn.skip(2048L) || 0 <= this.rawIn.read()) {
            }
            this.rawOut.stopBuffering();
            throw throwable;
        }
        this.rawOut.stopBuffering();
    }

    private static Set refIdSet(Collection collection) {
        HashSet<ObjectId> hashSet = new HashSet<ObjectId>(collection.size());
        for (Ref ref : collection) {
            ObjectId objectId = ref.getObjectId();
            if (objectId != null) {
                hashSet.add(objectId);
            }
            if ((objectId = ref.getPeeledObjectId()) == null) continue;
            hashSet.add(objectId);
        }
        return hashSet;
    }

    private void computeShallowsAndUnshallows(FetchRequest fetchRequest, UploadPack$IOConsumer uploadPack$IOConsumer, UploadPack$IOConsumer uploadPack$IOConsumer2, List list) {
        if (fetchRequest.getClientCapabilities().contains("deepen-relative")) {
            throw new UnsupportedOperationException();
        }
        int n2 = fetchRequest.getDepth() == 0 ? Integer.MAX_VALUE : fetchRequest.getDepth() - 1;
        try (DepthWalk$RevWalk depthWalk$RevWalk = new DepthWalk$RevWalk(this.walk.getObjectReader(), n2);){
            depthWalk$RevWalk.setDeepenSince(fetchRequest.getDeepenSince());
            Object object = fetchRequest.getWantIds().iterator();
            while (object.hasNext()) {
                ObjectId objectId = (ObjectId)object.next();
                try {
                    depthWalk$RevWalk.markRoot(depthWalk$RevWalk.parseCommit(objectId));
                }
                catch (IncorrectObjectTypeException incorrectObjectTypeException) {}
            }
            depthWalk$RevWalk.setDeepenNots(list);
            boolean bl2 = false;
            while ((object = depthWalk$RevWalk.next()) != null) {
                boolean bl3;
                DepthWalk$Commit depthWalk$Commit = (DepthWalk$Commit)object;
                bl2 = true;
                boolean bl4 = bl3 = depthWalk$Commit.getDepth() == n2 || depthWalk$Commit.isBoundary();
                if (bl3 && !fetchRequest.getClientShallowCommits().contains(depthWalk$Commit)) {
                    uploadPack$IOConsumer.accept(depthWalk$Commit.copy());
                }
                if (bl3 || !fetchRequest.getClientShallowCommits().remove(depthWalk$Commit)) continue;
                uploadPack$IOConsumer2.accept(depthWalk$Commit.copy());
            }
            if (!bl2) {
                throw new PackProtocolException(JGitText.get().noCommitsSelectedForShallow);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyClientShallow(Set set) {
        block7: {
            AsyncRevObjectQueue asyncRevObjectQueue = this.walk.parseAny(set, true);
            try {
                while (true) {
                    try {
                        RevObject revObject;
                        do {
                            if ((revObject = asyncRevObjectQueue.next()) != null) continue;
                            break block7;
                        } while (revObject instanceof RevCommit);
                        throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidShallowObject, revObject.name()));
                    }
                    catch (MissingObjectException missingObjectException) {
                        set.remove(missingObjectException.getObjectId());
                        continue;
                    }
                    break;
                }
            }
            finally {
                asyncRevObjectQueue.release();
            }
        }
    }

    public void sendAdvertisedRefs(RefAdvertiser refAdvertiser) {
        this.sendAdvertisedRefs(refAdvertiser, null);
    }

    public void sendAdvertisedRefs(RefAdvertiser refAdvertiser, @Nullable String string) {
        UploadPack$RequestPolicy uploadPack$RequestPolicy;
        if (this.useProtocolV2()) {
            this.protocolV2Hook.onCapabilities(CapabilitiesV2Request.builder().build());
            for (String string2 : this.getV2CapabilityAdvertisement()) {
                refAdvertiser.writeOne(string2);
            }
            refAdvertiser.end();
            return;
        }
        Map map = this.getAdvertisedOrDefaultRefs();
        if (string != null) {
            refAdvertiser.writeOne("# service=" + string + '\n');
            refAdvertiser.end();
        }
        refAdvertiser.init(this.db);
        refAdvertiser.advertiseCapability("include-tag");
        refAdvertiser.advertiseCapability("multi_ack_detailed");
        refAdvertiser.advertiseCapability("multi_ack");
        refAdvertiser.advertiseCapability("ofs-delta");
        refAdvertiser.advertiseCapability("side-band");
        refAdvertiser.advertiseCapability("side-band-64k");
        refAdvertiser.advertiseCapability("thin-pack");
        refAdvertiser.advertiseCapability("no-progress");
        refAdvertiser.advertiseCapability("shallow");
        if (!this.biDirectionalPipe) {
            refAdvertiser.advertiseCapability("no-done");
        }
        if ((uploadPack$RequestPolicy = this.getRequestPolicy()) == UploadPack$RequestPolicy.TIP || uploadPack$RequestPolicy == UploadPack$RequestPolicy.REACHABLE_COMMIT_TIP || uploadPack$RequestPolicy == null) {
            refAdvertiser.advertiseCapability("allow-tip-sha1-in-want");
        }
        if (uploadPack$RequestPolicy == UploadPack$RequestPolicy.REACHABLE_COMMIT || uploadPack$RequestPolicy == UploadPack$RequestPolicy.REACHABLE_COMMIT_TIP || uploadPack$RequestPolicy == null) {
            refAdvertiser.advertiseCapability("allow-reachable-sha1-in-want");
        }
        refAdvertiser.advertiseCapability("agent", UserAgent.get());
        if (this.transferConfig.isAllowFilter()) {
            refAdvertiser.advertiseCapability("filter");
        }
        refAdvertiser.setDerefTags(true);
        UploadPack.findSymrefs(refAdvertiser, map);
        this.advertised = refAdvertiser.send(map.values());
        if (refAdvertiser.isEmpty()) {
            refAdvertiser.advertiseId(ObjectId.zeroId(), "capabilities^{}");
        }
        refAdvertiser.end();
    }

    public void sendMessage(String string) {
        try {
            this.msgOut.write(Constants.encode(string + "\n"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public OutputStream getMessageOutputStream() {
        return this.msgOut;
    }

    public int getDepth() {
        if (this.currentRequest == null) {
            throw new RequestNotYetReadException();
        }
        return this.currentRequest.getDepth();
    }

    @Deprecated
    public final long getFilterBlobLimit() {
        return this.getFilterSpec().getBlobLimit();
    }

    public final FilterSpec getFilterSpec() {
        if (this.currentRequest == null) {
            throw new RequestNotYetReadException();
        }
        return this.currentRequest.getFilterSpec();
    }

    public String getPeerUserAgent() {
        if (this.currentRequest != null && this.currentRequest.getAgent() != null) {
            return this.currentRequest.getAgent();
        }
        return this.userAgent;
    }

    private boolean negotiate(FetchRequest fetchRequest, PackStatistics$Accumulator packStatistics$Accumulator, PacketLineOut packetLineOut) {
        String string;
        this.okToGiveUp = Boolean.FALSE;
        ObjectId objectId = ObjectId.zeroId();
        ArrayList<ObjectId> arrayList = new ArrayList<ObjectId>(64);
        while (true) {
            try {
                string = this.pckIn.readString();
            }
            catch (EOFException eOFException) {
                if (!this.biDirectionalPipe && fetchRequest.getDepth() > 0) {
                    return false;
                }
                throw eOFException;
            }
            if (PacketLineIn.isEnd(string)) {
                objectId = this.processHaveLines(arrayList, objectId, packetLineOut, packStatistics$Accumulator, UploadPack$Option.NONE);
                if (this.commonBase.isEmpty() || this.multiAck != GitProtocolConstants$MultiAck.OFF) {
                    packetLineOut.writeString("NAK\n");
                }
                if (this.noDone && this.sentReady) {
                    packetLineOut.writeString("ACK " + objectId.name() + "\n");
                    return true;
                }
                if (!this.biDirectionalPipe) {
                    return false;
                }
                packetLineOut.flush();
                continue;
            }
            if (!string.startsWith("have ") || string.length() != 45) break;
            arrayList.add(ObjectId.fromString(string.substring(5)));
            ++packStatistics$Accumulator.haves;
        }
        if (string.equals("done")) {
            objectId = this.processHaveLines(arrayList, objectId, packetLineOut, packStatistics$Accumulator, UploadPack$Option.NONE);
            if (this.commonBase.isEmpty()) {
                packetLineOut.writeString("NAK\n");
            } else if (this.multiAck != GitProtocolConstants$MultiAck.OFF) {
                packetLineOut.writeString("ACK " + objectId.name() + "\n");
            }
            return true;
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "have", string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectId processHaveLines(List list, ObjectId objectId, PacketLineOut packetLineOut, PackStatistics$Accumulator packStatistics$Accumulator, UploadPack$Option uploadPack$Option) {
        this.preUploadHook.onBeginNegotiateRound(this, this.wantIds, list.size());
        if (this.wantAll.isEmpty() && !this.wantIds.isEmpty()) {
            this.parseWants(packStatistics$Accumulator);
        }
        if (list.isEmpty()) {
            return objectId;
        }
        this.sentReady = false;
        int n2 = 0;
        this.walk.getObjectReader().setAvoidUnreachableObjects(true);
        AsyncRevObjectQueue asyncRevObjectQueue = this.walk.parseAny(list, false);
        try {
            while (true) {
                RevObject revObject;
                try {
                    revObject = asyncRevObjectQueue.next();
                }
                catch (MissingObjectException missingObjectException) {
                    continue;
                }
                if (revObject == null) {
                    break;
                }
                objectId = revObject;
                ++n2;
                if (revObject instanceof RevCommit) {
                    RevCommit revCommit = (RevCommit)revObject;
                    if (this.oldestTime == 0 || revCommit.getCommitTime() < this.oldestTime) {
                        this.oldestTime = revCommit.getCommitTime();
                    }
                }
                if (revObject.has(this.PEER_HAS)) continue;
                revObject.add(this.PEER_HAS);
                if (revObject instanceof RevCommit) {
                    ((RevCommit)revObject).carry(this.PEER_HAS);
                }
                this.addCommonBase(revObject);
                switch (this.multiAck) {
                    case OFF: {
                        if (this.commonBase.size() != 1) break;
                        packetLineOut.writeString("ACK " + revObject.name() + "\n");
                        break;
                    }
                    case CONTINUE: {
                        packetLineOut.writeString("ACK " + revObject.name() + " continue\n");
                        break;
                    }
                    case DETAILED: {
                        packetLineOut.writeString("ACK " + revObject.name() + " common\n");
                    }
                }
            }
        }
        finally {
            asyncRevObjectQueue.release();
            this.walk.getObjectReader().setAvoidUnreachableObjects(false);
        }
        int n3 = list.size() - n2;
        if (uploadPack$Option != UploadPack$Option.WAIT_FOR_DONE) {
            this.sentReady = this.shouldGiveUp(list, packetLineOut, n3);
        }
        this.preUploadHook.onEndNegotiateRound(this, this.wantAll, n2, n3, this.sentReady);
        list.clear();
        return objectId;
    }

    private boolean shouldGiveUp(List list, PacketLineOut packetLineOut, int n2) {
        boolean bl2 = false;
        boolean bl3 = false;
        if (0 < n2) {
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                ObjectId objectId = (ObjectId)list.get(i2);
                if (this.walk.lookupOrNull(objectId) != null) continue;
                bl3 = true;
                if (!this.okToGiveUp()) break;
                switch (this.multiAck) {
                    case OFF: {
                        break;
                    }
                    case CONTINUE: {
                        packetLineOut.writeString("ACK " + objectId.name() + " continue\n");
                        break;
                    }
                    case DETAILED: {
                        packetLineOut.writeString("ACK " + objectId.name() + " ready\n");
                        bl2 = true;
                    }
                }
                break;
            }
        }
        if (this.multiAck == GitProtocolConstants$MultiAck.DETAILED && !bl3 && this.okToGiveUp()) {
            ObjectId objectId = (ObjectId)list.get(list.size() - 1);
            packetLineOut.writeString("ACK " + objectId.name() + " ready\n");
            bl2 = true;
        }
        return bl2;
    }

    private void parseWants(PackStatistics$Accumulator packStatistics$Accumulator) {
        Object object;
        ArrayList<ObjectId> arrayList = null;
        for (ObjectId objectId : this.wantIds) {
            if (this.advertised.contains(objectId)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<ObjectId>();
            }
            arrayList.add(objectId);
        }
        if (arrayList != null) {
            packStatistics$Accumulator.notAdvertisedWants = arrayList.size();
            object = Instant.now();
            this.requestValidator.checkWants(this, arrayList);
            packStatistics$Accumulator.reachabilityCheckDuration = Duration.between((Temporal)object, Instant.now()).toMillis();
        }
        object = this.walk.parseAny(this.wantIds, true);
        try {
            ObjectId objectId;
            while ((objectId = object.next()) != null) {
                this.want((RevObject)objectId);
                if (!(objectId instanceof RevCommit)) {
                    ((RevObject)objectId).add(this.SATISFIED);
                }
                if (!(objectId instanceof RevTag) || !((objectId = this.walk.peel((RevObject)objectId)) instanceof RevCommit)) continue;
                this.want((RevObject)objectId);
            }
            this.wantIds.clear();
        }
        catch (MissingObjectException missingObjectException) {
            throw new WantNotValidException(missingObjectException.getObjectId(), (Throwable)missingObjectException);
        }
        finally {
            object.release();
        }
    }

    private void want(RevObject revObject) {
        if (!revObject.has(this.WANT)) {
            revObject.add(this.WANT);
            this.wantAll.add(revObject);
        }
    }

    private static void checkNotAdvertisedWants(UploadPack uploadPack, List list, Collection collection) {
        ObjectReader objectReader = uploadPack.getRevWalk().getObjectReader();
        Set set = UploadPack.refIdSet(collection);
        List list2 = list.stream().filter(UploadPack.not(set::contains)).collect(Collectors.toList());
        try (RevWalk revWalk = new RevWalk(objectReader);){
            Stream<RevCommit> stream;
            boolean bl2;
            revWalk.setRetainBody(false);
            List list3 = UploadPack.objectIdsToRevObjects(revWalk, list2);
            List list4 = list3.stream().filter(revObject -> revObject instanceof RevCommit).map(revObject -> (RevCommit)revObject).collect(Collectors.toList());
            boolean bl3 = list3.size() == list4.size();
            boolean bl4 = bl2 = objectReader.getBitmapIndex() != null;
            if (!bl3) {
                if (!bl2 && !uploadPack.transferConfig.isAllowFilter()) {
                    RevObject revObject2 = (RevObject)list3.stream().filter(revObject -> !(revObject instanceof RevCommit)).limit(1L).collect(Collectors.toList()).get(0);
                    throw new WantNotValidException(revObject2);
                }
                try (ObjectWalk objectWalk = revWalk.toObjectWalkWithSameObjects();){
                    Stream<RevObject> stream2 = UploadPack.importantRefsFirst(collection).map(UploadPack::refToObjectId).map(objectId -> UploadPack.objectIdToRevObject(objectWalk, objectId)).filter(Objects::nonNull);
                    ObjectReachabilityChecker objectReachabilityChecker = objectReader.createObjectReachabilityChecker(objectWalk);
                    Optional optional = objectReachabilityChecker.areAllReachable(list3, stream2);
                    if (optional.isPresent()) {
                        throw new WantNotValidException((AnyObjectId)optional.get());
                    }
                }
                return;
            }
            ReachabilityChecker reachabilityChecker = objectReader.createReachabilityChecker(revWalk);
            Optional optional = reachabilityChecker.areAllReachable(list4, stream = UploadPack.importantRefsFirst(collection).map(UploadPack::refToObjectId).map(objectId -> UploadPack.objectIdToRevCommit(revWalk, objectId)).filter(Objects::nonNull));
            if (optional.isPresent()) {
                throw new WantNotValidException((AnyObjectId)optional.get());
            }
        }
        catch (MissingObjectException missingObjectException) {
            throw new WantNotValidException(missingObjectException.getObjectId(), (Throwable)missingObjectException);
        }
    }

    private static Predicate not(Predicate predicate) {
        return predicate.negate();
    }

    static Stream importantRefsFirst(Collection collection) {
        Predicate<Ref> predicate = ref -> ref.getName().startsWith("refs/heads/");
        Predicate<Ref> predicate2 = ref -> ref.getName().startsWith("refs/tags/");
        Predicate<Ref> predicate3 = ref -> !predicate.test((Ref)ref) && !predicate2.test((Ref)ref);
        return Stream.concat(collection.stream().filter(predicate), Stream.concat(collection.stream().filter(predicate2), collection.stream().filter(predicate3)));
    }

    private static ObjectId refToObjectId(Ref ref) {
        return ref.getObjectId() != null ? ref.getObjectId() : ref.getPeeledObjectId();
    }

    @Nullable
    private static RevCommit objectIdToRevCommit(RevWalk revWalk, ObjectId objectId) {
        if (objectId == null) {
            return null;
        }
        try {
            return revWalk.parseCommit(objectId);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Nullable
    private static RevObject objectIdToRevObject(RevWalk revWalk, ObjectId objectId) {
        if (objectId == null) {
            return null;
        }
        try {
            return revWalk.parseAny(objectId);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static List objectIdsToRevObjects(RevWalk revWalk, Iterable iterable) {
        ArrayList<RevObject> arrayList = new ArrayList<RevObject>();
        for (ObjectId objectId : iterable) {
            arrayList.add(revWalk.parseAny(objectId));
        }
        return arrayList;
    }

    private void addCommonBase(RevObject revObject) {
        if (!revObject.has(this.COMMON)) {
            revObject.add(this.COMMON);
            this.commonBase.add(revObject);
            this.okToGiveUp = null;
        }
    }

    private boolean okToGiveUp() {
        if (this.okToGiveUp == null) {
            this.okToGiveUp = this.okToGiveUpImp();
        }
        return this.okToGiveUp;
    }

    private boolean okToGiveUpImp() {
        if (this.commonBase.isEmpty()) {
            return false;
        }
        try {
            for (RevObject revObject : this.wantAll) {
                if (this.wantSatisfied(revObject)) continue;
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            throw new PackProtocolException(JGitText.get().internalRevisionError, iOException);
        }
    }

    private boolean wantSatisfied(RevObject revObject) {
        RevCommit revCommit;
        if (revObject.has(this.SATISFIED)) {
            return true;
        }
        if (((RevCommit)revObject).getParentCount() == 0) {
            revObject.add(this.SATISFIED);
            return true;
        }
        this.walk.resetRetain(this.SAVE);
        this.walk.markStart((RevCommit)revObject);
        if (this.oldestTime != 0) {
            this.walk.setRevFilter(CommitTimeRevFilter.after((long)this.oldestTime * 1000L));
        }
        while ((revCommit = this.walk.next()) != null) {
            if (!revCommit.has(this.PEER_HAS)) continue;
            this.addCommonBase(revCommit);
            revObject.add(this.SATISFIED);
            return true;
        }
        return false;
    }

    private void sendPack(PackStatistics$Accumulator packStatistics$Accumulator, FetchRequest fetchRequest, @Nullable Collection collection, List list, List list2, PacketLineOut packetLineOut) {
        boolean bl2;
        Set set = fetchRequest.getClientCapabilities();
        boolean bl3 = bl2 = set.contains("side-band") || set.contains("side-band-64k");
        if (bl2) {
            this.errOut = new UploadPack$SideBandErrorWriter(this, null);
            int n2 = 1000;
            if (fetchRequest.getClientCapabilities().contains("side-band-64k")) {
                n2 = 65520;
            }
            SideBandOutputStream sideBandOutputStream = new SideBandOutputStream(1, n2, this.rawOut);
            ProgressMonitor progressMonitor = NullProgressMonitor.INSTANCE;
            if (!fetchRequest.getClientCapabilities().contains("no-progress")) {
                this.msgOut = new SideBandOutputStream(2, n2, this.rawOut);
                progressMonitor = new SideBandProgressMonitor(this.msgOut);
            }
            this.sendPack(progressMonitor, packetLineOut, sideBandOutputStream, fetchRequest, packStatistics$Accumulator, collection, list, list2);
            packetLineOut.end();
        } else {
            this.sendPack(NullProgressMonitor.INSTANCE, packetLineOut, this.rawOut, fetchRequest, packStatistics$Accumulator, collection, list, list2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPack(ProgressMonitor progressMonitor, PacketLineOut packetLineOut, OutputStream outputStream, FetchRequest fetchRequest, PackStatistics$Accumulator packStatistics$Accumulator, @Nullable Collection collection, List list, List list2) {
        if (this.wantAll.isEmpty()) {
            this.preUploadHook.onSendPack(this, this.wantIds, this.commonBase);
        } else {
            this.preUploadHook.onSendPack(this, this.wantAll, this.commonBase);
        }
        this.msgOut.flush();
        this.advertised = null;
        this.refs = null;
        PackConfig packConfig = this.packConfig;
        if (packConfig == null) {
            packConfig = new PackConfig(this.db);
        }
        PackWriter packWriter = new PackWriter(packConfig, this.walk.getObjectReader(), packStatistics$Accumulator);
        try {
            Object object;
            Object object2;
            packWriter.setIndexDisabled(true);
            if (fetchRequest.getFilterSpec().isNoOp()) {
                packWriter.setUseCachedPacks(true);
            } else {
                packWriter.setFilterSpec(fetchRequest.getFilterSpec());
                packWriter.setUseCachedPacks(false);
            }
            packWriter.setUseBitmaps(fetchRequest.getDepth() == 0 && fetchRequest.getClientShallowCommits().isEmpty() && fetchRequest.getFilterSpec().getTreeDepthLimit() == -1L);
            packWriter.setClientShallowCommits(fetchRequest.getClientShallowCommits());
            packWriter.setReuseDeltaCommits(true);
            packWriter.setDeltaBaseAsOffset(fetchRequest.getClientCapabilities().contains("ofs-delta"));
            packWriter.setThin(fetchRequest.getClientCapabilities().contains("thin-pack"));
            packWriter.setReuseValidatingObjects(false);
            if (this.commonBase.isEmpty() && this.refs != null) {
                object2 = new HashSet();
                for (Object object3 : this.refs.values()) {
                    if (object3.getPeeledObjectId() != null) {
                        object2.add(object3.getPeeledObjectId());
                        continue;
                    }
                    if (object3.getObjectId() == null || !object3.getName().startsWith("refs/heads/")) continue;
                    object2.add(object3.getObjectId());
                }
                packWriter.setTagTargets((Set)object2);
            }
            object2 = this.walk;
            if (fetchRequest.getDepth() > 0 || fetchRequest.getDeepenSince() != 0 || !list2.isEmpty()) {
                Object object3;
                int n2 = fetchRequest.getDepth() == 0 ? Integer.MAX_VALUE : fetchRequest.getDepth() - 1;
                packWriter.setShallowPack(fetchRequest.getDepth(), list);
                object3 = new DepthWalk$RevWalk(this.walk.getObjectReader(), n2);
                ((DepthWalk$RevWalk)object3).setDeepenSince(fetchRequest.getDeepenSince());
                ((DepthWalk$RevWalk)object3).setDeepenNots(list2);
                ((RevWalk)object3).assumeShallow(fetchRequest.getClientShallowCommits());
                object2 = object3;
            }
            if (this.wantAll.isEmpty()) {
                packWriter.preparePack(progressMonitor, this.wantIds, this.commonBase, fetchRequest.getClientShallowCommits());
            } else {
                this.walk.reset();
                object = ((RevWalk)object2).toObjectWalkWithSameObjects();
                packWriter.preparePack(progressMonitor, (ObjectWalk)object, this.wantAll, this.commonBase, PackWriter.NONE);
                object2 = object;
            }
            if (fetchRequest.getClientCapabilities().contains("include-tag") && collection != null) {
                for (Object object3 : collection) {
                    ObjectId objectId;
                    ObjectId objectId2 = object3.getObjectId();
                    if (objectId2 == null || (!this.wantAll.isEmpty() ? (objectId = ((RevWalk)object2).lookupOrNull(objectId2)) != null && objectId.has(this.WANT) : this.wantIds.contains(objectId2))) continue;
                    if (!object3.isPeeled()) {
                        object3 = this.db.getRefDatabase().peel((Ref)object3);
                    }
                    objectId = object3.getPeeledObjectId();
                    objectId2 = object3.getObjectId();
                    if (objectId == null || objectId2 == null) continue;
                    objectId2 = object3.getObjectId();
                    if (!packWriter.willInclude(objectId) || packWriter.willInclude(objectId2)) continue;
                    RevObject revObject = ((RevWalk)object2).parseAny(objectId2);
                    this.addTagChain(revObject, packWriter);
                    packWriter.addObject(revObject);
                }
            }
            if (packetLineOut.isUsingSideband()) {
                if (fetchRequest instanceof FetchV2Request && this.cachedPackUriProvider != null && !((FetchV2Request)fetchRequest).getPackfileUriProtocols().isEmpty()) {
                    object = (FetchV2Request)fetchRequest;
                    packWriter.setPackfileUriConfig(new PackWriter$PackfileUriConfig(packetLineOut, ((FetchV2Request)object).getPackfileUriProtocols(), this.cachedPackUriProvider));
                } else {
                    packetLineOut.writeString("packfile\n");
                }
            }
            packWriter.enableSearchForReuseTimeout();
            packWriter.writePack(progressMonitor, NullProgressMonitor.INSTANCE, outputStream);
            if (this.msgOut != NullOutputStream.INSTANCE) {
                object = packWriter.getStatistics().getMessage() + '\n';
                this.msgOut.write(Constants.encode((String)object));
                this.msgOut.flush();
            }
        }
        finally {
            this.statistics = packWriter.getStatistics();
            if (this.statistics != null) {
                this.postUploadHook.onPostUpload(this.statistics);
            }
            packWriter.close();
        }
    }

    private static void findSymrefs(RefAdvertiser refAdvertiser, Map map) {
        Ref ref = (Ref)map.get("HEAD");
        if (ref != null && ref.isSymbolic()) {
            refAdvertiser.addSymref("HEAD", ref.getLeaf().getName());
        }
    }

    private void addTagChain(RevObject revObject, PackWriter packWriter) {
        while (4 == revObject.getType()) {
            RevTag revTag = (RevTag)revObject;
            if ((revObject = revTag.getObject()).getType() != 4 || packWriter.willInclude(revObject.getId())) continue;
            this.walk.parseBody(revObject);
            packWriter.addObject(revObject);
        }
    }

    static /* synthetic */ void access$100(UploadPack uploadPack, List list, Collection collection) {
        UploadPack.checkNotAdvertisedWants(uploadPack, list, collection);
    }

    static /* synthetic */ Set access$200(Collection collection) {
        return UploadPack.refIdSet(collection);
    }

    static /* synthetic */ UploadPack$ResponseBufferedOutputStream access$400(UploadPack uploadPack) {
        return uploadPack.rawOut;
    }
}

