/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.References;
import org.eclipse.jgit.util.StringUtils;

public class URIish
implements Serializable {
    private static final String SCHEME_P = "([a-z][a-z0-9+-]+)://";
    private static final String OPT_USER_PWD_P = "(?:([^/:]+)(?::([^\\\\/]+))?@)?";
    private static final String HOST_P = "((?:[^\\\\/:]+)|(?:\\[[0-9a-f:]+\\]))";
    private static final String OPT_PORT_P = "(?::(\\d*))?";
    private static final String USER_HOME_P = "(?:/~(?:[^\\\\/]+))";
    private static final String OPT_DRIVE_LETTER_P = "(?:[A-Za-z]:)?";
    private static final String RELATIVE_PATH_P = "(?:(?:[^\\\\/]+[\\\\/]+)*[^\\\\/]+[\\\\/]*)";
    private static final String PATH_P = "((?:[A-Za-z]:)?[\\\\/]?(?:(?:[^\\\\/]+[\\\\/]+)*[^\\\\/]+[\\\\/]*))";
    private static final long serialVersionUID = 1L;
    private static final Pattern FULL_URI = Pattern.compile("^([a-z][a-z0-9+-]+)://(?:(?:([^/:]+)(?::([^\\\\/]+))?@)?((?:[^\\\\/:]+)|(?:\\[[0-9a-f:]+\\]))(?::(\\d*))?((?:/~(?:[^\\\\/]+))?(?:[\\\\/])|$))?(.+)?$");
    private static final Pattern LOCAL_FILE = Pattern.compile("^([\\\\/]?((?:[A-Za-z]:)?[\\\\/]?(?:(?:[^\\\\/]+[\\\\/]+)*[^\\\\/]+[\\\\/]*)))$");
    private static final Pattern SINGLE_SLASH_FILE_URI = Pattern.compile("^(file):([\\\\/](?![\\\\/])((?:[A-Za-z]:)?[\\\\/]?(?:(?:[^\\\\/]+[\\\\/]+)*[^\\\\/]+[\\\\/]*)))$");
    private static final Pattern RELATIVE_SCP_URI = Pattern.compile("^(?:([^/:]+)(?::([^\\\\/]+))?@)?((?:[^\\\\/:]+)|(?:\\[[0-9a-f:]+\\])):((?:(?:/~(?:[^\\\\/]+))[\\\\/])?(?:(?:[^\\\\/]+[\\\\/]+)*[^\\\\/]+[\\\\/]*))$");
    private static final Pattern ABSOLUTE_SCP_URI = Pattern.compile("^(?:([^/:]+)(?::([^\\\\/]+))?@)?([^\\\\/:]{2,}):([\\\\/](?:(?:[^\\\\/]+[\\\\/]+)*[^\\\\/]+[\\\\/]*))$");
    private String scheme;
    private String path;
    private String rawPath;
    private String user;
    private String pass;
    private int port = -1;
    private String host;
    private static final BitSet reservedChars = new BitSet(127);

    public URIish(String string) {
        if (StringUtils.isEmptyOrNull(string)) {
            throw new URISyntaxException("The uri was empty or null", JGitText.get().cannotParseGitURIish);
        }
        Matcher matcher = SINGLE_SLASH_FILE_URI.matcher(string);
        if (matcher.matches()) {
            this.scheme = matcher.group(1);
            this.rawPath = this.cleanLeadingSlashes(matcher.group(2), this.scheme);
            this.path = URIish.unescape(this.rawPath);
            return;
        }
        matcher = FULL_URI.matcher(string);
        if (matcher.matches()) {
            this.scheme = matcher.group(1);
            this.user = URIish.unescape(matcher.group(2));
            this.pass = URIish.unescape(matcher.group(3));
            String string2 = matcher.group(5);
            if ("file".equals(this.scheme) && "".equals(string2)) {
                this.rawPath = this.cleanLeadingSlashes(this.n2e(matcher.group(4)) + ":" + string2 + this.n2e(matcher.group(6)) + this.n2e(matcher.group(7)), this.scheme);
            } else {
                this.host = URIish.unescape(matcher.group(4));
                if (string2 != null && string2.length() > 0) {
                    this.port = Integer.parseInt(string2);
                }
                this.rawPath = this.cleanLeadingSlashes(this.n2e(matcher.group(6)) + this.n2e(matcher.group(7)), this.scheme);
            }
            this.path = URIish.unescape(this.rawPath);
            return;
        }
        matcher = RELATIVE_SCP_URI.matcher(string);
        if (matcher.matches()) {
            this.user = matcher.group(1);
            this.pass = matcher.group(2);
            this.host = matcher.group(3);
            this.path = this.rawPath = matcher.group(4);
            return;
        }
        matcher = ABSOLUTE_SCP_URI.matcher(string);
        if (matcher.matches()) {
            this.user = matcher.group(1);
            this.pass = matcher.group(2);
            this.host = matcher.group(3);
            this.path = this.rawPath = matcher.group(4);
            return;
        }
        matcher = LOCAL_FILE.matcher(string);
        if (matcher.matches()) {
            this.path = this.rawPath = matcher.group(1);
            return;
        }
        throw new URISyntaxException(string, JGitText.get().cannotParseGitURIish);
    }

    private static int parseHexByte(byte by, byte by2) {
        return RawParseUtils.parseHexInt4(by) << 4 | RawParseUtils.parseHexInt4(by2);
    }

    private static String unescape(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(37) < 0) {
            return string;
        }
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        byte[] byArray2 = new byte[byArray.length];
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte by = byArray[i2];
            if (by == 37) {
                int n3;
                if (i2 + 2 >= byArray.length) {
                    throw new URISyntaxException(string, JGitText.get().cannotParseGitURIish);
                }
                byte by2 = byArray[i2 + 1];
                byte by3 = byArray[i2 + 2];
                try {
                    n3 = URIish.parseHexByte(by2, by3);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    URISyntaxException uRISyntaxException = new URISyntaxException(string, JGitText.get().cannotParseGitURIish);
                    uRISyntaxException.initCause(arrayIndexOutOfBoundsException);
                    throw uRISyntaxException;
                }
                byArray2[n2++] = (byte)n3;
                i2 += 2;
                continue;
            }
            byArray2[n2++] = by;
        }
        return RawParseUtils.decode(byArray2, 0, n2);
    }

    private static String escape(String string, boolean bl2, boolean bl3) {
        byte[] byArray;
        if (string == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        for (byte by : byArray = string.getBytes(StandardCharsets.UTF_8)) {
            int n2 = by & 0xFF;
            if (n2 <= 32 || bl3 && n2 > 127 || n2 == 37 || bl2 && reservedChars.get(n2)) {
                byteArrayOutputStream.write(37);
                byte[] byArray2 = Constants.encodeASCII(String.format("%02x", n2));
                byteArrayOutputStream.write(byArray2[0]);
                byteArrayOutputStream.write(byArray2[1]);
                continue;
            }
            byteArrayOutputStream.write(n2);
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        return RawParseUtils.decode(byArray3, 0, byArray3.length);
    }

    private String n2e(String string) {
        return string == null ? "" : string;
    }

    private String cleanLeadingSlashes(String string, String string2) {
        if (string.length() >= 3 && string.charAt(0) == '/' && string.charAt(2) == ':' && (string.charAt(1) >= 'A' && string.charAt(1) <= 'Z' || string.charAt(1) >= 'a' && string.charAt(1) <= 'z')) {
            return string.substring(1);
        }
        if (string2 != null && string.length() >= 2 && string.charAt(0) == '/' && string.charAt(1) == '~') {
            return string.substring(1);
        }
        return string;
    }

    public URIish(URL uRL) {
        this.scheme = uRL.getProtocol();
        this.path = uRL.getPath();
        this.path = this.cleanLeadingSlashes(this.path, this.scheme);
        try {
            this.rawPath = uRL.toURI().getRawPath();
            this.rawPath = this.cleanLeadingSlashes(this.rawPath, this.scheme);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        String string = uRL.getUserInfo();
        if (string != null) {
            int n2 = string.indexOf(58);
            this.user = n2 < 0 ? string : string.substring(0, n2);
            this.pass = n2 < 0 ? null : string.substring(n2 + 1);
        }
        this.port = uRL.getPort();
        this.host = uRL.getHost();
    }

    public URIish() {
    }

    private URIish(URIish uRIish) {
        this.scheme = uRIish.scheme;
        this.rawPath = uRIish.rawPath;
        this.path = uRIish.path;
        this.user = uRIish.user;
        this.pass = uRIish.pass;
        this.port = uRIish.port;
        this.host = uRIish.host;
    }

    public boolean isRemote() {
        return this.getHost() != null;
    }

    public String getHost() {
        return this.host;
    }

    public URIish setHost(String string) {
        URIish uRIish = new URIish(this);
        uRIish.host = string;
        return uRIish;
    }

    public String getScheme() {
        return this.scheme;
    }

    public URIish setScheme(String string) {
        URIish uRIish = new URIish(this);
        uRIish.scheme = string;
        return uRIish;
    }

    public String getPath() {
        return this.path;
    }

    public String getRawPath() {
        return this.rawPath;
    }

    public URIish setPath(String string) {
        URIish uRIish = new URIish(this);
        uRIish.path = string;
        uRIish.rawPath = string;
        return uRIish;
    }

    public URIish setRawPath(String string) {
        URIish uRIish = new URIish(this);
        uRIish.path = URIish.unescape(string);
        uRIish.rawPath = string;
        return uRIish;
    }

    public String getUser() {
        return this.user;
    }

    public URIish setUser(String string) {
        URIish uRIish = new URIish(this);
        uRIish.user = string;
        return uRIish;
    }

    public String getPass() {
        return this.pass;
    }

    public URIish setPass(String string) {
        URIish uRIish = new URIish(this);
        uRIish.pass = string;
        return uRIish;
    }

    public int getPort() {
        return this.port;
    }

    public URIish setPort(int n2) {
        URIish uRIish = new URIish(this);
        uRIish.port = n2 > 0 ? n2 : -1;
        return uRIish;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.getScheme() != null) {
            n2 = n2 * 31 + this.getScheme().hashCode();
        }
        if (this.getUser() != null) {
            n2 = n2 * 31 + this.getUser().hashCode();
        }
        if (this.getPass() != null) {
            n2 = n2 * 31 + this.getPass().hashCode();
        }
        if (this.getHost() != null) {
            n2 = n2 * 31 + this.getHost().hashCode();
        }
        if (this.getPort() > 0) {
            n2 = n2 * 31 + this.getPort();
        }
        if (this.getPath() != null) {
            n2 = n2 * 31 + this.getPath().hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof URIish)) {
            return false;
        }
        URIish uRIish = (URIish)object;
        if (!URIish.eq(this.getScheme(), uRIish.getScheme())) {
            return false;
        }
        if (!URIish.eq(this.getUser(), uRIish.getUser())) {
            return false;
        }
        if (!URIish.eq(this.getPass(), uRIish.getPass())) {
            return false;
        }
        if (!URIish.eq(this.getHost(), uRIish.getHost())) {
            return false;
        }
        if (this.getPort() != uRIish.getPort()) {
            return false;
        }
        return URIish.eq(this.getPath(), uRIish.getPath());
    }

    private static boolean eq(String string, String string2) {
        if (References.isSameObject(string, string2)) {
            return true;
        }
        if (StringUtils.isEmptyOrNull(string) && StringUtils.isEmptyOrNull(string2)) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public String toPrivateString() {
        return this.format(true, false);
    }

    public String toString() {
        return this.format(false, false);
    }

    private String format(boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getScheme() != null) {
            stringBuilder.append(this.getScheme());
            stringBuilder.append("://");
        }
        if (this.getUser() != null) {
            stringBuilder.append(URIish.escape(this.getUser(), true, bl3));
            if (bl2 && this.getPass() != null) {
                stringBuilder.append(':');
                stringBuilder.append(URIish.escape(this.getPass(), true, bl3));
            }
        }
        if (this.getHost() != null) {
            if (this.getUser() != null && this.getUser().length() > 0) {
                stringBuilder.append('@');
            }
            stringBuilder.append(URIish.escape(this.getHost(), false, bl3));
            if (this.getScheme() != null && this.getPort() > 0) {
                stringBuilder.append(':');
                stringBuilder.append(this.getPort());
            }
        }
        if (this.getPath() != null) {
            if (this.getScheme() != null) {
                if (!this.getPath().startsWith("/") && !this.getPath().isEmpty()) {
                    stringBuilder.append('/');
                }
            } else if (this.getHost() != null) {
                stringBuilder.append(':');
            }
            if (this.getScheme() != null) {
                if (bl3) {
                    stringBuilder.append(URIish.escape(this.getPath(), false, bl3));
                } else {
                    stringBuilder.append(this.getRawPath());
                }
            } else {
                stringBuilder.append(this.getPath());
            }
        }
        return stringBuilder.toString();
    }

    public String toASCIIString() {
        return this.format(false, true);
    }

    public String toPrivateASCIIString() {
        return this.format(true, true);
    }

    public String getHumanishName() {
        String string = this.getPath();
        if ("/".equals(string) || "".equals(string)) {
            string = this.getHost();
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = "file".equals(this.scheme) || LOCAL_FILE.matcher(string).matches() ? string.split("[\\" + File.separatorChar + "/]") : string.split("/+");
        if (stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        String string2 = stringArray[stringArray.length - 1];
        if (".git".equals(string2)) {
            string2 = stringArray[stringArray.length - 2];
        } else if (string2.endsWith(".git")) {
            string2 = string2.substring(0, string2.length() - ".git".length());
        }
        if (("file".equals(this.scheme) || LOCAL_FILE.matcher(string).matches()) && string2.endsWith(".bundle")) {
            string2 = string2.substring(0, string2.length() - ".bundle".length());
        }
        return string2;
    }

    static {
        for (byte by : Constants.encodeASCII("!*'();:@&=+$,/?#[]")) {
            reservedChars.set(by);
        }
    }
}

