/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef$Unpeeled;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.transport.FtpChannel;
import org.eclipse.jgit.transport.FtpChannel$DirEntry;
import org.eclipse.jgit.transport.FtpChannel$FtpException;
import org.eclipse.jgit.transport.TransportSftp;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase$FileStream;

class TransportSftp$SftpObjectDB
extends WalkRemoteObjectDatabase {
    private final String objectsPath;
    private FtpChannel ftp;
    final /* synthetic */ TransportSftp this$0;

    TransportSftp$SftpObjectDB(TransportSftp transportSftp, String string) {
        this.this$0 = transportSftp;
        if (string.startsWith("/~")) {
            string = string.substring(1);
        }
        if (string.startsWith("~/")) {
            string = string.substring(2);
        }
        try {
            this.ftp = transportSftp.newSftp();
            this.ftp.cd(string);
            this.ftp.cd("objects");
            this.objectsPath = this.ftp.pwd();
        }
        catch (FtpChannel$FtpException ftpChannel$FtpException) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotEnterObjectsPath, string, ftpChannel$FtpException.getMessage()), ftpChannel$FtpException);
        }
        catch (IOException iOException) {
            this.close();
            throw new TransportException(transportSftp.uri, iOException.getMessage(), iOException);
        }
    }

    TransportSftp$SftpObjectDB(TransportSftp transportSftp, TransportSftp$SftpObjectDB transportSftp$SftpObjectDB, String string) {
        this.this$0 = transportSftp;
        try {
            this.ftp = transportSftp.newSftp();
            this.ftp.cd(transportSftp$SftpObjectDB.objectsPath);
            this.ftp.cd(string);
            this.objectsPath = this.ftp.pwd();
        }
        catch (FtpChannel$FtpException ftpChannel$FtpException) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotEnterPathFromParent, string, transportSftp$SftpObjectDB.objectsPath, ftpChannel$FtpException.getMessage()), ftpChannel$FtpException);
        }
        catch (IOException iOException) {
            this.close();
            throw new TransportException(transportSftp.uri, iOException.getMessage(), iOException);
        }
    }

    @Override
    URIish getURI() {
        return this.this$0.uri.setPath(this.objectsPath);
    }

    @Override
    Collection getAlternates() {
        try {
            return this.readAlternates("info/alternates");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    WalkRemoteObjectDatabase openAlternate(String string) {
        return new TransportSftp$SftpObjectDB(this.this$0, this, string);
    }

    @Override
    Collection getPackNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Collection collection = this.ftp.ls("pack");
            Set set = collection.stream().map(FtpChannel$DirEntry::getFilename).collect(Collectors.toSet());
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            for (FtpChannel$DirEntry ftpChannel$DirEntry : collection) {
                String string3;
                String string4 = ftpChannel$DirEntry.getFilename();
                if (!string4.startsWith("pack-") || !string4.endsWith(".pack") || !set.contains(string3 = string4.substring(0, string4.length() - 5) + ".idx")) continue;
                hashMap.put(string4, ftpChannel$DirEntry.getModifiedTime());
                arrayList.add(string4);
            }
            Collections.sort(arrayList, (string, string2) -> ((Long)hashMap.get(string2)).compareTo((Long)hashMap.get(string)));
        }
        catch (FtpChannel$FtpException ftpChannel$FtpException) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotListPackPath, this.objectsPath, ftpChannel$FtpException.getMessage()), ftpChannel$FtpException);
        }
        return arrayList;
    }

    @Override
    WalkRemoteObjectDatabase$FileStream open(String string) {
        try {
            return new WalkRemoteObjectDatabase$FileStream(this.ftp.get(string));
        }
        catch (FtpChannel$FtpException ftpChannel$FtpException) {
            if (ftpChannel$FtpException.getStatus() == 2) {
                throw new FileNotFoundException(string);
            }
            throw new TransportException(MessageFormat.format(JGitText.get().cannotGetObjectsPath, this.objectsPath, string, ftpChannel$FtpException.getMessage()), ftpChannel$FtpException);
        }
    }

    @Override
    void deleteFile(String string) {
        try {
            this.ftp.delete(string);
        }
        catch (FtpChannel$FtpException ftpChannel$FtpException) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotDeleteObjectsPath, this.objectsPath, string, ftpChannel$FtpException.getMessage()), ftpChannel$FtpException);
        }
        String string2 = string;
        int n2 = string2.lastIndexOf(47);
        while (n2 > 0) {
            try {
                string2 = string2.substring(0, n2);
                this.ftp.rmdir(string2);
                n2 = string2.lastIndexOf(47);
            }
            catch (IOException iOException) {
                break;
            }
        }
    }

    @Override
    OutputStream writeFile(String string, ProgressMonitor progressMonitor, String string2) {
        IOException iOException = null;
        try {
            return this.ftp.put(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.mkdir_p(string);
        }
        catch (FtpChannel$FtpException ftpChannel$FtpException) {
            if (ftpChannel$FtpException.getStatus() == 2) {
                this.mkdir_p(string);
            }
            iOException = ftpChannel$FtpException;
        }
        if (iOException == null) {
            try {
                return this.ftp.put(string);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        throw new TransportException(MessageFormat.format(JGitText.get().cannotWriteObjectsPath, this.objectsPath, string, iOException.getMessage()), iOException);
    }

    @Override
    void writeFile(String string, byte[] byArray) {
        String string2 = string + ".lock";
        try {
            super.writeFile(string2, byArray);
            try {
                this.ftp.rename(string2, string);
            }
            catch (IOException iOException) {
                throw new TransportException(MessageFormat.format(JGitText.get().cannotWriteObjectsPath, this.objectsPath, string, iOException.getMessage()), iOException);
            }
        }
        catch (IOException iOException) {
            try {
                this.ftp.rm(string2);
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
    }

    private void mkdir_p(String string) {
        int n2 = string.lastIndexOf(47);
        if (n2 <= 0) {
            return;
        }
        string = string.substring(0, n2);
        IOException iOException = null;
        try {
            this.ftp.mkdir(string);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.mkdir_p(string);
        }
        catch (FtpChannel$FtpException ftpChannel$FtpException) {
            if (ftpChannel$FtpException.getStatus() == 2) {
                this.mkdir_p(string);
            }
            iOException = ftpChannel$FtpException;
        }
        if (iOException == null) {
            try {
                this.ftp.mkdir(string);
                return;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        throw new TransportException(MessageFormat.format(JGitText.get().cannotMkdirObjectPath, this.objectsPath, string, iOException.getMessage()), iOException);
    }

    Map readAdvertisedRefs() {
        TreeMap treeMap = new TreeMap();
        this.readPackedRefs(treeMap);
        this.readRef(treeMap, "../HEAD", "HEAD");
        this.readLooseRefs(treeMap, "../refs", "refs/");
        return treeMap;
    }

    private void readLooseRefs(TreeMap treeMap, String string, String string2) {
        Collection collection;
        try {
            collection = this.ftp.ls(string);
        }
        catch (IOException iOException) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotListObjectsPath, this.objectsPath, string, iOException.getMessage()), iOException);
        }
        for (FtpChannel$DirEntry ftpChannel$DirEntry : collection) {
            String string3 = ftpChannel$DirEntry.getFilename();
            if (".".equals(string3) || "..".equals(string3)) continue;
            String string4 = string + "/" + string3;
            if (ftpChannel$DirEntry.isDirectory()) {
                this.readLooseRefs(treeMap, string4, string2 + string3 + "/");
                continue;
            }
            this.readRef(treeMap, string4, string2 + string3);
        }
    }

    private Ref readRef(TreeMap treeMap, String string, String string2) {
        String string3;
        Object object;
        Object object2;
        try {
            object2 = this.openReader(string);
            object = null;
            try {
                string3 = ((BufferedReader)object2).readLine();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((BufferedReader)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((BufferedReader)object2).close();
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotReadObjectsPath, this.objectsPath, string, iOException.getMessage()), iOException);
        }
        if (string3 == null) {
            throw new TransportException(MessageFormat.format(JGitText.get().emptyRef, string2));
        }
        if (string3.startsWith("ref: ")) {
            object2 = string3.substring("ref: ".length());
            object = (Ref)treeMap.get(object2);
            if (object == null) {
                object = this.readRef(treeMap, "../" + (String)object2, (String)object2);
            }
            if (object == null) {
                object = new ObjectIdRef$Unpeeled(Ref$Storage.NEW, (String)object2, null);
            }
            object = new SymbolicRef(string2, (Ref)object);
            treeMap.put(object.getName(), object);
            return object;
        }
        if (ObjectId.isId(string3)) {
            object2 = new ObjectIdRef$Unpeeled(this.loose((Ref)treeMap.get(string2)), string2, ObjectId.fromString(string3));
            treeMap.put(object2.getName(), object2);
            return object2;
        }
        throw new TransportException(MessageFormat.format(JGitText.get().badRef, string2, string3));
    }

    private Ref$Storage loose(Ref ref) {
        if (ref != null && ref.getStorage() == Ref$Storage.PACKED) {
            return Ref$Storage.LOOSE_PACKED;
        }
        return Ref$Storage.LOOSE;
    }

    @Override
    void close() {
        if (this.ftp != null) {
            try {
                if (this.ftp.isConnected()) {
                    this.ftp.disconnect();
                }
            }
            finally {
                this.ftp = null;
            }
        }
    }
}

