/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportProtocol$URIishField;
import org.eclipse.jgit.transport.URIish;

public abstract class TransportProtocol {
    public abstract String getName();

    public Set getSchemes() {
        return Collections.emptySet();
    }

    public Set getRequiredFields() {
        return Collections.unmodifiableSet(EnumSet.of(TransportProtocol$URIishField.PATH));
    }

    public Set getOptionalFields() {
        return Collections.emptySet();
    }

    public int getDefaultPort() {
        return -1;
    }

    public boolean canHandle(URIish uRIish) {
        return this.canHandle(uRIish, null, null);
    }

    public boolean canHandle(URIish uRIish, Repository repository, String string) {
        if (!this.getSchemes().isEmpty() && !this.getSchemes().contains(uRIish.getScheme())) {
            return false;
        }
        block7: for (TransportProtocol$URIishField transportProtocol$URIishField : this.getRequiredFields()) {
            switch (transportProtocol$URIishField) {
                case USER: {
                    if (uRIish.getUser() != null && uRIish.getUser().length() != 0) continue block7;
                    return false;
                }
                case PASS: {
                    if (uRIish.getPass() != null && uRIish.getPass().length() != 0) continue block7;
                    return false;
                }
                case HOST: {
                    if (uRIish.getHost() != null && uRIish.getHost().length() != 0) continue block7;
                    return false;
                }
                case PORT: {
                    if (uRIish.getPort() > 0) continue block7;
                    return false;
                }
                case PATH: {
                    if (uRIish.getPath() != null && uRIish.getPath().length() != 0) continue block7;
                    return false;
                }
            }
            return false;
        }
        EnumSet enumSet = EnumSet.copyOf(this.getRequiredFields());
        enumSet.addAll(this.getOptionalFields());
        if (uRIish.getUser() != null && !enumSet.contains((Object)TransportProtocol$URIishField.USER)) {
            return false;
        }
        if (uRIish.getPass() != null && !enumSet.contains((Object)TransportProtocol$URIishField.PASS)) {
            return false;
        }
        if (uRIish.getHost() != null && !enumSet.contains((Object)TransportProtocol$URIishField.HOST)) {
            return false;
        }
        if (uRIish.getPort() > 0 && !enumSet.contains((Object)TransportProtocol$URIishField.PORT)) {
            return false;
        }
        return uRIish.getPath() == null || enumSet.contains((Object)TransportProtocol$URIishField.PATH);
    }

    public abstract Transport open(URIish var1, Repository var2, String var3);

    public Transport open(URIish uRIish) {
        throw new NotSupportedException(JGitText.get().transportNeedsRepository);
    }
}

