/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.InternalFetchConnection;
import org.eclipse.jgit.transport.InternalPushConnection;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.TransferConfig$ProtocolVersion;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportLocal$1;
import org.eclipse.jgit.transport.TransportLocal$ForkLocalFetchConnection;
import org.eclipse.jgit.transport.TransportLocal$ForkLocalPushConnection;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;
import org.eclipse.jgit.util.FS;

class TransportLocal
extends Transport
implements PackTransport {
    static final TransportProtocol PROTO_LOCAL = new TransportLocal$1();
    private final File remoteGitDir;

    TransportLocal(Repository repository, URIish uRIish, File file) {
        super(repository, uRIish);
        this.remoteGitDir = file;
    }

    TransportLocal(URIish uRIish, File file) {
        super(uRIish);
        this.remoteGitDir = file;
    }

    UploadPack createUploadPack(Repository repository) {
        return new UploadPack(repository);
    }

    ReceivePack createReceivePack(Repository repository) {
        return new ReceivePack(repository);
    }

    private Repository openRepo() {
        try {
            return ((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setFS(this.local != null ? this.local.getFS() : FS.DETECTED)).setGitDir(this.remoteGitDir)).build();
        }
        catch (IOException iOException) {
            TransportException transportException = new TransportException(this.uri, JGitText.get().notAGitDirectory);
            transportException.initCause(iOException);
            throw transportException;
        }
    }

    @Override
    public FetchConnection openFetch() {
        return this.openFetch(Collections.emptyList(), new String[0]);
    }

    @Override
    public FetchConnection openFetch(Collection collection, String ... stringArray) {
        String string = this.getOptionUploadPack();
        if (!"git-upload-pack".equals(string) && !"git upload-pack".equals(string)) {
            return new TransportLocal$ForkLocalFetchConnection(this, collection, stringArray);
        }
        UploadPackFactory uploadPackFactory = (void_, repository) -> this.createUploadPack(repository);
        return new InternalFetchConnection(this, uploadPackFactory, null, this.openRepo());
    }

    @Override
    public PushConnection openPush() {
        String string = this.getOptionReceivePack();
        if (!"git-receive-pack".equals(string) && !"git receive-pack".equals(string)) {
            return new TransportLocal$ForkLocalPushConnection(this);
        }
        ReceivePackFactory receivePackFactory = (void_, repository) -> this.createReceivePack(repository);
        return new InternalPushConnection(this, receivePackFactory, null, this.openRepo());
    }

    @Override
    public void close() {
    }

    protected Process spawn(String string) {
        return this.spawn(string, null);
    }

    private Process spawn(String string, TransferConfig$ProtocolVersion transferConfig$ProtocolVersion) {
        try {
            String[] stringArray = new String[]{"."};
            ProcessBuilder processBuilder = this.local.getFS().runInShell(string, stringArray);
            processBuilder.directory(this.remoteGitDir);
            Map<String, String> map = processBuilder.environment();
            map.remove("GIT_ALTERNATE_OBJECT_DIRECTORIES");
            map.remove("GIT_CONFIG");
            map.remove("GIT_CONFIG_PARAMETERS");
            map.remove("GIT_DIR");
            map.remove("GIT_COMMON_DIR");
            map.remove("GIT_WORK_TREE");
            map.remove("GIT_GRAFT_FILE");
            map.remove("GIT_INDEX_FILE");
            map.remove("GIT_NO_REPLACE_OBJECTS");
            if (TransferConfig$ProtocolVersion.V2.equals((Object)transferConfig$ProtocolVersion)) {
                map.put("GIT_PROTOCOL", "version=2");
            }
            return processBuilder.start();
        }
        catch (IOException iOException) {
            throw new TransportException(this.uri, iOException.getMessage(), iOException);
        }
    }

    static /* synthetic */ Process access$000(TransportLocal transportLocal, String string, TransferConfig$ProtocolVersion transferConfig$ProtocolVersion) {
        return transportLocal.spawn(string, transferConfig$ProtocolVersion);
    }
}

