/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache$FileKey;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportBundleFile;
import org.eclipse.jgit.transport.TransportLocal;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;

final class TransportLocal$1
extends TransportProtocol {
    TransportLocal$1() {
    }

    @Override
    public String getName() {
        return JGitText.get().transportProtoLocal;
    }

    @Override
    public Set getSchemes() {
        return Collections.singleton("file");
    }

    @Override
    public boolean canHandle(URIish uRIish, Repository repository, String string) {
        return uRIish.getPath() != null && uRIish.getPort() <= 0 && uRIish.getUser() == null && uRIish.getPass() == null && uRIish.getHost() == null && (uRIish.getScheme() == null || this.getSchemes().contains(uRIish.getScheme()));
    }

    @Override
    public Transport open(URIish uRIish, Repository repository, String string) {
        File file = repository.isBare() ? repository.getDirectory() : repository.getWorkTree();
        File file2 = repository.getFS().resolve(file, uRIish.getPath());
        if (file2.isFile()) {
            return new TransportBundleFile(repository, uRIish, file2);
        }
        File file3 = RepositoryCache$FileKey.resolve(file2, repository.getFS());
        if (file3 == null) {
            throw new NoRemoteRepositoryException(uRIish, JGitText.get().notFound);
        }
        return new TransportLocal(repository, uRIish, file3);
    }

    @Override
    public Transport open(URIish uRIish) {
        File file = FS.DETECTED.resolve(new File("."), uRIish.getPath());
        if (file.isFile()) {
            return new TransportBundleFile(uRIish, file);
        }
        File file2 = RepositoryCache$FileKey.resolve(file, FS.DETECTED);
        if (file2 == null) {
            throw new NoRemoteRepositoryException(uRIish, JGitText.get().notFound);
        }
        return new TransportLocal(uRIish, file2);
    }
}

