/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.security.GeneralSecurityException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLHandshakeException;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.transport.http.NetscapeCookieFile;
import org.eclipse.jgit.internal.transport.http.NetscapeCookieFileCache;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef$Unpeeled;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.transport.BaseConnection;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialItem$InformationalMessage;
import org.eclipse.jgit.transport.CredentialItem$YesNoType;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.HttpAuthMethod;
import org.eclipse.jgit.transport.HttpAuthMethod$Type;
import org.eclipse.jgit.transport.HttpConfig;
import org.eclipse.jgit.transport.HttpConfig$HttpRedirectMode;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.TransferConfig$ProtocolVersion;
import org.eclipse.jgit.transport.TransportHttp$1;
import org.eclipse.jgit.transport.TransportHttp$2;
import org.eclipse.jgit.transport.TransportHttp$AcceptEncoding;
import org.eclipse.jgit.transport.TransportHttp$CredentialItems;
import org.eclipse.jgit.transport.TransportHttp$HttpObjectDB;
import org.eclipse.jgit.transport.TransportHttp$SmartHttpFetchConnection;
import org.eclipse.jgit.transport.TransportHttp$SmartHttpPushConnection;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UserAgent;
import org.eclipse.jgit.transport.WalkFetchConnection;
import org.eclipse.jgit.transport.WalkTransport;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.transport.http.HttpConnectionFactory;
import org.eclipse.jgit.transport.http.HttpConnectionFactory2;
import org.eclipse.jgit.transport.http.HttpConnectionFactory2$GitSession;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.HttpSupport;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportHttp
extends HttpTransport
implements PackTransport,
WalkTransport {
    private static final Logger LOG = LoggerFactory.getLogger(TransportHttp.class);
    private static final String SVC_UPLOAD_PACK = "git-upload-pack";
    private static final String SVC_RECEIVE_PACK = "git-receive-pack";
    private static final byte[] VERSION = "version".getBytes(StandardCharsets.US_ASCII);
    static final TransportProtocol PROTO_HTTP = new TransportHttp$1();
    static final TransportProtocol PROTO_FTP = new TransportHttp$2();
    private URIish currentUri;
    private URL baseUrl;
    private URL objectsUrl;
    private final HttpConfig http;
    private final ProxySelector proxySelector;
    private boolean useSmartHttp = true;
    private HttpAuthMethod authMethod = HttpAuthMethod$Type.NONE.method(null);
    private Map headers;
    private boolean sslVerify;
    private boolean sslFailure = false;
    private HttpConnectionFactory factory;
    private HttpConnectionFactory2$GitSession gitSession;
    private boolean factoryUsed;
    private final NetscapeCookieFile cookieFile;
    private final Set relevantCookies;

    TransportHttp(Repository repository, URIish uRIish) {
        super(repository, uRIish);
        this.setURI(uRIish);
        this.http = new HttpConfig(repository.getConfig(), uRIish);
        this.proxySelector = ProxySelector.getDefault();
        this.sslVerify = this.http.isSslVerify();
        this.cookieFile = this.getCookieFileFromConfig(this.http);
        this.relevantCookies = TransportHttp.filterCookies(this.cookieFile, this.baseUrl);
        this.factory = HttpTransport.getConnectionFactory();
    }

    private URL toURL(URIish uRIish) {
        String string = uRIish.toString();
        if (!string.endsWith("/")) {
            string = string + '/';
        }
        return new URL(string);
    }

    protected void setURI(URIish uRIish) {
        try {
            this.currentUri = uRIish;
            this.baseUrl = this.toURL(uRIish);
            this.objectsUrl = new URL(this.baseUrl, "objects/");
        }
        catch (MalformedURLException malformedURLException) {
            throw new NotSupportedException(MessageFormat.format(JGitText.get().invalidURL, uRIish), malformedURLException);
        }
    }

    TransportHttp(URIish uRIish) {
        super(uRIish);
        this.setURI(uRIish);
        this.http = new HttpConfig(uRIish);
        this.proxySelector = ProxySelector.getDefault();
        this.sslVerify = this.http.isSslVerify();
        this.cookieFile = this.getCookieFileFromConfig(this.http);
        this.relevantCookies = TransportHttp.filterCookies(this.cookieFile, this.baseUrl);
        this.factory = HttpTransport.getConnectionFactory();
    }

    public void setUseSmartHttp(boolean bl2) {
        this.useSmartHttp = bl2;
    }

    private FetchConnection getConnection(HttpConnection httpConnection, InputStream inputStream, String string, Collection collection, String ... stringArray) {
        BaseConnection baseConnection;
        if (this.isSmartHttp(httpConnection, string)) {
            InputStream inputStream2 = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
            this.readSmartHeaders(inputStream2, string);
            baseConnection = new TransportHttp$SmartHttpFetchConnection(this, inputStream2, collection, stringArray);
        } else {
            baseConnection = this.newDumbConnection(inputStream);
        }
        baseConnection.setPeerUserAgent(httpConnection.getHeaderField("Server"));
        return baseConnection;
    }

    public void setHttpConnectionFactory(@NonNull HttpConnectionFactory httpConnectionFactory) {
        if (this.factoryUsed) {
            throw new IllegalStateException(JGitText.get().httpFactoryInUse);
        }
        this.factory = httpConnectionFactory;
    }

    @NonNull
    public HttpConnectionFactory getHttpConnectionFactory() {
        return this.factory;
    }

    public void setPreemptiveBasicAuthentication(String string, String string2) {
        if (this.factoryUsed) {
            throw new IllegalStateException(JGitText.get().httpPreAuthTooLate);
        }
        if (StringUtils.isEmptyOrNull(string) || StringUtils.isEmptyOrNull(string2)) {
            this.authMethod = this.authFromUri(this.currentUri);
        } else {
            HttpAuthMethod httpAuthMethod = HttpAuthMethod$Type.BASIC.method(null);
            httpAuthMethod.authorize(string, string2);
            this.authMethod = httpAuthMethod;
        }
    }

    @Override
    public FetchConnection openFetch() {
        return this.openFetch(Collections.emptyList(), new String[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FetchConnection openFetch(Collection collection, String ... stringArray) {
        String string = SVC_UPLOAD_PACK;
        try {
            TransferConfig$ProtocolVersion transferConfig$ProtocolVersion = this.protocol;
            if (transferConfig$ProtocolVersion == null) {
                transferConfig$ProtocolVersion = TransferConfig$ProtocolVersion.V2;
            }
            HttpConnection httpConnection = this.connect(SVC_UPLOAD_PACK, transferConfig$ProtocolVersion);
            try (InputStream inputStream = this.openInputStream(httpConnection);){
                FetchConnection fetchConnection = this.getConnection(httpConnection, inputStream, SVC_UPLOAD_PACK, collection, stringArray);
                return fetchConnection;
            }
        }
        catch (NotSupportedException | TransportException iOException) {
            throw iOException;
        }
        catch (IOException iOException) {
            throw new TransportException(this.uri, JGitText.get().errorReadingInfoRefs, iOException);
        }
    }

    /*
     * Unable to fully structure code
     */
    private WalkFetchConnection newDumbConnection(InputStream var1_1) {
        block32: {
            var2_2 = new TransportHttp$HttpObjectDB(this, this.objectsUrl);
            var4_3 = this.toBufferedReader(var1_1);
            var5_4 = null;
            try {
                var3_6 = var2_2.readAdvertisedImpl((BufferedReader)var4_3);
            }
            catch (Throwable var6_8) {
                var5_4 = var6_8;
                throw var6_8;
            }
            finally {
                if (var4_3 != null) {
                    if (var5_4 != null) {
                        try {
                            var4_3.close();
                        }
                        catch (Throwable var6_7) {
                            var5_4.addSuppressed(var6_7);
                        }
                    } else {
                        var4_3.close();
                    }
                }
            }
            if (var3_6.containsKey("HEAD")) break block32;
            var4_3 = this.httpOpen("GET", new URL(this.baseUrl, "HEAD"), TransportHttp$AcceptEncoding.GZIP);
            var5_5 = HttpSupport.response((HttpConnection)var4_3);
            switch (var5_5) {
                case 200: {
                    var6_9 = this.toBufferedReader(this.openInputStream((HttpConnection)var4_3));
                    var7_11 = null;
                    var8_13 = var6_9.readLine();
                    if (var8_13 != null && var8_13.startsWith("ref: ")) {
                        var9_16 = var8_13.substring("ref: ".length());
                        var10_18 = (Ref)var3_6.get(var9_16);
                        if (var10_18 == null) {
                            var10_18 = new ObjectIdRef$Unpeeled(Ref$Storage.NEW, var9_16, null);
                        }
                        var10_18 = new SymbolicRef("HEAD", var10_18);
                        var3_6.put(var10_18.getName(), var10_18);
                    } else if (var8_13 != null && ObjectId.isId(var8_13)) {
                        var9_17 = new ObjectIdRef$Unpeeled(Ref$Storage.NETWORK, "HEAD", ObjectId.fromString(var8_13));
                        var3_6.put(var9_17.getName(), var9_17);
                    }
                    if (var6_9 == null) break;
                    if (var7_11 == null) ** GOTO lbl52
                    try {
                        var6_9.close();
                    }
                    catch (Throwable var8_14) {
                        var7_11.addSuppressed(var8_14);
                    }
                    break;
lbl52:
                    // 1 sources

                    var6_9.close();
                    break;
                    catch (Throwable var8_15) {
                        try {
                            var7_11 = var8_15;
                            throw var8_15;
                        }
                        catch (Throwable var11_19) {
                            if (var6_9 != null) {
                                if (var7_11 != null) {
                                    try {
                                        var6_9.close();
                                    }
                                    catch (Throwable var12_20) {
                                        var7_11.addSuppressed(var12_20);
                                    }
                                } else {
                                    var6_9.close();
                                }
                            }
                            throw var11_19;
                        }
                    }
                }
                case 404: {
                    break;
                }
                default: {
                    throw new TransportException(this.uri, MessageFormat.format(JGitText.get().cannotReadHEAD, new Object[]{var5_5, var4_3.getResponseMessage()}));
                }
            }
        }
        var4_3 = new WalkFetchConnection(this, var2_2);
        var4_3.available(var3_6);
        return var4_3;
    }

    private BufferedReader toBufferedReader(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PushConnection openPush() {
        String string = SVC_RECEIVE_PACK;
        try {
            HttpConnection httpConnection = this.connect(SVC_RECEIVE_PACK);
            try (InputStream inputStream = this.openInputStream(httpConnection);){
                if (this.isSmartHttp(httpConnection, SVC_RECEIVE_PACK)) {
                    PushConnection pushConnection = this.smartPush(SVC_RECEIVE_PACK, httpConnection, inputStream);
                    return pushConnection;
                }
                if (!this.useSmartHttp) {
                    String string2 = JGitText.get().smartHTTPPushDisabled;
                    throw new NotSupportedException(string2);
                }
                String string3 = JGitText.get().remoteDoesNotSupportSmartHTTPPush;
                throw new NotSupportedException(string3);
            }
        }
        catch (NotSupportedException | TransportException iOException) {
            throw iOException;
        }
        catch (IOException iOException) {
            throw new TransportException(this.uri, JGitText.get().errorReadingInfoRefs, iOException);
        }
    }

    private PushConnection smartPush(String string, HttpConnection httpConnection, InputStream inputStream) {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        this.readSmartHeaders(bufferedInputStream, string);
        TransportHttp$SmartHttpPushConnection transportHttp$SmartHttpPushConnection = new TransportHttp$SmartHttpPushConnection(this, bufferedInputStream);
        transportHttp$SmartHttpPushConnection.setPeerUserAgent(httpConnection.getHeaderField("Server"));
        return transportHttp$SmartHttpPushConnection;
    }

    @Override
    public void close() {
        if (this.gitSession != null) {
            this.gitSession.close();
            this.gitSession = null;
        }
    }

    public void setAdditionalHeaders(Map map) {
        this.headers = map;
    }

    private NoRemoteRepositoryException createNotFoundException(URIish uRIish, URL uRL, String string) {
        String string2 = string != null && !string.isEmpty() ? MessageFormat.format(JGitText.get().uriNotFoundWithMessage, uRL, string) : MessageFormat.format(JGitText.get().uriNotFound, uRL);
        return new NoRemoteRepositoryException(uRIish, string2);
    }

    private HttpAuthMethod authFromUri(URIish uRIish) {
        String string = uRIish.getUser();
        String string2 = uRIish.getPass();
        if (string != null && string2 != null) {
            try {
                string = URLDecoder.decode(string.replace("+", "%2B"), StandardCharsets.UTF_8.name());
                string2 = URLDecoder.decode(string2.replace("+", "%2B"), StandardCharsets.UTF_8.name());
                HttpAuthMethod httpAuthMethod = HttpAuthMethod$Type.BASIC.method(null);
                httpAuthMethod.authorize(string, string2);
                return httpAuthMethod;
            }
            catch (UnsupportedEncodingException | IllegalArgumentException exception) {
                LOG.warn(JGitText.get().httpUserInfoDecodeError, (Object)uRIish);
            }
        }
        return HttpAuthMethod$Type.NONE.method(null);
    }

    private HttpConnection connect(String string) {
        return this.connect(string, null);
    }

    private HttpConnection connect(String string, TransferConfig$ProtocolVersion transferConfig$ProtocolVersion) {
        URL uRL = this.getServiceURL(string);
        if (HttpAuthMethod$Type.NONE.equals((Object)this.authMethod.getType())) {
            this.authMethod = this.authFromUri(this.currentUri);
        }
        int n2 = 1;
        int n3 = 0;
        HashSet<HttpAuthMethod$Type> hashSet = null;
        while (true) {
            try {
                int n4;
                HttpConnection httpConnection;
                block14: while (true) {
                    httpConnection = this.httpOpen("GET", uRL, TransportHttp$AcceptEncoding.GZIP);
                    if (this.useSmartHttp) {
                        String string2 = "application/x-" + string + "-advertisement";
                        httpConnection.setRequestProperty("Accept", string2 + ", */*");
                    } else {
                        httpConnection.setRequestProperty("Accept", "*/*");
                    }
                    if (TransferConfig$ProtocolVersion.V2.equals((Object)transferConfig$ProtocolVersion)) {
                        httpConnection.setRequestProperty("Git-Protocol", "version=2");
                    }
                    n4 = HttpSupport.response(httpConnection);
                    this.processResponseCookies(httpConnection);
                    switch (n4) {
                        case 200: {
                            if (this.authMethod.getType() == HttpAuthMethod$Type.NONE && httpConnection.getHeaderField("WWW-Authenticate") != null) {
                                this.authMethod = HttpAuthMethod.scanResponse(httpConnection, hashSet);
                            }
                            return httpConnection;
                        }
                        case 404: {
                            throw this.createNotFoundException(this.uri, uRL, httpConnection.getResponseMessage());
                        }
                        case 401: {
                            this.authMethod = HttpAuthMethod.scanResponse(httpConnection, hashSet);
                            if (this.authMethod.getType() == HttpAuthMethod$Type.NONE) {
                                throw new TransportException(this.uri, MessageFormat.format(JGitText.get().authenticationNotSupported, this.uri));
                            }
                            CredentialsProvider credentialsProvider = this.getCredentialsProvider();
                            if (credentialsProvider == null) {
                                throw new TransportException(this.uri, JGitText.get().noCredentialsProvider);
                            }
                            if (n2 > 1) {
                                credentialsProvider.reset(this.currentUri);
                            }
                            if (3 < n2 || !this.authMethod.authorize(this.currentUri, credentialsProvider)) {
                                throw new TransportException(this.uri, JGitText.get().notAuthorized);
                            }
                            ++n2;
                            continue block14;
                        }
                        case 403: {
                            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().serviceNotPermitted, this.baseUrl, string));
                        }
                        case 301: 
                        case 302: 
                        case 303: 
                        case 307: 
                        case 308: {
                            if (this.http.getFollowRedirects() == HttpConfig$HttpRedirectMode.FALSE) {
                                throw new TransportException(this.uri, MessageFormat.format(JGitText.get().redirectsOff, n4));
                            }
                            URIish uRIish = this.redirect(uRL, httpConnection.getHeaderField("Location"), "info/refs", n3++);
                            this.setURI(uRIish);
                            uRL = this.getServiceURL(string);
                            n2 = 1;
                            continue block14;
                        }
                    }
                    break;
                }
                String string3 = n4 + " " + httpConnection.getResponseMessage();
                throw new TransportException(this.uri, string3);
            }
            catch (NotSupportedException | TransportException iOException) {
                throw iOException;
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new TransportException(this.uri, MessageFormat.format(JGitText.get().connectionTimeOut, uRL.getHost()), interruptedIOException);
            }
            catch (SocketException socketException) {
                throw new TransportException(this.uri, JGitText.get().connectionFailed, socketException);
            }
            catch (SSLHandshakeException sSLHandshakeException) {
                this.handleSslFailure(sSLHandshakeException);
                continue;
            }
            catch (IOException iOException) {
                if (this.authMethod.getType() != HttpAuthMethod$Type.NONE) {
                    if (hashSet == null) {
                        hashSet = new HashSet<HttpAuthMethod$Type>();
                    }
                    hashSet.add(this.authMethod.getType());
                    this.authMethod = HttpAuthMethod$Type.NONE.method(null);
                    n2 = 1;
                    continue;
                }
                throw new TransportException(this.uri, MessageFormat.format(JGitText.get().cannotOpenService, string), iOException);
            }
            break;
        }
    }

    void processResponseCookies(HttpConnection httpConnection) {
        if (this.cookieFile != null && this.http.getSaveCookies()) {
            LinkedList linkedList = new LinkedList();
            List list = httpConnection.getHeaderFields("Set-Cookie");
            if (!list.isEmpty()) {
                linkedList.addAll(this.extractCookies("Set-Cookie", list));
            }
            if (!(list = httpConnection.getHeaderFields("Set-Cookie2")).isEmpty()) {
                linkedList.addAll(this.extractCookies("Set-Cookie2", list));
            }
            if (!linkedList.isEmpty()) {
                try {
                    Set set = this.cookieFile.getCookies(false);
                    set.addAll(linkedList);
                    this.cookieFile.write(this.baseUrl);
                    this.relevantCookies.addAll(linkedList);
                }
                catch (IOException | IllegalArgumentException | InterruptedException exception) {
                    LOG.warn(MessageFormat.format(JGitText.get().couldNotPersistCookies, this.cookieFile.getPath()), (Throwable)exception);
                }
            }
        }
    }

    private List extractCookies(String string, List list) {
        LinkedList<HttpCookie> linkedList = new LinkedList<HttpCookie>();
        for (String object : list) {
            linkedList.addAll(HttpCookie.parse(string + ':' + object));
        }
        for (HttpCookie httpCookie : linkedList) {
            String string2 = httpCookie.getDomain();
            if (string2 == null || !string2.startsWith(".")) continue;
            httpCookie.setDomain(string2.substring(1));
        }
        return linkedList;
    }

    private void handleSslFailure(Throwable throwable) {
        if (this.sslFailure || !this.trustInsecureSslConnection(throwable.getCause())) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().sslFailureExceptionMessage, this.currentUri.setPass(null)), throwable);
        }
        this.sslFailure = true;
    }

    private boolean trustInsecureSslConnection(Throwable throwable) {
        boolean bl2;
        TransportHttp$CredentialItems transportHttp$CredentialItems;
        CredentialItem[] credentialItemArray;
        CredentialsProvider credentialsProvider;
        if ((throwable instanceof CertificateException || throwable instanceof CertPathBuilderException || throwable instanceof CertPathValidatorException) && (credentialsProvider = this.getCredentialsProvider()) != null && credentialsProvider.supports(credentialItemArray = (transportHttp$CredentialItems = this.constructSslTrustItems(throwable)).items()) && (bl2 = credentialsProvider.get(this.uri, credentialItemArray))) {
            boolean bl3 = transportHttp$CredentialItems.now.getValue();
            boolean bl4 = transportHttp$CredentialItems.forRepo != null && transportHttp$CredentialItems.forRepo.getValue();
            boolean bl5 = transportHttp$CredentialItems.always.getValue();
            if (bl3 || bl4 || bl5) {
                this.sslVerify = false;
                if (bl5) {
                    this.updateSslVerifyUser(false);
                } else if (bl4) {
                    this.updateSslVerify(this.local.getConfig(), false);
                }
                return true;
            }
        }
        return false;
    }

    private TransportHttp$CredentialItems constructSslTrustItems(Throwable throwable) {
        TransportHttp$CredentialItems transportHttp$CredentialItems = new TransportHttp$CredentialItems(null);
        String string = MessageFormat.format(JGitText.get().sslFailureInfo, this.currentUri.setPass(null));
        String string2 = throwable.getLocalizedMessage();
        if (string2 == null) {
            string2 = throwable.toString();
        }
        string2 = MessageFormat.format(JGitText.get().sslFailureCause, string2);
        transportHttp$CredentialItems.message = new CredentialItem$InformationalMessage(string + '\n' + string2 + '\n' + JGitText.get().sslFailureTrustExplanation);
        transportHttp$CredentialItems.now = new CredentialItem$YesNoType(JGitText.get().sslTrustNow);
        if (this.local != null) {
            transportHttp$CredentialItems.forRepo = new CredentialItem$YesNoType(MessageFormat.format(JGitText.get().sslTrustForRepo, this.local.getDirectory()));
        }
        transportHttp$CredentialItems.always = new CredentialItem$YesNoType(JGitText.get().sslTrustAlways);
        return transportHttp$CredentialItems;
    }

    private void updateSslVerify(StoredConfig storedConfig, boolean bl2) {
        String string = this.uri.getScheme() + "://" + this.uri.getHost();
        int n2 = this.uri.getPort();
        if (n2 > 0) {
            string = string + ":" + n2;
        }
        storedConfig.setBoolean("http", string, "sslVerify", bl2);
        try {
            storedConfig.save();
        }
        catch (IOException iOException) {
            LOG.error(JGitText.get().sslVerifyCannotSave, (Throwable)iOException);
        }
    }

    private void updateSslVerifyUser(boolean bl2) {
        StoredConfig storedConfig = null;
        try {
            storedConfig = SystemReader.getInstance().getUserConfig();
            this.updateSslVerify(storedConfig, bl2);
        }
        catch (IOException | ConfigInvalidException exception) {
            LOG.error(exception.getMessage(), (Throwable)exception);
        }
    }

    private URIish redirect(URL uRL, String string, String string2, int n2) {
        if (string == null || string.isEmpty()) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().redirectLocationMissing, this.baseUrl));
        }
        if (n2 >= this.http.getMaxRedirects()) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().redirectLimitExceeded, this.http.getMaxRedirects(), this.baseUrl, string));
        }
        try {
            URI uRI = new URI(string);
            boolean bl2 = !StringUtils.isEmptyOrNull(uRI.getUserInfo());
            String string3 = uRL.getHost();
            uRI = uRL.toURI().resolve(uRI);
            bl2 = bl2 || !string3.equals(uRI.getHost());
            String string4 = uRI.toASCIIString();
            if (!this.isValidRedirect(this.baseUrl, string4, string2)) {
                throw new TransportException(this.uri, MessageFormat.format(JGitText.get().redirectBlocked, this.baseUrl, string4));
            }
            string4 = string4.substring(0, string4.indexOf(string2));
            URIish uRIish = new URIish(string4);
            if (bl2) {
                this.authMethod = HttpAuthMethod$Type.NONE.method(null);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info(MessageFormat.format(JGitText.get().redirectHttp, this.uri.setPass(null), n2, this.baseUrl, uRIish));
            }
            return uRIish;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().invalidRedirectLocation, this.baseUrl, string), uRISyntaxException);
        }
    }

    private boolean isValidRedirect(URL uRL, String string, String string2) {
        String string3 = uRL.getProtocol().toLowerCase(Locale.ROOT);
        int n2 = string.indexOf("://");
        if (n2 < 0) {
            return false;
        }
        String string4 = string.substring(0, n2).toLowerCase(Locale.ROOT);
        if (!string3.equals(string4) && !"https".equals(string4)) {
            return false;
        }
        return string.contains(string2);
    }

    private URL getServiceURL(String string) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.baseUrl);
            if (stringBuilder.charAt(stringBuilder.length() - 1) != '/') {
                stringBuilder.append('/');
            }
            stringBuilder.append("info/refs");
            if (this.useSmartHttp) {
                stringBuilder.append(stringBuilder.indexOf("?") < 0 ? (char)'?' : '&');
                stringBuilder.append("service=");
                stringBuilder.append(string);
            }
            return new URL(stringBuilder.toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new NotSupportedException(MessageFormat.format(JGitText.get().invalidURL, this.uri), malformedURLException);
        }
    }

    protected HttpConnection httpOpen(String string, URL uRL, TransportHttp$AcceptEncoding transportHttp$AcceptEncoding) {
        if (string == null || uRL == null || transportHttp$AcceptEncoding == null) {
            throw new NullPointerException();
        }
        Proxy proxy = HttpSupport.proxyFor(this.proxySelector, uRL);
        this.factoryUsed = true;
        HttpConnection httpConnection = this.factory.create(uRL, proxy);
        if (this.gitSession == null && this.factory instanceof HttpConnectionFactory2) {
            this.gitSession = ((HttpConnectionFactory2)this.factory).newSession();
        }
        if (this.gitSession != null) {
            try {
                this.gitSession.configure(httpConnection, this.sslVerify);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IOException(generalSecurityException.getMessage(), generalSecurityException);
            }
        } else if (!this.sslVerify && "https".equals(uRL.getProtocol())) {
            HttpSupport.disableSslVerify(httpConnection);
        }
        httpConnection.setInstanceFollowRedirects(false);
        httpConnection.setRequestMethod(string);
        httpConnection.setUseCaches(false);
        if (transportHttp$AcceptEncoding == TransportHttp$AcceptEncoding.GZIP) {
            httpConnection.setRequestProperty("Accept-Encoding", "gzip");
        }
        httpConnection.setRequestProperty("Pragma", "no-cache");
        if (this.http.getUserAgent() != null) {
            httpConnection.setRequestProperty("User-Agent", this.http.getUserAgent());
        } else if (UserAgent.get() != null) {
            httpConnection.setRequestProperty("User-Agent", UserAgent.get());
        }
        int n2 = this.getTimeout();
        if (n2 != -1) {
            int n3 = n2 * 1000;
            httpConnection.setConnectTimeout(n3);
            httpConnection.setReadTimeout(n3);
        }
        TransportHttp.addHeaders(httpConnection, this.http.getExtraHeaders());
        if (!this.relevantCookies.isEmpty()) {
            this.setCookieHeader(httpConnection);
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            for (Map.Entry entry : this.headers.entrySet()) {
                httpConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.authMethod.configureRequest(httpConnection);
        return httpConnection;
    }

    static void addHeaders(HttpConnection httpConnection, List list) {
        for (String string : list) {
            int n2 = string.indexOf(58);
            String string2 = null;
            if (n2 > 0) {
                string2 = string.substring(0, n2).trim();
            }
            if (string2 == null || string2.isEmpty()) {
                LOG.warn(MessageFormat.format(JGitText.get().invalidHeaderFormat, string));
                continue;
            }
            if (HttpSupport.scanToken(string2, 0) != string2.length()) {
                LOG.warn(MessageFormat.format(JGitText.get().invalidHeaderKey, string));
                continue;
            }
            String string3 = string.substring(n2 + 1).trim();
            if (!StandardCharsets.US_ASCII.newEncoder().canEncode(string3)) {
                LOG.warn(MessageFormat.format(JGitText.get().invalidHeaderValue, string));
                continue;
            }
            httpConnection.setRequestProperty(string2, string3);
        }
    }

    private void setCookieHeader(HttpConnection httpConnection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (HttpCookie httpCookie : this.relevantCookies) {
            if (httpCookie.hasExpired()) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(';');
            }
            stringBuilder.append(httpCookie.toString());
        }
        if (stringBuilder.length() > 0) {
            httpConnection.setRequestProperty("Cookie", stringBuilder.toString());
        }
    }

    final InputStream openInputStream(HttpConnection httpConnection) {
        InputStream inputStream = httpConnection.getInputStream();
        if (this.isGzipContent(httpConnection)) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    IOException wrongContentType(String string, String string2) {
        String string3 = MessageFormat.format(JGitText.get().expectedReceivedContentType, string, string2);
        return new TransportException(this.uri, string3);
    }

    private NetscapeCookieFile getCookieFileFromConfig(HttpConfig httpConfig) {
        String string = httpConfig.getCookieFile();
        if (!StringUtils.isEmptyOrNull(string)) {
            try {
                File file;
                FS fS;
                FS fS2 = fS = this.local != null ? this.local.getFS() : FS.DETECTED;
                if (string.startsWith("~/")) {
                    file = fS.resolve(fS.userHome(), string.substring(2));
                } else {
                    file = new File(string);
                    if (!file.isAbsolute()) {
                        file = fS.resolve(null, string);
                        LOG.warn(MessageFormat.format(JGitText.get().cookieFilePathRelative, file));
                    }
                }
                return NetscapeCookieFileCache.getInstance(httpConfig).getEntry(file.toPath());
            }
            catch (InvalidPathException invalidPathException) {
                LOG.warn(MessageFormat.format(JGitText.get().couldNotReadCookieFile, string), (Throwable)invalidPathException);
            }
        }
        return null;
    }

    private static Set filterCookies(NetscapeCookieFile netscapeCookieFile, URL uRL) {
        if (netscapeCookieFile != null) {
            return TransportHttp.filterCookies(netscapeCookieFile.getCookies(true), uRL);
        }
        return Collections.emptySet();
    }

    private static Set filterCookies(Set set, URL uRL) {
        HashSet<HttpCookie> hashSet = new HashSet<HttpCookie>();
        for (HttpCookie httpCookie : set) {
            if (httpCookie.hasExpired() || !TransportHttp.matchesCookieDomain(uRL.getHost(), httpCookie.getDomain()) || !TransportHttp.matchesCookiePath(uRL.getPath(), httpCookie.getPath()) || httpCookie.getSecure() && !"https".equals(uRL.getProtocol())) continue;
            hashSet.add(httpCookie);
        }
        return hashSet;
    }

    static boolean matchesCookieDomain(String string, String string2) {
        string2 = string2.toLowerCase(Locale.ROOT);
        if ((string = string.toLowerCase(Locale.ROOT)).equals(string2)) {
            return true;
        }
        if (!string.endsWith(string2)) {
            return false;
        }
        return string.charAt(string.length() - string2.length() - 1) == '.';
    }

    static boolean matchesCookiePath(String string, String string2) {
        if (string2.equals(string)) {
            return true;
        }
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        return string.startsWith(string2);
    }

    private boolean isSmartHttp(HttpConnection httpConnection, String string) {
        String string2 = "application/x-" + string + "-advertisement";
        String string3 = httpConnection.getContentType();
        return string2.equals(string3);
    }

    private boolean isGzipContent(HttpConnection httpConnection) {
        return "gzip".equals(httpConnection.getHeaderField("Content-Encoding")) || "x-gzip".equals(httpConnection.getHeaderField("Content-Encoding"));
    }

    private void readSmartHeaders(InputStream inputStream, String string) {
        byte[] byArray = new byte[14];
        if (!inputStream.markSupported()) {
            throw new TransportException(this.uri, JGitText.get().inputStreamMustSupportMark);
        }
        inputStream.mark(14);
        IO.readFully(inputStream, byArray, 0, byArray.length);
        if (Arrays.equals(Arrays.copyOfRange(byArray, 4, 11), VERSION) && byArray[12] >= 49 && byArray[12] <= 57) {
            inputStream.reset();
            return;
        }
        if (byArray[4] != 35) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().expectedPktLineWithService, RawParseUtils.decode(byArray)));
        }
        inputStream.reset();
        PacketLineIn packetLineIn = new PacketLineIn(inputStream);
        String string2 = "# service=" + string;
        String string3 = packetLineIn.readString();
        if (!string2.equals(string3)) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().expectedGot, string2, string3));
        }
        while (!PacketLineIn.isEnd(packetLineIn.readString())) {
        }
    }

    static /* synthetic */ boolean access$100(TransportHttp transportHttp, HttpConnection httpConnection) {
        return transportHttp.isGzipContent(httpConnection);
    }

    static /* synthetic */ URL access$200(TransportHttp transportHttp) {
        return transportHttp.baseUrl;
    }

    static /* synthetic */ HttpConfig access$300(TransportHttp transportHttp) {
        return transportHttp.http;
    }

    static /* synthetic */ NoRemoteRepositoryException access$400(TransportHttp transportHttp, URIish uRIish, URL uRL, String string) {
        return transportHttp.createNotFoundException(uRIish, uRL, string);
    }

    static /* synthetic */ URIish access$502(TransportHttp transportHttp, URIish uRIish) {
        transportHttp.currentUri = uRIish;
        return transportHttp.currentUri;
    }

    static /* synthetic */ URIish access$600(TransportHttp transportHttp, URL uRL, String string, String string2, int n2) {
        return transportHttp.redirect(uRL, string, string2, n2);
    }

    static /* synthetic */ URL access$202(TransportHttp transportHttp, URL uRL) {
        transportHttp.baseUrl = uRL;
        return transportHttp.baseUrl;
    }

    static /* synthetic */ URIish access$500(TransportHttp transportHttp) {
        return transportHttp.currentUri;
    }

    static /* synthetic */ URL access$700(TransportHttp transportHttp, URIish uRIish) {
        return transportHttp.toURL(uRIish);
    }

    static /* synthetic */ HttpAuthMethod access$802(TransportHttp transportHttp, HttpAuthMethod httpAuthMethod) {
        transportHttp.authMethod = httpAuthMethod;
        return transportHttp.authMethod;
    }

    static /* synthetic */ HttpAuthMethod access$800(TransportHttp transportHttp) {
        return transportHttp.authMethod;
    }

    static /* synthetic */ void access$900(TransportHttp transportHttp, Throwable throwable) {
        transportHttp.handleSslFailure(throwable);
    }
}

