/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLHandshakeException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.HttpAuthMethod;
import org.eclipse.jgit.transport.HttpAuthMethod$Type;
import org.eclipse.jgit.transport.HttpConfig$HttpRedirectMode;
import org.eclipse.jgit.transport.TransferConfig$ProtocolVersion;
import org.eclipse.jgit.transport.TransportHttp;
import org.eclipse.jgit.transport.TransportHttp$AcceptEncoding;
import org.eclipse.jgit.transport.TransportHttp$Service$HttpExecuteStream;
import org.eclipse.jgit.transport.TransportHttp$Service$HttpOutputStream;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.util.HttpSupport;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.TemporaryBuffer$Heap;
import org.eclipse.jgit.util.io.UnionInputStream;

abstract class TransportHttp$Service {
    protected final String serviceName;
    protected final String requestType;
    protected final String responseType;
    protected HttpConnection conn;
    protected TransportHttp$Service$HttpOutputStream out;
    protected final TransportHttp$Service$HttpExecuteStream execute;
    protected final TransferConfig$ProtocolVersion protocolVersion;
    final UnionInputStream in;
    final /* synthetic */ TransportHttp this$0;

    TransportHttp$Service(TransportHttp transportHttp, String string, TransferConfig$ProtocolVersion transferConfig$ProtocolVersion) {
        this.this$0 = transportHttp;
        this.serviceName = string;
        this.protocolVersion = transferConfig$ProtocolVersion;
        this.requestType = "application/x-" + string + "-request";
        this.responseType = "application/x-" + string + "-result";
        this.out = new TransportHttp$Service$HttpOutputStream(this);
        this.execute = new TransportHttp$Service$HttpExecuteStream(this);
        this.in = new UnionInputStream(this.execute);
    }

    void openStream() {
        this.conn = this.this$0.httpOpen("POST", new URL(TransportHttp.access$200(this.this$0), this.serviceName), TransportHttp$AcceptEncoding.GZIP);
        this.conn.setInstanceFollowRedirects(false);
        this.conn.setDoOutput(true);
        this.conn.setRequestProperty("Content-Type", this.requestType);
        this.conn.setRequestProperty("Accept", this.responseType);
        if (TransferConfig$ProtocolVersion.V2.equals((Object)this.protocolVersion)) {
            this.conn.setRequestProperty("Git-Protocol", "version=2");
        }
    }

    void sendRequest() {
        Serializable serializable;
        Object object;
        TemporaryBuffer temporaryBuffer = new TemporaryBuffer$Heap(TransportHttp.access$300(this.this$0).getPostBuffer());
        try {
            object = new GZIPOutputStream(temporaryBuffer);
            serializable = null;
            try {
                this.out.writeTo((OutputStream)object, null);
                if (this.out.length() < temporaryBuffer.length()) {
                    temporaryBuffer = this.out;
                }
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (serializable != null) {
                        try {
                            ((DeflaterOutputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                    } else {
                        ((DeflaterOutputStream)object).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            temporaryBuffer = this.out;
        }
        object = null;
        serializable = EnumSet.noneOf(HttpAuthMethod$Type.class);
        int n2 = 1;
        int n3 = 0;
        while (true) {
            try {
                block38: while (true) {
                    this.openStream();
                    if (temporaryBuffer != this.out) {
                        this.conn.setRequestProperty("Content-Encoding", "gzip");
                    }
                    this.conn.setFixedLengthStreamingMode((int)temporaryBuffer.length());
                    OutputStream outputStream = this.conn.getOutputStream();
                    Object object2 = null;
                    try {
                        temporaryBuffer.writeTo(outputStream, null);
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (outputStream != null) {
                            if (object2 != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object2).addSuppressed(throwable);
                                }
                            } else {
                                outputStream.close();
                            }
                        }
                    }
                    int n4 = HttpSupport.response(this.conn);
                    switch (n4) {
                        case 200: {
                            return;
                        }
                        case 404: {
                            throw TransportHttp.access$400(this.this$0, this.this$0.uri, this.conn.getURL(), this.conn.getResponseMessage());
                        }
                        case 403: {
                            throw new TransportException(this.this$0.uri, MessageFormat.format(JGitText.get().serviceNotPermitted, TransportHttp.access$200(this.this$0), this.serviceName));
                        }
                        case 301: 
                        case 302: 
                        case 307: 
                        case 308: {
                            if (TransportHttp.access$300(this.this$0).getFollowRedirects() != HttpConfig$HttpRedirectMode.TRUE) {
                                return;
                            }
                            TransportHttp.access$502(this.this$0, TransportHttp.access$600(this.this$0, this.conn.getURL(), this.conn.getHeaderField("Location"), '/' + this.serviceName, n3++));
                            try {
                                TransportHttp.access$202(this.this$0, TransportHttp.access$700(this.this$0, TransportHttp.access$500(this.this$0)));
                                continue block38;
                            }
                            catch (MalformedURLException malformedURLException) {
                                throw new TransportException(this.this$0.uri, MessageFormat.format(JGitText.get().invalidRedirectLocation, TransportHttp.access$200(this.this$0), TransportHttp.access$500(this.this$0)), malformedURLException);
                            }
                        }
                        case 401: {
                            object2 = HttpAuthMethod.scanResponse(this.conn, (Collection)((Object)serializable));
                            switch (((HttpAuthMethod)object2).getType()) {
                                case NONE: {
                                    throw new TransportException(this.this$0.uri, MessageFormat.format(JGitText.get().authenticationNotSupported, this.conn.getURL()));
                                }
                                case NEGOTIATE: {
                                    serializable.add(HttpAuthMethod$Type.NEGOTIATE);
                                    if (object != null) {
                                        serializable.add(((HttpAuthMethod)object).getType());
                                    }
                                    n2 = 1;
                                    break;
                                }
                                default: {
                                    serializable.add(HttpAuthMethod$Type.NEGOTIATE);
                                    if (object != null && ((HttpAuthMethod)object).getType() == ((HttpAuthMethod)object2).getType()) break;
                                    if (object != null) {
                                        serializable.add(((HttpAuthMethod)object).getType());
                                    }
                                    n2 = 1;
                                }
                            }
                            TransportHttp.access$802(this.this$0, (HttpAuthMethod)object2);
                            object = object2;
                            CredentialsProvider credentialsProvider = this.this$0.getCredentialsProvider();
                            if (credentialsProvider == null) {
                                throw new TransportException(this.this$0.uri, JGitText.get().noCredentialsProvider);
                            }
                            if (n2 > 1) {
                                credentialsProvider.reset(TransportHttp.access$500(this.this$0));
                            }
                            if (3 < n2 || !TransportHttp.access$800(this.this$0).authorize(TransportHttp.access$500(this.this$0), credentialsProvider)) {
                                throw new TransportException(this.this$0.uri, JGitText.get().notAuthorized);
                            }
                            ++n2;
                            continue block38;
                        }
                    }
                    break;
                }
                return;
            }
            catch (SSLHandshakeException sSLHandshakeException) {
                TransportHttp.access$900(this.this$0, sSLHandshakeException);
                continue;
            }
            catch (InterruptedIOException | SocketException iOException) {
                throw iOException;
            }
            catch (IOException iOException) {
                if (object == null || TransportHttp.access$800(this.this$0).getType() != HttpAuthMethod$Type.NONE) {
                    if (TransportHttp.access$800(this.this$0).getType() != HttpAuthMethod$Type.NONE) {
                        serializable.add(TransportHttp.access$800(this.this$0).getType());
                    }
                    TransportHttp.access$802(this.this$0, HttpAuthMethod$Type.NONE.method(null));
                    object = TransportHttp.access$800(this.this$0);
                    n2 = 1;
                    continue;
                }
                throw iOException;
            }
            break;
        }
    }

    void openResponse() {
        int n2 = HttpSupport.response(this.conn);
        if (n2 != 200) {
            throw new TransportException(this.this$0.uri, n2 + " " + this.conn.getResponseMessage());
        }
        String string = this.conn.getContentType();
        if (!this.responseType.equals(string)) {
            this.conn.getInputStream().close();
            throw this.this$0.wrongContentType(this.responseType, string);
        }
    }

    TransportHttp$Service$HttpOutputStream getOutputStream() {
        return this.out;
    }

    InputStream getInputStream() {
        return this.in;
    }

    abstract void execute();
}

