/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledNonTag;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledTag;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.transport.TransportHttp;
import org.eclipse.jgit.transport.TransportHttp$AcceptEncoding;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase$FileStream;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.util.HttpSupport;

class TransportHttp$HttpObjectDB
extends WalkRemoteObjectDatabase {
    private final URL httpObjectsUrl;
    final /* synthetic */ TransportHttp this$0;

    TransportHttp$HttpObjectDB(TransportHttp transportHttp, URL uRL) {
        this.this$0 = transportHttp;
        this.httpObjectsUrl = uRL;
    }

    @Override
    URIish getURI() {
        return new URIish(this.httpObjectsUrl);
    }

    @Override
    Collection getAlternates() {
        try {
            return this.readAlternates("info/http-alternates");
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                return this.readAlternates("info/alternates");
            }
            catch (FileNotFoundException fileNotFoundException2) {
                return null;
            }
        }
    }

    @Override
    WalkRemoteObjectDatabase openAlternate(String string) {
        return new TransportHttp$HttpObjectDB(this.this$0, new URL(this.httpObjectsUrl, string));
    }

    @Override
    BufferedReader openReader(String string) {
        InputStream inputStream = this.open((String)string, (TransportHttp$AcceptEncoding)TransportHttp$AcceptEncoding.GZIP).in;
        return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    Collection getPackNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (BufferedReader bufferedReader = this.openReader("info/packs");){
            Object object;
            while ((object = bufferedReader.readLine()) != null && ((String)object).length() != 0) {
                if (!((String)object).startsWith("P pack-")) throw this.invalidAdvertisement((String)object);
                if (!((String)object).endsWith(".pack")) {
                    throw this.invalidAdvertisement((String)object);
                }
                arrayList.add(((String)object).substring(2));
            }
            object = arrayList;
            return object;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return arrayList;
        }
    }

    @Override
    WalkRemoteObjectDatabase$FileStream open(String string) {
        return this.open(string, TransportHttp$AcceptEncoding.UNSPECIFIED);
    }

    WalkRemoteObjectDatabase$FileStream open(String string, TransportHttp$AcceptEncoding transportHttp$AcceptEncoding) {
        URL uRL = this.httpObjectsUrl;
        URL uRL2 = new URL(uRL, string);
        HttpConnection httpConnection = this.this$0.httpOpen("GET", uRL2, transportHttp$AcceptEncoding);
        switch (HttpSupport.response(httpConnection)) {
            case 200: {
                InputStream inputStream = this.this$0.openInputStream(httpConnection);
                if (!TransportHttp.access$100(this.this$0, httpConnection)) {
                    int n2 = httpConnection.getContentLength();
                    return new WalkRemoteObjectDatabase$FileStream(inputStream, n2);
                }
                return new WalkRemoteObjectDatabase$FileStream(inputStream);
            }
            case 404: {
                throw new FileNotFoundException(uRL2.toString());
            }
        }
        throw new IOException(uRL2.toString() + ": " + HttpSupport.response(httpConnection) + " " + httpConnection.getResponseMessage());
    }

    Map readAdvertisedImpl(BufferedReader bufferedReader) {
        String string;
        TreeMap<String, ObjectIdRef> treeMap = new TreeMap<String, ObjectIdRef>();
        while ((string = bufferedReader.readLine()) != null) {
            Ref ref;
            int n2 = string.indexOf(9);
            if (n2 < 0) {
                throw this.invalidAdvertisement(string);
            }
            String string2 = string.substring(n2 + 1);
            ObjectId objectId = ObjectId.fromString(string.substring(0, n2));
            if (string2.endsWith("^{}")) {
                ref = (Ref)treeMap.get(string2 = string2.substring(0, string2.length() - 3));
                if (ref == null) {
                    throw this.outOfOrderAdvertisement(string2);
                }
                if (ref.getPeeledObjectId() != null) {
                    throw this.duplicateAdvertisement(string2 + "^{}");
                }
                treeMap.put(string2, new ObjectIdRef$PeeledTag(Ref$Storage.NETWORK, string2, ref.getObjectId(), objectId));
                continue;
            }
            ref = treeMap.put(string2, new ObjectIdRef$PeeledNonTag(Ref$Storage.NETWORK, string2, objectId));
            if (ref == null) continue;
            throw this.duplicateAdvertisement(string2);
        }
        return treeMap;
    }

    private PackProtocolException outOfOrderAdvertisement(String string) {
        return new PackProtocolException(MessageFormat.format(JGitText.get().advertisementOfCameBefore, string, string));
    }

    private PackProtocolException invalidAdvertisement(String string) {
        return new PackProtocolException(MessageFormat.format(JGitText.get().invalidAdvertisementOf, string));
    }

    private PackProtocolException duplicateAdvertisement(String string) {
        return new PackProtocolException(MessageFormat.format(JGitText.get().duplicateAdvertisementsOf, string));
    }

    @Override
    void close() {
    }
}

