/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.TransportGitSsh$1;
import org.eclipse.jgit.transport.TransportGitSsh$2;
import org.eclipse.jgit.transport.TransportGitSsh$SshFetchConnection;
import org.eclipse.jgit.transport.TransportGitSsh$SshPushConnection;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.QuotedString;
import org.eclipse.jgit.util.SystemReader;

public class TransportGitSsh
extends SshTransport
implements PackTransport {
    private static final String EXT = "ext";
    static final TransportProtocol PROTO_SSH = new TransportGitSsh$1();

    TransportGitSsh(Repository repository, URIish uRIish) {
        super(repository, uRIish);
        this.initSshSessionFactory();
    }

    TransportGitSsh(URIish uRIish) {
        super(uRIish);
        this.initSshSessionFactory();
    }

    private void initSshSessionFactory() {
        if (TransportGitSsh.useExtSession()) {
            this.setSshSessionFactory(new TransportGitSsh$2(this));
        }
    }

    @Override
    public FetchConnection openFetch() {
        return new TransportGitSsh$SshFetchConnection(this);
    }

    @Override
    public FetchConnection openFetch(Collection collection, String ... stringArray) {
        return new TransportGitSsh$SshFetchConnection(this, collection, stringArray);
    }

    @Override
    public PushConnection openPush() {
        return new TransportGitSsh$SshPushConnection(this);
    }

    String commandFor(String string) {
        String string2 = this.uri.getPath();
        if (this.uri.getScheme() != null && this.uri.getPath().startsWith("/~")) {
            string2 = this.uri.getPath().substring(1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(' ');
        stringBuilder.append(QuotedString.BOURNE.quote(string2));
        return stringBuilder.toString();
    }

    void checkExecFailure(int n2, String string, String string2) {
        if (n2 == 127) {
            IOException iOException = null;
            if (string2 != null && string2.length() > 0) {
                iOException = new IOException(string2);
            }
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().cannotExecute, this.commandFor(string)), iOException);
        }
    }

    NoRemoteRepositoryException cleanNotFound(NoRemoteRepositoryException noRemoteRepositoryException, String string) {
        if (string == null || string.length() == 0) {
            return noRemoteRepositoryException;
        }
        String string2 = this.uri.getPath();
        if (this.uri.getScheme() != null && this.uri.getPath().startsWith("/~")) {
            string2 = this.uri.getPath().substring(1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("fatal: ");
        stringBuilder.append(QuotedString.BOURNE.quote(string2));
        stringBuilder.append(": ");
        if (string.startsWith(stringBuilder.toString())) {
            string = string.substring(stringBuilder.length());
        }
        return new NoRemoteRepositoryException(this.uri, string);
    }

    private static boolean useExtSession() {
        return SystemReader.getInstance().getenv("GIT_SSH") != null;
    }
}

