/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.InputStream;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.transport.BasePackPushConnection;
import org.eclipse.jgit.transport.TransportGitSsh;
import org.eclipse.jgit.util.io.MessageWriter;
import org.eclipse.jgit.util.io.StreamCopyThread;

class TransportGitSsh$SshPushConnection
extends BasePackPushConnection {
    private final Process process;
    private StreamCopyThread errorThread;
    final /* synthetic */ TransportGitSsh this$0;

    TransportGitSsh$SshPushConnection(TransportGitSsh transportGitSsh) {
        Object object;
        this.this$0 = transportGitSsh;
        super(transportGitSsh);
        try {
            this.process = transportGitSsh.getSession().exec(transportGitSsh.commandFor(transportGitSsh.getOptionReceivePack()), transportGitSsh.getTimeout());
            MessageWriter messageWriter = new MessageWriter();
            this.setMessageWriter(messageWriter);
            object = this.process.getErrorStream();
            this.errorThread = new StreamCopyThread((InputStream)object, messageWriter.getRawStream());
            this.errorThread.start();
            this.init(this.process.getInputStream(), this.process.getOutputStream());
        }
        catch (TransportException transportException) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw transportException;
        }
        catch (Throwable throwable) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new TransportException(this.uri, JGitText.get().remoteHungUpUnexpectedly, throwable);
        }
        try {
            this.readAdvertisedRefs();
        }
        catch (NoRemoteRepositoryException noRemoteRepositoryException) {
            object = this.getMessages();
            transportGitSsh.checkExecFailure(this.process.exitValue(), transportGitSsh.getOptionReceivePack(), (String)object);
            throw transportGitSsh.cleanNotFound(noRemoteRepositoryException, (String)object);
        }
    }

    @Override
    public void close() {
        this.endOut();
        if (this.process != null) {
            this.process.destroy();
        }
        if (this.errorThread != null) {
            try {
                this.errorThread.halt();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.errorThread = null;
            }
        }
        super.close();
    }
}

