/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.transport.BasePackFetchConnection;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.RemoteSession2;
import org.eclipse.jgit.transport.TransferConfig$ProtocolVersion;
import org.eclipse.jgit.transport.TransportGitSsh;
import org.eclipse.jgit.util.io.MessageWriter;
import org.eclipse.jgit.util.io.StreamCopyThread;

class TransportGitSsh$SshFetchConnection
extends BasePackFetchConnection {
    private final Process process;
    private StreamCopyThread errorThread;
    final /* synthetic */ TransportGitSsh this$0;

    TransportGitSsh$SshFetchConnection(TransportGitSsh transportGitSsh) {
        this(transportGitSsh, Collections.emptyList(), new String[0]);
    }

    TransportGitSsh$SshFetchConnection(TransportGitSsh transportGitSsh, Collection collection, String ... stringArray) {
        Object object;
        this.this$0 = transportGitSsh;
        super(transportGitSsh);
        try {
            RemoteSession remoteSession = transportGitSsh.getSession();
            object = transportGitSsh.protocol;
            if (object == null) {
                object = TransferConfig$ProtocolVersion.V2;
            }
            this.process = remoteSession instanceof RemoteSession2 && TransferConfig$ProtocolVersion.V2.equals(object) ? ((RemoteSession2)remoteSession).exec(transportGitSsh.commandFor(transportGitSsh.getOptionUploadPack()), Collections.singletonMap("GIT_PROTOCOL", "version=2"), transportGitSsh.getTimeout()) : remoteSession.exec(transportGitSsh.commandFor(transportGitSsh.getOptionUploadPack()), transportGitSsh.getTimeout());
            MessageWriter messageWriter = new MessageWriter();
            this.setMessageWriter(messageWriter);
            InputStream inputStream = this.process.getErrorStream();
            this.errorThread = new StreamCopyThread(inputStream, messageWriter.getRawStream());
            this.errorThread.start();
            this.init(this.process.getInputStream(), this.process.getOutputStream());
        }
        catch (TransportException transportException) {
            this.close();
            throw transportException;
        }
        catch (Throwable throwable) {
            this.close();
            throw new TransportException(this.uri, JGitText.get().remoteHungUpUnexpectedly, throwable);
        }
        try {
            if (!this.readAdvertisedRefs()) {
                this.lsRefs(collection, stringArray);
            }
        }
        catch (NoRemoteRepositoryException noRemoteRepositoryException) {
            object = this.getMessages();
            transportGitSsh.checkExecFailure(this.process.exitValue(), transportGitSsh.getOptionUploadPack(), (String)object);
            throw transportGitSsh.cleanNotFound(noRemoteRepositoryException, (String)object);
        }
    }

    @Override
    public void close() {
        this.endOut();
        if (this.process != null) {
            this.process.destroy();
        }
        if (this.errorThread != null) {
            try {
                this.errorThread.halt();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.errorThread = null;
            }
        }
        super.close();
    }
}

