/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportGitSsh;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.TransportProtocol$URIishField;
import org.eclipse.jgit.transport.URIish;

final class TransportGitSsh$1
extends TransportProtocol {
    private final String[] schemeNames = new String[]{"ssh", "ssh+git", "git+ssh"};
    private final Set schemeSet = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(this.schemeNames)));

    TransportGitSsh$1() {
    }

    @Override
    public String getName() {
        return JGitText.get().transportProtoSSH;
    }

    @Override
    public Set getSchemes() {
        return this.schemeSet;
    }

    @Override
    public Set getRequiredFields() {
        return Collections.unmodifiableSet(EnumSet.of(TransportProtocol$URIishField.HOST, TransportProtocol$URIishField.PATH));
    }

    @Override
    public Set getOptionalFields() {
        return Collections.unmodifiableSet(EnumSet.of(TransportProtocol$URIishField.USER, TransportProtocol$URIishField.PASS, TransportProtocol$URIishField.PORT));
    }

    @Override
    public int getDefaultPort() {
        return 22;
    }

    @Override
    public boolean canHandle(URIish uRIish, Repository repository, String string) {
        if (uRIish.getScheme() == null) {
            return uRIish.getHost() != null && uRIish.getPath() != null && uRIish.getHost().length() != 0 && uRIish.getPath().length() != 0;
        }
        return super.canHandle(uRIish, repository, string);
    }

    @Override
    public Transport open(URIish uRIish, Repository repository, String string) {
        return new TransportGitSsh(repository, uRIish);
    }

    @Override
    public Transport open(URIish uRIish) {
        return new TransportGitSsh(uRIish);
    }
}

