/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collection;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.TcpTransport;
import org.eclipse.jgit.transport.TransferConfig$ProtocolVersion;
import org.eclipse.jgit.transport.TransportGitAnon$1;
import org.eclipse.jgit.transport.TransportGitAnon$TcpFetchConnection;
import org.eclipse.jgit.transport.TransportGitAnon$TcpPushConnection;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;

class TransportGitAnon
extends TcpTransport
implements PackTransport {
    static final int GIT_PORT = 9418;
    static final TransportProtocol PROTO_GIT = new TransportGitAnon$1();

    TransportGitAnon(Repository repository, URIish uRIish) {
        super(repository, uRIish);
    }

    TransportGitAnon(URIish uRIish) {
        super(uRIish);
    }

    @Override
    public FetchConnection openFetch() {
        return new TransportGitAnon$TcpFetchConnection(this);
    }

    @Override
    public FetchConnection openFetch(Collection collection, String ... stringArray) {
        return new TransportGitAnon$TcpFetchConnection(this, collection, stringArray);
    }

    @Override
    public PushConnection openPush() {
        return new TransportGitAnon$TcpPushConnection(this);
    }

    @Override
    public void close() {
    }

    Socket openConnection() {
        int n2 = this.getTimeout() > 0 ? this.getTimeout() * 1000 : 0;
        int n3 = this.uri.getPort() > 0 ? this.uri.getPort() : 9418;
        Socket socket = new Socket();
        try {
            InetAddress inetAddress = InetAddress.getByName(this.uri.getHost());
            socket.connect(new InetSocketAddress(inetAddress, n3), n2);
        }
        catch (IOException iOException) {
            try {
                socket.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            if (iOException instanceof UnknownHostException) {
                throw new TransportException(this.uri, JGitText.get().unknownHost);
            }
            if (iOException instanceof ConnectException) {
                throw new TransportException(this.uri, iOException.getMessage());
            }
            throw new TransportException(this.uri, iOException.getMessage(), iOException);
        }
        return socket;
    }

    void service(String string, PacketLineOut packetLineOut, TransferConfig$ProtocolVersion transferConfig$ProtocolVersion) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(' ');
        stringBuilder.append(this.uri.getPath());
        stringBuilder.append('\u0000');
        stringBuilder.append("host=");
        stringBuilder.append(this.uri.getHost());
        if (this.uri.getPort() > 0 && this.uri.getPort() != 9418) {
            stringBuilder.append(":");
            stringBuilder.append(this.uri.getPort());
        }
        stringBuilder.append('\u0000');
        if (TransferConfig$ProtocolVersion.V2.equals((Object)transferConfig$ProtocolVersion)) {
            stringBuilder.append('\u0000');
            stringBuilder.append("version=2");
            stringBuilder.append('\u0000');
        }
        packetLineOut.writeString(stringBuilder.toString());
        packetLineOut.flush();
    }
}

