/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BundleFetchConnection;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportBundle;
import org.eclipse.jgit.transport.URIish;

public class TransportBundleStream
extends Transport
implements TransportBundle {
    private InputStream src;

    public TransportBundleStream(Repository repository, URIish uRIish, InputStream inputStream) {
        super(repository, uRIish);
        this.src = inputStream;
    }

    @Override
    public FetchConnection openFetch() {
        if (this.src == null) {
            throw new TransportException(this.uri, JGitText.get().onlyOneFetchSupported);
        }
        try {
            BundleFetchConnection bundleFetchConnection = new BundleFetchConnection(this, this.src);
            return bundleFetchConnection;
        }
        finally {
            this.src = null;
        }
    }

    @Override
    public PushConnection openPush() {
        throw new NotSupportedException(JGitText.get().pushIsNotSupportedForBundleTransport);
    }

    @Override
    public void close() {
        if (this.src != null) {
            try {
                this.src.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.src = null;
            }
        }
    }
}

