/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BundleFetchConnection;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportBundle;
import org.eclipse.jgit.transport.TransportBundleFile$1;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;

class TransportBundleFile
extends Transport
implements TransportBundle {
    static final TransportProtocol PROTO_BUNDLE = new TransportBundleFile$1();
    private final File bundle;

    TransportBundleFile(Repository repository, URIish uRIish, File file) {
        super(repository, uRIish);
        this.bundle = file;
    }

    public TransportBundleFile(URIish uRIish, File file) {
        super(uRIish);
        this.bundle = file;
    }

    @Override
    public FetchConnection openFetch() {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(this.bundle);
        }
        catch (FileNotFoundException fileNotFoundException) {
            TransportException transportException = new TransportException(this.uri, JGitText.get().notFound);
            transportException.initCause(fileNotFoundException);
            throw transportException;
        }
        return new BundleFetchConnection(this, fileInputStream);
    }

    @Override
    public PushConnection openPush() {
        throw new NotSupportedException(JGitText.get().pushIsNotSupportedForBundleTransport);
    }

    @Override
    public void close() {
    }
}

