/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportBundleFile;
import org.eclipse.jgit.transport.TransportLocal;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;

final class TransportBundleFile$1
extends TransportProtocol {
    private final String[] schemeNames = new String[]{"bundle", "file"};
    private final Set schemeSet = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(this.schemeNames)));

    TransportBundleFile$1() {
    }

    @Override
    public String getName() {
        return JGitText.get().transportProtoBundleFile;
    }

    @Override
    public Set getSchemes() {
        return this.schemeSet;
    }

    @Override
    public boolean canHandle(URIish uRIish, Repository repository, String string) {
        return uRIish.getPath() != null && uRIish.getPort() <= 0 && uRIish.getUser() == null && uRIish.getPass() == null && uRIish.getHost() == null && (uRIish.getScheme() == null || this.getSchemes().contains(uRIish.getScheme()));
    }

    @Override
    public Transport open(URIish uRIish, Repository repository, String string) {
        if ("bundle".equals(uRIish.getScheme())) {
            File file = FS.DETECTED.resolve(new File("."), uRIish.getPath());
            return new TransportBundleFile(repository, uRIish, file);
        }
        return TransportLocal.PROTO_LOCAL.open(uRIish, repository, string);
    }

    @Override
    public Transport open(URIish uRIish) {
        if ("bundle".equals(uRIish.getScheme())) {
            File file = FS.DETECTED.resolve(new File("."), uRIish.getPath());
            return new TransportBundleFile(uRIish, file);
        }
        return TransportLocal.PROTO_LOCAL.open(uRIish);
    }
}

