/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.AmazonS3;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.TransportAmazonS3$1;
import org.eclipse.jgit.transport.TransportAmazonS3$DatabaseS3;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.WalkFetchConnection;
import org.eclipse.jgit.transport.WalkPushConnection;
import org.eclipse.jgit.transport.WalkTransport;

public class TransportAmazonS3
extends HttpTransport
implements WalkTransport {
    static final String S3_SCHEME = "amazon-s3";
    static final TransportProtocol PROTO_S3 = new TransportAmazonS3$1();
    final AmazonS3 s3;
    final String bucket;
    private final String keyPrefix;

    TransportAmazonS3(Repository repository, URIish uRIish) {
        super(repository, uRIish);
        Properties properties = this.loadProperties();
        File file = repository.getDirectory();
        if (!properties.containsKey("tmpdir") && file != null) {
            properties.put("tmpdir", file.getPath());
        }
        this.s3 = new AmazonS3(properties);
        this.bucket = uRIish.getHost();
        String string = uRIish.getPath();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        this.keyPrefix = string;
    }

    private Properties loadProperties() {
        File file;
        if (this.local.getDirectory() != null && (file = new File(this.local.getDirectory(), this.uri.getUser())).isFile()) {
            return TransportAmazonS3.loadPropertiesFile(file);
        }
        file = new File(this.local.getFS().userHome(), this.uri.getUser());
        if (file.isFile()) {
            return TransportAmazonS3.loadPropertiesFile(file);
        }
        Properties properties = new Properties();
        String string = this.uri.getUser();
        String string2 = this.uri.getPass();
        if (string == null || string2 == null) {
            throw new NotSupportedException(MessageFormat.format(JGitText.get().cannotReadFile, file));
        }
        properties.setProperty("accesskey", string);
        properties.setProperty("secretkey", string2);
        return properties;
    }

    private static Properties loadPropertiesFile(File file) {
        try {
            return AmazonS3.properties(file);
        }
        catch (IOException iOException) {
            throw new NotSupportedException(MessageFormat.format(JGitText.get().cannotReadFile, file), iOException);
        }
    }

    @Override
    public FetchConnection openFetch() {
        TransportAmazonS3$DatabaseS3 transportAmazonS3$DatabaseS3 = new TransportAmazonS3$DatabaseS3(this, this.bucket, this.keyPrefix + "/objects");
        WalkFetchConnection walkFetchConnection = new WalkFetchConnection(this, transportAmazonS3$DatabaseS3);
        walkFetchConnection.available(transportAmazonS3$DatabaseS3.readAdvertisedRefs());
        return walkFetchConnection;
    }

    @Override
    public PushConnection openPush() {
        TransportAmazonS3$DatabaseS3 transportAmazonS3$DatabaseS3 = new TransportAmazonS3$DatabaseS3(this, this.bucket, this.keyPrefix + "/objects");
        WalkPushConnection walkPushConnection = new WalkPushConnection(this, transportAmazonS3$DatabaseS3);
        walkPushConnection.available(transportAmazonS3$DatabaseS3.readAdvertisedRefs());
        return walkPushConnection;
    }

    @Override
    public void close() {
    }
}

