/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef$Unpeeled;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.transport.TransportAmazonS3;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase$FileStream;

class TransportAmazonS3$DatabaseS3
extends WalkRemoteObjectDatabase {
    private final String bucketName;
    private final String objectsKey;
    final /* synthetic */ TransportAmazonS3 this$0;

    TransportAmazonS3$DatabaseS3(TransportAmazonS3 transportAmazonS3, String string, String string2) {
        this.this$0 = transportAmazonS3;
        this.bucketName = string;
        this.objectsKey = string2;
    }

    private String resolveKey(String string) {
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        String string2 = this.objectsKey;
        while (string.startsWith("../")) {
            string2 = string2.substring(0, string2.lastIndexOf(47));
            string = string.substring(3);
        }
        return string2 + "/" + string;
    }

    @Override
    URIish getURI() {
        URIish uRIish = new URIish();
        uRIish = uRIish.setScheme("amazon-s3");
        uRIish = uRIish.setHost(this.bucketName);
        uRIish = uRIish.setPath("/" + this.objectsKey);
        return uRIish;
    }

    @Override
    Collection getAlternates() {
        try {
            return this.readAlternates("info/alternates");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    WalkRemoteObjectDatabase openAlternate(String string) {
        return new TransportAmazonS3$DatabaseS3(this.this$0, this.bucketName, this.resolveKey(string));
    }

    @Override
    Collection getPackNames() {
        List list = this.this$0.s3.list(this.this$0.bucket, this.resolveKey("pack"));
        HashSet hashSet = new HashSet();
        hashSet.addAll(list);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String string2;
            if (!string.startsWith("pack-") || !string.endsWith(".pack") || !hashSet.contains(string2 = string.substring(0, string.length() - 5) + ".idx")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    WalkRemoteObjectDatabase$FileStream open(String string) {
        URLConnection uRLConnection = this.this$0.s3.get(this.this$0.bucket, this.resolveKey(string));
        InputStream inputStream = uRLConnection.getInputStream();
        InputStream inputStream2 = this.this$0.s3.decrypt(uRLConnection);
        int n2 = uRLConnection.getContentLength();
        return new WalkRemoteObjectDatabase$FileStream(inputStream2, inputStream == inputStream2 ? (long)n2 : -1L);
    }

    @Override
    void deleteFile(String string) {
        this.this$0.s3.delete(this.this$0.bucket, this.resolveKey(string));
    }

    @Override
    OutputStream writeFile(String string, ProgressMonitor progressMonitor, String string2) {
        return this.this$0.s3.beginPut(this.this$0.bucket, this.resolveKey(string), progressMonitor, string2);
    }

    @Override
    void writeFile(String string, byte[] byArray) {
        this.this$0.s3.put(this.this$0.bucket, this.resolveKey(string), byArray);
    }

    Map readAdvertisedRefs() {
        TreeMap treeMap = new TreeMap();
        this.readPackedRefs(treeMap);
        this.readLooseRefs(treeMap);
        this.readRef(treeMap, "HEAD");
        return treeMap;
    }

    private void readLooseRefs(TreeMap treeMap) {
        try {
            for (String string : this.this$0.s3.list(this.this$0.bucket, this.resolveKey("../refs"))) {
                this.readRef(treeMap, "refs/" + string);
            }
        }
        catch (IOException iOException) {
            throw new TransportException(this.getURI(), JGitText.get().cannotListRefs, iOException);
        }
    }

    private Ref readRef(TreeMap treeMap, String string) {
        String string2;
        Object object;
        Object object2;
        String string3 = "../" + string;
        try {
            object2 = this.openReader(string3);
            object = null;
            try {
                string2 = ((BufferedReader)object2).readLine();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((BufferedReader)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((BufferedReader)object2).close();
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            throw new TransportException(this.getURI(), MessageFormat.format(JGitText.get().transportExceptionReadRef, string3), iOException);
        }
        if (string2 == null) {
            throw new TransportException(this.getURI(), MessageFormat.format(JGitText.get().transportExceptionEmptyRef, string));
        }
        if (string2.startsWith("ref: ")) {
            object2 = string2.substring("ref: ".length());
            object = (Ref)treeMap.get(object2);
            if (object == null) {
                object = this.readRef(treeMap, (String)object2);
            }
            if (object == null) {
                object = new ObjectIdRef$Unpeeled(Ref$Storage.NEW, (String)object2, null);
            }
            object = new SymbolicRef(string, (Ref)object);
            treeMap.put(object.getName(), object);
            return object;
        }
        if (ObjectId.isId(string2)) {
            object2 = new ObjectIdRef$Unpeeled(this.loose((Ref)treeMap.get(string)), string, ObjectId.fromString(string2));
            treeMap.put(object2.getName(), object2);
            return object2;
        }
        throw new TransportException(this.getURI(), MessageFormat.format(JGitText.get().transportExceptionBadRef, string, string2));
    }

    private Ref$Storage loose(Ref ref) {
        if (ref != null && ref.getStorage() == Ref$Storage.PACKED) {
            return Ref$Storage.LOOSE_PACKED;
        }
        return Ref$Storage.LOOSE;
    }

    @Override
    void close() {
    }
}

