/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.errors.AbortedByHookException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.hooks.Hooks;
import org.eclipse.jgit.hooks.PrePushHook;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.FetchProcess;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.FilterSpec;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.PushProcess;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefLeaseSpec;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.TransferConfig;
import org.eclipse.jgit.transport.TransferConfig$ProtocolVersion;
import org.eclipse.jgit.transport.Transport$Operation;
import org.eclipse.jgit.transport.TransportAmazonS3;
import org.eclipse.jgit.transport.TransportBundleFile;
import org.eclipse.jgit.transport.TransportGitAnon;
import org.eclipse.jgit.transport.TransportGitSsh;
import org.eclipse.jgit.transport.TransportHttp;
import org.eclipse.jgit.transport.TransportLocal;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.TransportSftp;
import org.eclipse.jgit.transport.URIish;

public abstract class Transport
implements AutoCloseable {
    private static final List protocols = new CopyOnWriteArrayList();
    public static final boolean DEFAULT_FETCH_THIN = true;
    public static final boolean DEFAULT_PUSH_THIN = false;
    public static final RefSpec REFSPEC_TAGS;
    public static final RefSpec REFSPEC_PUSH_ALL;
    protected final Repository local;
    protected final URIish uri;
    private String optionUploadPack = "git-upload-pack";
    private List fetch = Collections.emptyList();
    private TagOpt tagopt = TagOpt.NO_TAGS;
    private boolean fetchThin = true;
    private String optionReceivePack = "git-receive-pack";
    private List push = Collections.emptyList();
    private boolean pushThin = false;
    private boolean pushAtomic;
    private boolean dryRun;
    private ObjectChecker objectChecker;
    private boolean removeDeletedRefs;
    private FilterSpec filterSpec = FilterSpec.NO_FILTER;
    private int timeout;
    private PackConfig packConfig;
    private CredentialsProvider credentialsProvider;
    private List pushOptions;
    private PrintStream hookOutRedirect;
    private PrePushHook prePush;
    @Nullable
    TransferConfig$ProtocolVersion protocol;

    private static void registerByService() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = Transport.class.getClassLoader();
        }
        Enumeration enumeration = Transport.catalogs(classLoader);
        while (enumeration.hasMoreElements()) {
            Transport.scan(classLoader, (URL)enumeration.nextElement());
        }
    }

    private static Enumeration catalogs(ClassLoader classLoader) {
        try {
            String string = "META-INF/services/";
            String string2 = string + Transport.class.getName();
            return classLoader.getResources(string2);
        }
        catch (IOException iOException) {
            return new Vector().elements();
        }
    }

    private static void scan(ClassLoader classLoader, URL uRL) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), StandardCharsets.UTF_8));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                int n2;
                if ((string = string.trim()).length() == 0 || (n2 = string.indexOf(35)) == 0) continue;
                if (n2 != -1) {
                    string = string.substring(0, n2).trim();
                }
                Transport.load(classLoader, string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void load(ClassLoader classLoader, String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
        for (Field field : clazz.getDeclaredFields()) {
            TransportProtocol transportProtocol;
            if ((field.getModifiers() & 8) != 8 || !TransportProtocol.class.isAssignableFrom(field.getType())) continue;
            try {
                transportProtocol = (TransportProtocol)field.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                continue;
            }
            if (transportProtocol == null) continue;
            Transport.register(transportProtocol);
        }
    }

    public static void register(TransportProtocol transportProtocol) {
        protocols.add(0, new WeakReference<TransportProtocol>(transportProtocol));
    }

    public static void unregister(TransportProtocol transportProtocol) {
        for (WeakReference weakReference : protocols) {
            TransportProtocol transportProtocol2 = (TransportProtocol)weakReference.get();
            if (transportProtocol2 != null && transportProtocol2 != transportProtocol) continue;
            protocols.remove(weakReference);
        }
    }

    public static List getTransportProtocols() {
        int n2 = protocols.size();
        ArrayList<TransportProtocol> arrayList = new ArrayList<TransportProtocol>(n2);
        for (WeakReference weakReference : protocols) {
            TransportProtocol transportProtocol = (TransportProtocol)weakReference.get();
            if (transportProtocol != null) {
                arrayList.add(transportProtocol);
                continue;
            }
            protocols.remove(weakReference);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static Transport open(Repository repository, String string) {
        return Transport.open(repository, string, Transport$Operation.FETCH);
    }

    public static Transport open(Repository repository, String string, Transport$Operation transport$Operation) {
        if (repository != null) {
            RemoteConfig remoteConfig = new RemoteConfig(repository.getConfig(), string);
            if (Transport.doesNotExist(remoteConfig)) {
                return Transport.open(repository, new URIish(string), null);
            }
            return Transport.open(repository, remoteConfig, transport$Operation);
        }
        return Transport.open(new URIish(string));
    }

    public static List openAll(Repository repository, String string) {
        return Transport.openAll(repository, string, Transport$Operation.FETCH);
    }

    public static List openAll(Repository repository, String string, Transport$Operation transport$Operation) {
        RemoteConfig remoteConfig = new RemoteConfig(repository.getConfig(), string);
        if (Transport.doesNotExist(remoteConfig)) {
            ArrayList<Transport> arrayList = new ArrayList<Transport>(1);
            arrayList.add(Transport.open(repository, new URIish(string), null));
            return arrayList;
        }
        return Transport.openAll(repository, remoteConfig, transport$Operation);
    }

    public static Transport open(Repository repository, RemoteConfig remoteConfig) {
        return Transport.open(repository, remoteConfig, Transport$Operation.FETCH);
    }

    public static Transport open(Repository repository, RemoteConfig remoteConfig, Transport$Operation transport$Operation) {
        List list = Transport.getURIs(remoteConfig, transport$Operation);
        if (list.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().remoteConfigHasNoURIAssociated, remoteConfig.getName()));
        }
        Transport transport = Transport.open(repository, (URIish)list.get(0), remoteConfig.getName());
        transport.applyConfig(remoteConfig);
        return transport;
    }

    public static List openAll(Repository repository, RemoteConfig remoteConfig) {
        return Transport.openAll(repository, remoteConfig, Transport$Operation.FETCH);
    }

    public static List openAll(Repository repository, RemoteConfig remoteConfig, Transport$Operation transport$Operation) {
        List list = Transport.getURIs(remoteConfig, transport$Operation);
        ArrayList<Transport> arrayList = new ArrayList<Transport>(list.size());
        for (URIish uRIish : list) {
            Transport transport = Transport.open(repository, uRIish, remoteConfig.getName());
            transport.applyConfig(remoteConfig);
            arrayList.add(transport);
        }
        return arrayList;
    }

    private static List getURIs(RemoteConfig remoteConfig, Transport$Operation transport$Operation) {
        switch (transport$Operation) {
            case FETCH: {
                return remoteConfig.getURIs();
            }
            case PUSH: {
                List list = remoteConfig.getPushURIs();
                if (list.isEmpty()) {
                    list = remoteConfig.getURIs();
                }
                return list;
            }
        }
        throw new IllegalArgumentException(transport$Operation.toString());
    }

    private static boolean doesNotExist(RemoteConfig remoteConfig) {
        return remoteConfig.getURIs().isEmpty() && remoteConfig.getPushURIs().isEmpty();
    }

    public static Transport open(Repository repository, URIish uRIish) {
        return Transport.open(repository, uRIish, null);
    }

    public static Transport open(Repository repository, URIish uRIish, String string) {
        for (WeakReference weakReference : protocols) {
            TransportProtocol transportProtocol = (TransportProtocol)weakReference.get();
            if (transportProtocol == null) {
                protocols.remove(weakReference);
                continue;
            }
            if (!transportProtocol.canHandle(uRIish, repository, string)) continue;
            Transport transport = transportProtocol.open(uRIish, repository, string);
            transport.prePush = Hooks.prePush(repository, transport.hookOutRedirect);
            transport.prePush.setRemoteLocation(uRIish.toString());
            transport.prePush.setRemoteName(string);
            return transport;
        }
        throw new NotSupportedException(MessageFormat.format(JGitText.get().URINotSupported, uRIish));
    }

    public static Transport open(URIish uRIish) {
        for (WeakReference weakReference : protocols) {
            TransportProtocol transportProtocol = (TransportProtocol)weakReference.get();
            if (transportProtocol == null) {
                protocols.remove(weakReference);
                continue;
            }
            if (!transportProtocol.canHandle(uRIish, null, null)) continue;
            return transportProtocol.open(uRIish);
        }
        throw new NotSupportedException(MessageFormat.format(JGitText.get().URINotSupported, uRIish));
    }

    public static Collection findRemoteRefUpdatesFor(Repository repository, Collection collection, Map map, Collection list) {
        if (list == null) {
            list = Collections.emptyList();
        }
        LinkedList<RemoteRefUpdate> linkedList = new LinkedList<RemoteRefUpdate>();
        Collection collection2 = Transport.expandPushWildcardsFor(repository, collection);
        for (RefSpec refSpec : collection2) {
            String string;
            String string2 = refSpec.getSource();
            Ref ref = repository.findRef(string2);
            if (ref != null) {
                string2 = ref.getName();
            }
            if ((string = refSpec.getDestination()) == null) {
                string = string2;
            }
            if (ref != null && !string.startsWith("refs/")) {
                String string3 = ref.getName();
                int n2 = string3.indexOf(47, "refs/".length());
                string = string3.substring(0, n2 + 1) + string;
            }
            boolean bl2 = refSpec.isForceUpdate();
            String string4 = Transport.findTrackingRefName(string, list);
            RefLeaseSpec refLeaseSpec = (RefLeaseSpec)map.get(string);
            ObjectId objectId = refLeaseSpec == null ? null : repository.resolve(refLeaseSpec.getExpected());
            RemoteRefUpdate remoteRefUpdate = new RemoteRefUpdate(repository, string2, string, bl2, string4, objectId);
            linkedList.add(remoteRefUpdate);
        }
        return linkedList;
    }

    public static Collection findRemoteRefUpdatesFor(Repository repository, Collection collection, Collection collection2) {
        return Transport.findRemoteRefUpdatesFor(repository, collection, Collections.emptyMap(), collection2);
    }

    private static Collection expandPushWildcardsFor(Repository repository, Collection collection) {
        List list = repository.getRefDatabase().getRefs();
        LinkedHashSet<RefSpec> linkedHashSet = new LinkedHashSet<RefSpec>();
        for (RefSpec refSpec : collection) {
            if (refSpec.isWildcard()) {
                for (Ref ref : list) {
                    if (!refSpec.matchSource(ref)) continue;
                    linkedHashSet.add(refSpec.expandFromSource(ref));
                }
                continue;
            }
            linkedHashSet.add(refSpec);
        }
        return linkedHashSet;
    }

    private static String findTrackingRefName(String string, Collection collection) {
        for (RefSpec refSpec : collection) {
            if (!refSpec.matchSource(string)) continue;
            if (refSpec.isWildcard()) {
                return refSpec.expandFromSource(string).getDestination();
            }
            return refSpec.getDestination();
        }
        return null;
    }

    protected Transport(Repository repository, URIish uRIish) {
        TransferConfig transferConfig = (TransferConfig)repository.getConfig().get(TransferConfig.KEY);
        this.local = repository;
        this.uri = uRIish;
        this.protocol = transferConfig.protocolVersion;
        this.objectChecker = transferConfig.newObjectChecker();
        this.credentialsProvider = CredentialsProvider.getDefault();
        this.prePush = Hooks.prePush(repository, this.hookOutRedirect);
    }

    protected Transport(URIish uRIish) {
        this.uri = uRIish;
        this.local = null;
        this.objectChecker = new ObjectChecker();
        this.credentialsProvider = CredentialsProvider.getDefault();
    }

    public URIish getURI() {
        return this.uri;
    }

    public String getOptionUploadPack() {
        return this.optionUploadPack;
    }

    public void setOptionUploadPack(String string) {
        this.optionUploadPack = string != null && string.length() > 0 ? string : "git-upload-pack";
    }

    public TagOpt getTagOpt() {
        return this.tagopt;
    }

    public void setTagOpt(TagOpt tagOpt) {
        this.tagopt = tagOpt != null ? tagOpt : TagOpt.AUTO_FOLLOW;
    }

    public boolean isFetchThin() {
        return this.fetchThin;
    }

    public void setFetchThin(boolean bl2) {
        this.fetchThin = bl2;
    }

    public boolean isCheckFetchedObjects() {
        return this.getObjectChecker() != null;
    }

    public void setCheckFetchedObjects(boolean bl2) {
        if (bl2 && this.objectChecker == null) {
            this.setObjectChecker(new ObjectChecker());
        } else if (!bl2 && this.objectChecker != null) {
            this.setObjectChecker(null);
        }
    }

    public ObjectChecker getObjectChecker() {
        return this.objectChecker;
    }

    public void setObjectChecker(ObjectChecker objectChecker) {
        this.objectChecker = objectChecker;
    }

    public String getOptionReceivePack() {
        return this.optionReceivePack;
    }

    public void setOptionReceivePack(String string) {
        this.optionReceivePack = string != null && string.length() > 0 ? string : "git-receive-pack";
    }

    public boolean isPushThin() {
        return this.pushThin;
    }

    public void setPushThin(boolean bl2) {
        this.pushThin = bl2;
    }

    public boolean isPushAtomic() {
        return this.pushAtomic;
    }

    public void setPushAtomic(boolean bl2) {
        this.pushAtomic = bl2;
    }

    public boolean isRemoveDeletedRefs() {
        return this.removeDeletedRefs;
    }

    public void setRemoveDeletedRefs(boolean bl2) {
        this.removeDeletedRefs = bl2;
    }

    @Deprecated
    public final long getFilterBlobLimit() {
        return this.filterSpec.getBlobLimit();
    }

    @Deprecated
    public final void setFilterBlobLimit(long l2) {
        this.setFilterSpec(FilterSpec.withBlobLimit(l2));
    }

    public final FilterSpec getFilterSpec() {
        return this.filterSpec;
    }

    public final void setFilterSpec(@NonNull FilterSpec filterSpec) {
        this.filterSpec = Objects.requireNonNull(filterSpec);
    }

    public void applyConfig(RemoteConfig remoteConfig) {
        this.setOptionUploadPack(remoteConfig.getUploadPack());
        this.setOptionReceivePack(remoteConfig.getReceivePack());
        this.setTagOpt(remoteConfig.getTagOpt());
        this.fetch = remoteConfig.getFetchRefSpecs();
        this.push = remoteConfig.getPushRefSpecs();
        this.timeout = remoteConfig.getTimeout();
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean bl2) {
        this.dryRun = bl2;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n2) {
        this.timeout = n2;
    }

    public PackConfig getPackConfig() {
        if (this.packConfig == null) {
            this.packConfig = new PackConfig(this.local);
        }
        return this.packConfig;
    }

    public void setPackConfig(PackConfig packConfig) {
        this.packConfig = packConfig;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public List getPushOptions() {
        return this.pushOptions;
    }

    public void setPushOptions(List list) {
        this.pushOptions = list;
    }

    public FetchResult fetch(ProgressMonitor progressMonitor, Collection collection) {
        return this.fetch(progressMonitor, collection, null);
    }

    public FetchResult fetch(ProgressMonitor progressMonitor, Collection object, String string) {
        Object object2;
        if (object == null || object.isEmpty()) {
            if (this.fetch.isEmpty()) {
                throw new TransportException(JGitText.get().nothingToFetch);
            }
            object = this.fetch;
        } else if (!this.fetch.isEmpty()) {
            object2 = new ArrayList(object);
            Iterator iterator = object.iterator();
            block0: while (iterator.hasNext()) {
                RefSpec refSpec = (RefSpec)iterator.next();
                String string2 = refSpec.getSource();
                for (RefSpec refSpec2 : this.fetch) {
                    String string3 = refSpec2.getSource();
                    String string4 = refSpec2.getDestination();
                    if (!string3.equals(string2) || string4 == null) continue;
                    object2.add(refSpec2);
                    continue block0;
                }
            }
            object = object2;
        }
        object2 = new FetchResult();
        new FetchProcess(this, (Collection)object).execute(progressMonitor, (FetchResult)object2, string);
        this.local.autoGC(progressMonitor);
        return object2;
    }

    public PushResult push(ProgressMonitor progressMonitor, Collection collection, OutputStream outputStream) {
        if (collection == null || collection.isEmpty()) {
            try {
                collection = this.findRemoteRefUpdatesFor(this.push);
            }
            catch (IOException iOException) {
                throw new TransportException(MessageFormat.format(JGitText.get().problemWithResolvingPushRefSpecsLocally, iOException.getMessage()), iOException);
            }
            if (collection.isEmpty()) {
                throw new TransportException(JGitText.get().nothingToPush);
            }
        }
        if (this.prePush != null) {
            try {
                this.prePush.setRefs(collection);
                this.prePush.call();
            }
            catch (IOException | AbortedByHookException exception) {
                throw new TransportException(exception.getMessage(), exception);
            }
        }
        PushProcess pushProcess = new PushProcess(this, collection, outputStream);
        return pushProcess.execute(progressMonitor);
    }

    public PushResult push(ProgressMonitor progressMonitor, Collection collection) {
        return this.push(progressMonitor, collection, null);
    }

    public Collection findRemoteRefUpdatesFor(Collection collection) {
        return Transport.findRemoteRefUpdatesFor(this.local, collection, Collections.emptyMap(), this.fetch);
    }

    public Collection findRemoteRefUpdatesFor(Collection collection, Map map) {
        return Transport.findRemoteRefUpdatesFor(this.local, collection, map, this.fetch);
    }

    public abstract FetchConnection openFetch();

    public FetchConnection openFetch(Collection collection, String ... stringArray) {
        return this.openFetch();
    }

    public abstract PushConnection openPush();

    @Override
    public abstract void close();

    static {
        Transport.register(TransportLocal.PROTO_LOCAL);
        Transport.register(TransportBundleFile.PROTO_BUNDLE);
        Transport.register(TransportAmazonS3.PROTO_S3);
        Transport.register(TransportGitAnon.PROTO_GIT);
        Transport.register(TransportSftp.PROTO_SFTP);
        Transport.register(TransportHttp.PROTO_FTP);
        Transport.register(TransportHttp.PROTO_HTTP);
        Transport.register(TransportGitSsh.PROTO_SSH);
        Transport.registerByService();
        REFSPEC_TAGS = new RefSpec("refs/tags/*:refs/tags/*");
        REFSPEC_PUSH_ALL = new RefSpec("refs/heads/*:refs/heads/*");
    }
}

