/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.util.EnumSet;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.storage.file.LazyObjectIdSetFile;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Config$SectionParser;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectChecker$ErrorType;
import org.eclipse.jgit.lib.ObjectIdSet;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefFilter;
import org.eclipse.jgit.transport.TransferConfig$1;
import org.eclipse.jgit.transport.TransferConfig$FsckKeyNameHolder;
import org.eclipse.jgit.transport.TransferConfig$FsckMode;
import org.eclipse.jgit.transport.TransferConfig$ProtocolVersion;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;

public class TransferConfig {
    private static final String FSCK = "fsck";
    public static final Config$SectionParser KEY = TransferConfig::new;
    private final boolean fetchFsck;
    private final boolean receiveFsck;
    private final String fsckSkipList;
    private final EnumSet ignore;
    private final boolean allowInvalidPersonIdent;
    private final boolean safeForWindows;
    private final boolean safeForMacOS;
    private final boolean allowRefInWant;
    private final boolean allowTipSha1InWant;
    private final boolean allowReachableSha1InWant;
    private final boolean allowFilter;
    private final boolean allowSidebandAll;
    private final boolean advertiseSidebandAll;
    private final boolean advertiseWaitForDone;
    private final boolean advertiseObjectInfo;
    @Nullable
    final TransferConfig$ProtocolVersion protocolVersion;
    final String[] hideRefs;

    public TransferConfig(Repository repository) {
        this(repository.getConfig());
    }

    public TransferConfig(Config config) {
        boolean bl2 = config.getBoolean("transfer", "fsckobjects", false);
        this.fetchFsck = config.getBoolean("fetch", "fsckobjects", bl2);
        this.receiveFsck = config.getBoolean("receive", "fsckobjects", bl2);
        this.fsckSkipList = config.getString(FSCK, null, "skipList");
        this.allowInvalidPersonIdent = config.getBoolean(FSCK, "allowInvalidPersonIdent", false);
        this.safeForWindows = config.getBoolean(FSCK, "safeForWindows", SystemReader.getInstance().isWindows());
        this.safeForMacOS = config.getBoolean(FSCK, "safeForMacOS", SystemReader.getInstance().isMacOS());
        this.ignore = EnumSet.noneOf(ObjectChecker$ErrorType.class);
        EnumSet<ObjectChecker$ErrorType> enumSet = EnumSet.noneOf(ObjectChecker$ErrorType.class);
        for (String string : config.getNames(FSCK)) {
            ObjectChecker$ErrorType objectChecker$ErrorType;
            if (StringUtils.equalsIgnoreCase(string, "skipList") || StringUtils.equalsIgnoreCase(string, "allowLeadingZeroFileMode") || StringUtils.equalsIgnoreCase(string, "allowInvalidPersonIdent") || StringUtils.equalsIgnoreCase(string, "safeForWindows") || StringUtils.equalsIgnoreCase(string, "safeForMacOS") || (objectChecker$ErrorType = TransferConfig$FsckKeyNameHolder.parse(string)) == null) continue;
            switch ((TransferConfig$FsckMode)config.getEnum(FSCK, null, string, TransferConfig$FsckMode.ERROR)) {
                case ERROR: {
                    this.ignore.remove((Object)objectChecker$ErrorType);
                    break;
                }
                case WARN: 
                case IGNORE: {
                    this.ignore.add(objectChecker$ErrorType);
                }
            }
            enumSet.add(objectChecker$ErrorType);
        }
        if (!enumSet.contains((Object)ObjectChecker$ErrorType.ZERO_PADDED_FILEMODE) && config.getBoolean(FSCK, "allowLeadingZeroFileMode", false)) {
            this.ignore.add(ObjectChecker$ErrorType.ZERO_PADDED_FILEMODE);
        }
        this.allowRefInWant = config.getBoolean("uploadpack", "allowrefinwant", false);
        this.allowTipSha1InWant = config.getBoolean("uploadpack", "allowtipsha1inwant", false);
        this.allowReachableSha1InWant = config.getBoolean("uploadpack", "allowreachablesha1inwant", false);
        this.allowFilter = config.getBoolean("uploadpack", "allowfilter", false);
        this.protocolVersion = TransferConfig$ProtocolVersion.parse(config.getString("protocol", null, "version"));
        this.hideRefs = config.getStringList("uploadpack", null, "hiderefs");
        this.allowSidebandAll = config.getBoolean("uploadpack", "allowsidebandall", false);
        this.advertiseSidebandAll = config.getBoolean("uploadpack", "advertisesidebandall", false);
        this.advertiseWaitForDone = config.getBoolean("uploadpack", "advertisewaitfordone", false);
        this.advertiseObjectInfo = config.getBoolean("uploadpack", "advertiseobjectinfo", false);
    }

    @Nullable
    public ObjectChecker newObjectChecker() {
        return this.newObjectChecker(this.fetchFsck);
    }

    @Nullable
    public ObjectChecker newReceiveObjectChecker() {
        return this.newObjectChecker(this.receiveFsck);
    }

    private ObjectChecker newObjectChecker(boolean bl2) {
        if (!bl2) {
            return null;
        }
        return new ObjectChecker().setIgnore(this.ignore).setAllowInvalidPersonIdent(this.allowInvalidPersonIdent).setSafeForWindows(this.safeForWindows).setSafeForMacOS(this.safeForMacOS).setSkipList(this.skipList());
    }

    private ObjectIdSet skipList() {
        if (this.fsckSkipList != null && !this.fsckSkipList.isEmpty()) {
            return new LazyObjectIdSetFile(new File(this.fsckSkipList));
        }
        return null;
    }

    public boolean isAllowTipSha1InWant() {
        return this.allowTipSha1InWant;
    }

    public boolean isAllowReachableSha1InWant() {
        return this.allowReachableSha1InWant;
    }

    public boolean isAllowFilter() {
        return this.allowFilter;
    }

    public boolean isAllowRefInWant() {
        return this.allowRefInWant;
    }

    public boolean isAllowSidebandAll() {
        return this.allowSidebandAll;
    }

    public boolean isAdvertiseSidebandAll() {
        return this.advertiseSidebandAll && this.allowSidebandAll;
    }

    public boolean isAdvertiseWaitForDone() {
        return this.advertiseWaitForDone;
    }

    public boolean isAdvertiseObjectInfo() {
        return this.advertiseObjectInfo;
    }

    public RefFilter getRefFilter() {
        if (this.hideRefs.length == 0) {
            return RefFilter.DEFAULT;
        }
        return new TransferConfig$1(this);
    }

    boolean hasDefaultRefFilter() {
        return this.hideRefs.length == 0;
    }
}

