/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BasePackFetchConnection$FetchConfig;
import org.eclipse.jgit.transport.TestProtocol$Handle;
import org.eclipse.jgit.transport.TestProtocol$TransportInternal;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.TransportProtocol$URIishField;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;

public class TestProtocol
extends TransportProtocol {
    private static final String SCHEME = "test";
    private static BasePackFetchConnection$FetchConfig fetchConfig;
    final UploadPackFactory uploadPackFactory;
    final ReceivePackFactory receivePackFactory;
    private final HashMap handles;

    public TestProtocol(UploadPackFactory uploadPackFactory, ReceivePackFactory receivePackFactory) {
        this.uploadPackFactory = uploadPackFactory;
        this.receivePackFactory = receivePackFactory;
        this.handles = new HashMap();
    }

    @Override
    public String getName() {
        return JGitText.get().transportProtoTest;
    }

    @Override
    public Set getSchemes() {
        return Collections.singleton(SCHEME);
    }

    @Override
    public Transport open(URIish uRIish, Repository repository, String string) {
        TestProtocol$Handle testProtocol$Handle = (TestProtocol$Handle)this.handles.get(uRIish);
        if (testProtocol$Handle == null) {
            throw new NotSupportedException(MessageFormat.format(JGitText.get().URINotSupported, uRIish));
        }
        return new TestProtocol$TransportInternal(this, repository, uRIish, testProtocol$Handle);
    }

    @Override
    public Set getRequiredFields() {
        return EnumSet.of(TransportProtocol$URIishField.HOST, TransportProtocol$URIishField.PATH);
    }

    @Override
    public Set getOptionalFields() {
        return Collections.emptySet();
    }

    static void setFetchConfig(BasePackFetchConnection$FetchConfig basePackFetchConnection$FetchConfig) {
        fetchConfig = basePackFetchConnection$FetchConfig;
    }

    public synchronized URIish register(Object object, Repository repository) {
        URIish uRIish;
        try {
            int n2 = this.handles.size();
            uRIish = new URIish("test://test/conn" + n2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException(uRISyntaxException);
        }
        this.handles.put(uRIish, new TestProtocol$Handle(this, object, repository));
        return uRIish;
    }

    static /* synthetic */ BasePackFetchConnection$FetchConfig access$000() {
        return fetchConfig;
    }
}

