/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.security.AccessController;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;

public abstract class SshSessionFactory {
    private static SshSessionFactory INSTANCE = SshSessionFactory.loadSshSessionFactory();

    private static SshSessionFactory loadSshSessionFactory() {
        ServiceLoader<SshSessionFactory> serviceLoader = ServiceLoader.load(SshSessionFactory.class);
        Iterator<SshSessionFactory> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static SshSessionFactory getInstance() {
        return INSTANCE;
    }

    public static void setInstance(SshSessionFactory sshSessionFactory) {
        INSTANCE = sshSessionFactory != null ? sshSessionFactory : SshSessionFactory.loadSshSessionFactory();
    }

    public static String getLocalUserName() {
        return AccessController.doPrivileged(() -> SystemReader.getInstance().getProperty("user.name"));
    }

    public abstract RemoteSession getSession(URIish var1, CredentialsProvider var2, FS var3, int var4);

    public abstract String getType();

    public void releaseSession(RemoteSession remoteSession) {
        remoteSession.disconnect();
    }
}

