/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Config$SectionParser;
import org.eclipse.jgit.transport.HMACSHA1NonceGenerator;
import org.eclipse.jgit.transport.NonceGenerator;

public class SignedPushConfig {
    public static final Config$SectionParser KEY = SignedPushConfig::new;
    private String certNonceSeed;
    private int certNonceSlopLimit;
    private NonceGenerator nonceGenerator;

    public SignedPushConfig() {
    }

    SignedPushConfig(Config config) {
        this.setCertNonceSeed(config.getString("receive", null, "certnonceseed"));
        this.certNonceSlopLimit = config.getInt("receive", "certnonceslop", 0);
    }

    public void setCertNonceSeed(String string) {
        this.certNonceSeed = string;
    }

    public String getCertNonceSeed() {
        return this.certNonceSeed;
    }

    public void setCertNonceSlopLimit(int n2) {
        this.certNonceSlopLimit = n2;
    }

    public int getCertNonceSlopLimit() {
        return this.certNonceSlopLimit;
    }

    public void setNonceGenerator(NonceGenerator nonceGenerator) {
        this.nonceGenerator = nonceGenerator;
    }

    public NonceGenerator getNonceGenerator() {
        if (this.nonceGenerator != null) {
            return this.nonceGenerator;
        }
        if (this.certNonceSeed != null) {
            return new HMACSHA1NonceGenerator(this.certNonceSeed);
        }
        return null;
    }
}

