/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jgit.lib.BatchingProgressMonitor;
import org.eclipse.jgit.lib.Constants;

class SideBandProgressMonitor
extends BatchingProgressMonitor {
    private final OutputStream out;
    private boolean write;

    SideBandProgressMonitor(OutputStream outputStream) {
        this.out = outputStream;
        this.write = true;
    }

    @Override
    protected void onUpdate(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.format(stringBuilder, string, n2);
        stringBuilder.append("   \r");
        this.send(stringBuilder);
    }

    @Override
    protected void onEndTask(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.format(stringBuilder, string, n2);
        stringBuilder.append(", done\n");
        this.send(stringBuilder);
    }

    private void format(StringBuilder stringBuilder, String string, int n2) {
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(n2);
    }

    @Override
    protected void onUpdate(String string, int n2, int n3, int n4) {
        StringBuilder stringBuilder = new StringBuilder();
        this.format(stringBuilder, string, n2, n3, n4);
        stringBuilder.append("   \r");
        this.send(stringBuilder);
    }

    @Override
    protected void onEndTask(String string, int n2, int n3, int n4) {
        StringBuilder stringBuilder = new StringBuilder();
        this.format(stringBuilder, string, n2, n3, n4);
        stringBuilder.append("\n");
        this.send(stringBuilder);
    }

    private void format(StringBuilder stringBuilder, String string, int n2, int n3, int n4) {
        stringBuilder.append(string);
        stringBuilder.append(": ");
        if (n4 < 100) {
            stringBuilder.append(' ');
        }
        if (n4 < 10) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(n4);
        stringBuilder.append("% (");
        stringBuilder.append(n2);
        stringBuilder.append("/");
        stringBuilder.append(n3);
        stringBuilder.append(")");
    }

    private void send(StringBuilder stringBuilder) {
        if (this.write) {
            try {
                this.out.write(Constants.encode(stringBuilder.toString()));
                this.out.flush();
            }
            catch (IOException iOException) {
                this.write = false;
            }
        }
    }
}

