/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.transport.PacketLineOut;

public class SideBandOutputStream
extends OutputStream {
    public static final int CH_DATA = 1;
    public static final int CH_PROGRESS = 2;
    public static final int CH_ERROR = 3;
    public static final int SMALL_BUF = 1000;
    public static final int MAX_BUF = 65520;
    static final int HDR_SIZE = 5;
    private final OutputStream out;
    private final byte[] buffer;
    private int cnt;

    public SideBandOutputStream(int n2, int n3, OutputStream outputStream) {
        if (n2 <= 0 || n2 > 255) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().channelMustBeInRange1_255, n2));
        }
        if (n3 <= 5) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().packetSizeMustBeAtLeast, n3, 5));
        }
        if (65520 < n3) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().packetSizeMustBeAtMost, n3, 65520));
        }
        this.out = outputStream;
        this.buffer = new byte[n3];
        this.buffer[4] = (byte)n2;
        this.cnt = 5;
    }

    void flushBuffer() {
        if (5 < this.cnt) {
            this.writeBuffer();
        }
    }

    @Override
    public void flush() {
        this.flushBuffer();
        this.out.flush();
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        while (0 < n3) {
            int n4 = this.buffer.length - this.cnt;
            if (this.cnt == 5 && n4 < n3) {
                PacketLineOut.formatLength(this.buffer, this.buffer.length);
                this.out.write(this.buffer, 0, 5);
                this.out.write(byArray, n2, n4);
                n2 += n4;
                n3 -= n4;
                continue;
            }
            if (n4 == 0) {
                this.writeBuffer();
            }
            int n5 = Math.min(n3, n4);
            System.arraycopy(byArray, n2, this.buffer, this.cnt, n5);
            this.cnt += n5;
            n2 += n5;
            n3 -= n5;
        }
    }

    @Override
    public void write(int n2) {
        if (this.cnt == this.buffer.length) {
            this.writeBuffer();
        }
        this.buffer[this.cnt++] = (byte)n2;
    }

    private void writeBuffer() {
        PacketLineOut.formatLength(this.buffer, this.cnt);
        this.out.write(this.buffer, 0, this.cnt);
        this.cnt = 5;
    }
}

