/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

public class SideBandInputStream
extends InputStream {
    static final int CH_DATA = 1;
    static final int CH_PROGRESS = 2;
    static final int CH_ERROR = 3;
    private static Pattern P_UNBOUNDED = Pattern.compile("^([\\w ]+): +(\\d+)(?:, done\\.)? *[\r\n]$");
    private static Pattern P_BOUNDED = Pattern.compile("^([\\w ]+): +\\d+% +\\( *(\\d+)/ *(\\d+)\\)(?:, done\\.)? *[\r\n]$");
    private final InputStream rawIn;
    private final PacketLineIn pckIn;
    private final ProgressMonitor monitor;
    private final Writer messages;
    private final OutputStream out;
    private String progressBuffer = "";
    private String currentTask;
    private int lastCnt;
    private boolean eof;
    private int channel;
    private int available;

    SideBandInputStream(InputStream inputStream, ProgressMonitor progressMonitor, Writer writer, OutputStream outputStream) {
        this.rawIn = inputStream;
        this.pckIn = new PacketLineIn(this.rawIn);
        this.monitor = progressMonitor;
        this.messages = writer;
        this.currentTask = "";
        this.out = outputStream;
    }

    @Override
    public int read() {
        this.needDataPacket();
        if (this.eof) {
            return -1;
        }
        --this.available;
        return this.rawIn.read();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n3 > 0) {
            int n5;
            this.needDataPacket();
            if (this.eof || (n5 = this.rawIn.read(byArray, n2, Math.min(n3, this.available))) < 0) break;
            n4 += n5;
            n2 += n5;
            n3 -= n5;
            this.available -= n5;
        }
        return this.eof && n4 == 0 ? -1 : n4;
    }

    private void needDataPacket() {
        if (this.eof || this.channel == 1 && this.available > 0) {
            return;
        }
        block5: while (true) {
            this.available = this.pckIn.readLength();
            if (this.available == 0) {
                this.eof = true;
                return;
            }
            this.channel = this.rawIn.read() & 0xFF;
            this.available -= 5;
            if (this.available == 0) continue;
            switch (this.channel) {
                case 1: {
                    return;
                }
                case 2: {
                    this.progress(this.readString(this.available));
                    continue block5;
                }
                case 3: {
                    this.eof = true;
                    throw new TransportException(SideBandInputStream.remote(this.readString(this.available)));
                }
            }
            break;
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidChannel, this.channel));
    }

    private void progress(String string) {
        string = this.progressBuffer + string;
        while (true) {
            int n2;
            int n3 = string.indexOf(10);
            int n4 = string.indexOf(13);
            if (0 <= n3 && 0 <= n4) {
                n2 = Math.min(n3, n4);
            } else if (0 <= n3) {
                n2 = n3;
            } else {
                if (0 > n4) break;
                n2 = n4;
            }
            this.doProgressLine(string.substring(0, n2 + 1));
            string = string.substring(n2 + 1);
        }
        this.progressBuffer = string;
    }

    private void doProgressLine(String string) {
        Matcher matcher = P_BOUNDED.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            if (!this.currentTask.equals(string2)) {
                this.currentTask = string2;
                this.lastCnt = 0;
                this.beginTask(Integer.parseInt(matcher.group(3)));
            }
            int n2 = Integer.parseInt(matcher.group(2));
            this.monitor.update(n2 - this.lastCnt);
            this.lastCnt = n2;
            return;
        }
        matcher = P_UNBOUNDED.matcher(string);
        if (matcher.matches()) {
            String string3 = matcher.group(1);
            if (!this.currentTask.equals(string3)) {
                this.currentTask = string3;
                this.lastCnt = 0;
                this.beginTask(0);
            }
            int n3 = Integer.parseInt(matcher.group(2));
            this.monitor.update(n3 - this.lastCnt);
            this.lastCnt = n3;
            return;
        }
        this.messages.write(string);
        if (this.out != null) {
            this.out.write(string.getBytes(StandardCharsets.UTF_8));
        }
    }

    private void beginTask(int n2) {
        this.monitor.beginTask(SideBandInputStream.remote(this.currentTask), n2);
    }

    private static String remote(String string) {
        String string2 = JGitText.get().prefixRemote;
        StringBuilder stringBuilder = new StringBuilder(string2.length() + string.length() + 1);
        stringBuilder.append(string2);
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) != ' ') {
            stringBuilder.append(' ');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private String readString(int n2) {
        byte[] byArray = new byte[n2];
        IO.readFully(this.rawIn, byArray, 0, n2);
        return RawParseUtils.decode(StandardCharsets.UTF_8, byArray, 0, n2);
    }
}

