/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RemoteRefUpdate$Status;
import org.eclipse.jgit.transport.TrackingRefUpdate;

public class RemoteRefUpdate {
    private ObjectId expectedOldObjectId;
    private final ObjectId newObjectId;
    private final String remoteName;
    private final TrackingRefUpdate trackingRefUpdate;
    private final String srcRef;
    private final boolean forceUpdate;
    private RemoteRefUpdate$Status status;
    private boolean fastForward;
    private String message;
    private final Repository localDb;
    private RefUpdate localUpdate;

    public RemoteRefUpdate(Repository repository, String string, String string2, boolean bl2, String string3, ObjectId objectId) {
        this(repository, string, string != null ? repository.resolve(string) : ObjectId.zeroId(), string2, bl2, string3, objectId);
    }

    public RemoteRefUpdate(Repository repository, Ref ref, String string, boolean bl2, String string2, ObjectId objectId) {
        this(repository, ref != null ? ref.getName() : null, ref != null ? ref.getObjectId() : null, string, bl2, string2, objectId);
    }

    public RemoteRefUpdate(Repository repository, String string, ObjectId objectId, String string2, boolean bl2, String string3, ObjectId objectId2) {
        if (string2 == null) {
            throw new IllegalArgumentException(JGitText.get().remoteNameCannotBeNull);
        }
        if (objectId == null && string != null) {
            throw new IOException(MessageFormat.format(JGitText.get().sourceRefDoesntResolveToAnyObject, string));
        }
        this.srcRef = string != null ? string : (objectId != null && !objectId.equals(ObjectId.zeroId()) ? objectId.name() : null);
        this.newObjectId = objectId != null ? objectId : ObjectId.zeroId();
        this.remoteName = string2;
        this.forceUpdate = bl2;
        if (string3 != null && repository != null) {
            this.localUpdate = repository.updateRef(string3);
            this.localUpdate.setForceUpdate(true);
            this.localUpdate.setRefLogMessage("push", true);
            this.localUpdate.setNewObjectId(this.newObjectId);
            this.trackingRefUpdate = new TrackingRefUpdate(true, string2, string3, this.localUpdate.getOldObjectId() != null ? this.localUpdate.getOldObjectId() : ObjectId.zeroId(), this.newObjectId);
        } else {
            this.trackingRefUpdate = null;
        }
        this.localDb = repository;
        this.expectedOldObjectId = objectId2;
        this.status = RemoteRefUpdate$Status.NOT_ATTEMPTED;
    }

    public RemoteRefUpdate(RemoteRefUpdate remoteRefUpdate, ObjectId objectId) {
        this(remoteRefUpdate.localDb, remoteRefUpdate.srcRef, remoteRefUpdate.remoteName, remoteRefUpdate.forceUpdate, remoteRefUpdate.trackingRefUpdate == null ? null : remoteRefUpdate.trackingRefUpdate.getLocalName(), objectId);
    }

    public ObjectId getExpectedOldObjectId() {
        return this.expectedOldObjectId;
    }

    public boolean isExpectingOldObjectId() {
        return this.expectedOldObjectId != null;
    }

    public ObjectId getNewObjectId() {
        return this.newObjectId;
    }

    public boolean isDelete() {
        return ObjectId.zeroId().equals(this.newObjectId);
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public TrackingRefUpdate getTrackingRefUpdate() {
        return this.trackingRefUpdate;
    }

    public String getSrcRef() {
        return this.srcRef;
    }

    public boolean hasTrackingRefUpdate() {
        return this.trackingRefUpdate != null;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public RemoteRefUpdate$Status getStatus() {
        return this.status;
    }

    public boolean isFastForward() {
        return this.fastForward;
    }

    public String getMessage() {
        return this.message;
    }

    void setExpectedOldObjectId(ObjectId objectId) {
        this.expectedOldObjectId = objectId;
    }

    void setStatus(RemoteRefUpdate$Status remoteRefUpdate$Status) {
        this.status = remoteRefUpdate$Status;
    }

    void setFastForward(boolean bl2) {
        this.fastForward = bl2;
    }

    void setMessage(String string) {
        this.message = string;
    }

    protected void updateTrackingRef(RevWalk revWalk) {
        if (this.isDelete()) {
            this.trackingRefUpdate.setResult(this.localUpdate.delete(revWalk));
        } else {
            this.trackingRefUpdate.setResult(this.localUpdate.update(revWalk));
        }
    }

    public String toString() {
        return "RemoteRefUpdate[remoteName=" + this.remoteName + ", " + (Object)((Object)this.status) + ", " + (this.expectedOldObjectId != null ? this.expectedOldObjectId.name() : "(null)") + "..." + (this.newObjectId != null ? this.newObjectId.name() : "(null)") + (this.fastForward ? ", fastForward" : "") + ", srcRef=" + this.srcRef + (this.forceUpdate ? ", forceUpdate" : "") + ", message=" + (this.message != null ? "\"" + this.message + "\"" : "null") + "]";
    }
}

