/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.URIish;

public class RemoteConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SECTION = "remote";
    private static final String KEY_URL = "url";
    private static final String KEY_PUSHURL = "pushurl";
    private static final String KEY_FETCH = "fetch";
    private static final String KEY_PUSH = "push";
    private static final String KEY_UPLOADPACK = "uploadpack";
    private static final String KEY_RECEIVEPACK = "receivepack";
    private static final String KEY_TAGOPT = "tagopt";
    private static final String KEY_MIRROR = "mirror";
    private static final String KEY_TIMEOUT = "timeout";
    private static final String KEY_INSTEADOF = "insteadof";
    private static final String KEY_PUSHINSTEADOF = "pushinsteadof";
    private static final boolean DEFAULT_MIRROR = false;
    public static final String DEFAULT_UPLOAD_PACK = "git-upload-pack";
    public static final String DEFAULT_RECEIVE_PACK = "git-receive-pack";
    private String name;
    private List uris;
    private List pushURIs;
    private List fetch;
    private List push;
    private String uploadpack;
    private String receivepack;
    private TagOpt tagopt;
    private boolean mirror;
    private int timeout;

    public static List getAllRemoteConfigs(Config config) {
        ArrayList arrayList = new ArrayList(config.getSubsections(SECTION));
        Collections.sort(arrayList);
        ArrayList<RemoteConfig> arrayList2 = new ArrayList<RemoteConfig>(arrayList.size());
        for (String string : arrayList) {
            arrayList2.add(new RemoteConfig(config, string));
        }
        return arrayList2;
    }

    public RemoteConfig(Config config, String string) {
        this.name = string;
        String[] stringArray = config.getStringList(SECTION, this.name, KEY_URL);
        Map map = this.getReplacements(config, KEY_INSTEADOF);
        this.uris = new ArrayList(stringArray.length);
        for (String string2 : stringArray) {
            this.uris.add(new URIish(this.replaceUri(string2, map)));
        }
        String[] stringArray2 = config.getStringList(SECTION, this.name, KEY_PUSHURL);
        this.pushURIs = new ArrayList(stringArray2.length);
        Object object = stringArray2;
        int n2 = ((String[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string3 = object[i2];
            this.pushURIs.add(new URIish(string3));
        }
        if (this.pushURIs.isEmpty() && !(object = this.getReplacements(config, KEY_PUSHINSTEADOF)).isEmpty()) {
            for (String string4 : stringArray) {
                String string5 = this.replaceUri(string4, (Map)object);
                if (string4.equals(string5)) continue;
                this.pushURIs.add(new URIish(string5));
            }
        }
        this.fetch = config.getRefSpecs(SECTION, this.name, KEY_FETCH);
        this.push = config.getRefSpecs(SECTION, this.name, KEY_PUSH);
        String string6 = config.getString(SECTION, this.name, KEY_UPLOADPACK);
        if (string6 == null) {
            string6 = DEFAULT_UPLOAD_PACK;
        }
        this.uploadpack = string6;
        string6 = config.getString(SECTION, this.name, KEY_RECEIVEPACK);
        if (string6 == null) {
            string6 = DEFAULT_RECEIVE_PACK;
        }
        this.receivepack = string6;
        try {
            string6 = config.getString(SECTION, this.name, KEY_TAGOPT);
            this.tagopt = TagOpt.fromOption(string6);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.tagopt = TagOpt.AUTO_FOLLOW;
        }
        this.mirror = config.getBoolean(SECTION, this.name, KEY_MIRROR, false);
        this.timeout = config.getInt(SECTION, this.name, KEY_TIMEOUT, 0);
    }

    public void update(Config config) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.clear();
        for (Serializable serializable : this.getURIs()) {
            arrayList.add(((URIish)serializable).toPrivateString());
        }
        config.setStringList(SECTION, this.getName(), KEY_URL, arrayList);
        arrayList.clear();
        for (Serializable serializable : this.getPushURIs()) {
            arrayList.add(((URIish)serializable).toPrivateString());
        }
        config.setStringList(SECTION, this.getName(), KEY_PUSHURL, arrayList);
        arrayList.clear();
        for (Serializable serializable : this.getFetchRefSpecs()) {
            arrayList.add(((RefSpec)serializable).toString());
        }
        config.setStringList(SECTION, this.getName(), KEY_FETCH, arrayList);
        arrayList.clear();
        for (Serializable serializable : this.getPushRefSpecs()) {
            arrayList.add(((RefSpec)serializable).toString());
        }
        config.setStringList(SECTION, this.getName(), KEY_PUSH, arrayList);
        this.set(config, KEY_UPLOADPACK, this.getUploadPack(), DEFAULT_UPLOAD_PACK);
        this.set(config, KEY_RECEIVEPACK, this.getReceivePack(), DEFAULT_RECEIVE_PACK);
        this.set(config, KEY_TAGOPT, this.getTagOpt().option(), TagOpt.AUTO_FOLLOW.option());
        this.set(config, KEY_MIRROR, this.mirror, false);
        this.set(config, KEY_TIMEOUT, this.timeout, 0);
    }

    private void set(Config config, String string, String string2, String string3) {
        if (string3.equals(string2)) {
            this.unset(config, string);
        } else {
            config.setString(SECTION, this.getName(), string, string2);
        }
    }

    private void set(Config config, String string, boolean bl2, boolean bl3) {
        if (bl3 == bl2) {
            this.unset(config, string);
        } else {
            config.setBoolean(SECTION, this.getName(), string, bl2);
        }
    }

    private void set(Config config, String string, int n2, int n3) {
        if (n3 == n2) {
            this.unset(config, string);
        } else {
            config.setInt(SECTION, this.getName(), string, n2);
        }
    }

    private void unset(Config config, String string) {
        config.unset(SECTION, this.getName(), string);
    }

    private Map getReplacements(Config config, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : config.getSubsections(KEY_URL)) {
            for (String string3 : config.getStringList(KEY_URL, string2, string)) {
                hashMap.put(string3, string2);
            }
        }
        return hashMap;
    }

    private String replaceUri(String string, Map map) {
        if (map.isEmpty()) {
            return string;
        }
        Map.Entry entry = null;
        for (Map.Entry entry2 : map.entrySet()) {
            if (entry != null && ((String)entry.getKey()).length() > ((String)entry2.getKey()).length() || !string.startsWith((String)entry2.getKey())) continue;
            entry = entry2;
        }
        if (entry != null) {
            return (String)entry.getValue() + string.substring(((String)entry.getKey()).length());
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    public List getURIs() {
        return Collections.unmodifiableList(this.uris);
    }

    public boolean addURI(URIish uRIish) {
        if (this.uris.contains(uRIish)) {
            return false;
        }
        return this.uris.add(uRIish);
    }

    public boolean removeURI(URIish uRIish) {
        return this.uris.remove(uRIish);
    }

    public List getPushURIs() {
        return Collections.unmodifiableList(this.pushURIs);
    }

    public boolean addPushURI(URIish uRIish) {
        if (this.pushURIs.contains(uRIish)) {
            return false;
        }
        return this.pushURIs.add(uRIish);
    }

    public boolean removePushURI(URIish uRIish) {
        return this.pushURIs.remove(uRIish);
    }

    public List getFetchRefSpecs() {
        return Collections.unmodifiableList(this.fetch);
    }

    public boolean addFetchRefSpec(RefSpec refSpec) {
        if (this.fetch.contains(refSpec)) {
            return false;
        }
        return this.fetch.add(refSpec);
    }

    public void setFetchRefSpecs(List list) {
        this.fetch.clear();
        this.fetch.addAll(list);
    }

    public void setPushRefSpecs(List list) {
        this.push.clear();
        this.push.addAll(list);
    }

    public boolean removeFetchRefSpec(RefSpec refSpec) {
        return this.fetch.remove(refSpec);
    }

    public List getPushRefSpecs() {
        return Collections.unmodifiableList(this.push);
    }

    public boolean addPushRefSpec(RefSpec refSpec) {
        if (this.push.contains(refSpec)) {
            return false;
        }
        return this.push.add(refSpec);
    }

    public boolean removePushRefSpec(RefSpec refSpec) {
        return this.push.remove(refSpec);
    }

    public String getUploadPack() {
        return this.uploadpack;
    }

    public String getReceivePack() {
        return this.receivepack;
    }

    public TagOpt getTagOpt() {
        return this.tagopt;
    }

    public void setTagOpt(TagOpt tagOpt) {
        this.tagopt = tagOpt != null ? tagOpt : TagOpt.AUTO_FOLLOW;
    }

    public boolean isMirror() {
        return this.mirror;
    }

    public void setMirror(boolean bl2) {
        this.mirror = bl2;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n2) {
        this.timeout = n2;
    }
}

