/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.Serializable;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.RefSpec$WildcardMode;
import org.eclipse.jgit.util.References;

public class RefSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String WILDCARD_SUFFIX = "/*";
    private boolean force;
    private boolean wildcard;
    private RefSpec$WildcardMode allowMismatchedWildcards;
    private String srcName;
    private String dstName;

    public static boolean isWildcard(String string) {
        return string != null && string.contains("*");
    }

    public RefSpec() {
        this.force = false;
        this.wildcard = false;
        this.srcName = "HEAD";
        this.dstName = null;
        this.allowMismatchedWildcards = RefSpec$WildcardMode.REQUIRE_MATCH;
    }

    public RefSpec(String string, RefSpec$WildcardMode refSpec$WildcardMode) {
        int n2;
        this.allowMismatchedWildcards = refSpec$WildcardMode;
        String string2 = string;
        if (string2.startsWith("+")) {
            this.force = true;
            string2 = string2.substring(1);
        }
        if ((n2 = string2.lastIndexOf(58)) == 0) {
            if (RefSpec.isWildcard(string2 = string2.substring(1))) {
                this.wildcard = true;
                if (refSpec$WildcardMode == RefSpec$WildcardMode.REQUIRE_MATCH) {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidWildcards, string));
                }
            }
            this.dstName = RefSpec.checkValid(string2);
        } else if (n2 > 0) {
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            if (RefSpec.isWildcard(string3) && RefSpec.isWildcard(string4)) {
                this.wildcard = true;
            } else if (RefSpec.isWildcard(string3) || RefSpec.isWildcard(string4)) {
                this.wildcard = true;
                if (refSpec$WildcardMode == RefSpec$WildcardMode.REQUIRE_MATCH) {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidWildcards, string));
                }
            }
            this.srcName = RefSpec.checkValid(string3);
            this.dstName = RefSpec.checkValid(string4);
        } else {
            if (RefSpec.isWildcard(string2)) {
                if (refSpec$WildcardMode == RefSpec$WildcardMode.REQUIRE_MATCH) {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidWildcards, string));
                }
                this.wildcard = true;
            }
            this.srcName = RefSpec.checkValid(string2);
        }
    }

    public RefSpec(String string) {
        this(string, RefSpec$WildcardMode.REQUIRE_MATCH);
    }

    private RefSpec(RefSpec refSpec) {
        this.force = refSpec.isForceUpdate();
        this.wildcard = refSpec.isWildcard();
        this.srcName = refSpec.getSource();
        this.dstName = refSpec.getDestination();
        this.allowMismatchedWildcards = refSpec.allowMismatchedWildcards;
    }

    public boolean isForceUpdate() {
        return this.force;
    }

    public RefSpec setForceUpdate(boolean bl2) {
        RefSpec refSpec = new RefSpec(this);
        refSpec.force = bl2;
        return refSpec;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public String getSource() {
        return this.srcName;
    }

    public RefSpec setSource(String string) {
        RefSpec refSpec = new RefSpec(this);
        refSpec.srcName = RefSpec.checkValid(string);
        if (RefSpec.isWildcard(refSpec.srcName) && refSpec.dstName == null) {
            throw new IllegalStateException(JGitText.get().destinationIsNotAWildcard);
        }
        if (RefSpec.isWildcard(refSpec.srcName) != RefSpec.isWildcard(refSpec.dstName)) {
            throw new IllegalStateException(JGitText.get().sourceDestinationMustMatch);
        }
        return refSpec;
    }

    public String getDestination() {
        return this.dstName;
    }

    public RefSpec setDestination(String string) {
        RefSpec refSpec = new RefSpec(this);
        refSpec.dstName = RefSpec.checkValid(string);
        if (RefSpec.isWildcard(refSpec.dstName) && refSpec.srcName == null) {
            throw new IllegalStateException(JGitText.get().sourceIsNotAWildcard);
        }
        if (RefSpec.isWildcard(refSpec.srcName) != RefSpec.isWildcard(refSpec.dstName)) {
            throw new IllegalStateException(JGitText.get().sourceDestinationMustMatch);
        }
        return refSpec;
    }

    public RefSpec setSourceDestination(String string, String string2) {
        if (RefSpec.isWildcard(string) != RefSpec.isWildcard(string2)) {
            throw new IllegalStateException(JGitText.get().sourceDestinationMustMatch);
        }
        RefSpec refSpec = new RefSpec(this);
        refSpec.wildcard = RefSpec.isWildcard(string);
        refSpec.srcName = string;
        refSpec.dstName = string2;
        return refSpec;
    }

    public boolean matchSource(String string) {
        return this.match(string, this.getSource());
    }

    public boolean matchSource(Ref ref) {
        return this.match(ref.getName(), this.getSource());
    }

    public boolean matchDestination(String string) {
        return this.match(string, this.getDestination());
    }

    public boolean matchDestination(Ref ref) {
        return this.match(ref.getName(), this.getDestination());
    }

    public RefSpec expandFromSource(String string) {
        if (this.allowMismatchedWildcards != RefSpec$WildcardMode.REQUIRE_MATCH) {
            throw new IllegalStateException(JGitText.get().invalidExpandWildcard);
        }
        return this.isWildcard() ? new RefSpec(this).expandFromSourceImp(string) : this;
    }

    private RefSpec expandFromSourceImp(String string) {
        String string2 = this.srcName;
        String string3 = this.dstName;
        this.wildcard = false;
        this.srcName = string;
        this.dstName = RefSpec.expandWildcard(string, string2, string3);
        return this;
    }

    public RefSpec expandFromSource(Ref ref) {
        return this.expandFromSource(ref.getName());
    }

    public RefSpec expandFromDestination(String string) {
        if (this.allowMismatchedWildcards != RefSpec$WildcardMode.REQUIRE_MATCH) {
            throw new IllegalStateException(JGitText.get().invalidExpandWildcard);
        }
        return this.isWildcard() ? new RefSpec(this).expandFromDstImp(string) : this;
    }

    private RefSpec expandFromDstImp(String string) {
        String string2 = this.srcName;
        String string3 = this.dstName;
        this.wildcard = false;
        this.srcName = RefSpec.expandWildcard(string, string3, string2);
        this.dstName = string;
        return this;
    }

    public RefSpec expandFromDestination(Ref ref) {
        return this.expandFromDestination(ref.getName());
    }

    private boolean match(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (RefSpec.isWildcard(string2)) {
            int n2 = string2.indexOf(42);
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            return string.length() > string3.length() + string4.length() && string.startsWith(string3) && string.endsWith(string4);
        }
        return string.equals(string2);
    }

    private static String expandWildcard(String string, String string2, String string3) {
        int n2 = string2.indexOf(42);
        int n3 = string2.length() - (n2 + 1);
        int n4 = string3.indexOf(42);
        String string4 = string.substring(n2, string.length() - n3);
        return string3.substring(0, n4) + string4 + string3.substring(n4 + 1);
    }

    private static String checkValid(String string) {
        if (string != null && !RefSpec.isValid(string)) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidRefSpec, string));
        }
        return string;
    }

    private static boolean isValid(String string) {
        if (string.startsWith("/")) {
            return false;
        }
        if (string.contains("//")) {
            return false;
        }
        if (string.endsWith("/")) {
            return false;
        }
        int n2 = string.indexOf(42);
        return n2 == -1 || string.indexOf(42, n2 + 1) <= n2;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.getSource() != null) {
            n2 = n2 * 31 + this.getSource().hashCode();
        }
        if (this.getDestination() != null) {
            n2 = n2 * 31 + this.getDestination().hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RefSpec)) {
            return false;
        }
        RefSpec refSpec = (RefSpec)object;
        if (this.isForceUpdate() != refSpec.isForceUpdate()) {
            return false;
        }
        if (this.isWildcard() != refSpec.isWildcard()) {
            return false;
        }
        if (!RefSpec.eq(this.getSource(), refSpec.getSource())) {
            return false;
        }
        return RefSpec.eq(this.getDestination(), refSpec.getDestination());
    }

    private static boolean eq(String string, String string2) {
        if (References.isSameObject(string, string2)) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isForceUpdate()) {
            stringBuilder.append('+');
        }
        if (this.getSource() != null) {
            stringBuilder.append(this.getSource());
        }
        if (this.getDestination() != null) {
            stringBuilder.append(':');
            stringBuilder.append(this.getDestination());
        }
        return stringBuilder.toString();
    }
}

