/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.lib.Repository;

public abstract class RefAdvertiser {
    private final StringBuilder tmpLine = new StringBuilder(100);
    private final char[] tmpId = new char[40];
    final Set capablities = new LinkedHashSet();
    private final Set sent = new HashSet();
    private Repository repository;
    private boolean derefTags;
    boolean first = true;
    private boolean useProtocolV2;
    private final Map symrefs = new HashMap();

    public void init(Repository repository) {
        this.repository = repository;
    }

    public void setUseProtocolV2(boolean bl2) {
        this.useProtocolV2 = bl2;
    }

    public void setDerefTags(boolean bl2) {
        this.derefTags = bl2;
    }

    public void advertiseCapability(String string) {
        this.capablities.add(string);
    }

    public void advertiseCapability(String string, String string2) {
        if (string2 != null) {
            this.capablities.add(string + '=' + string2);
        }
    }

    public void addSymref(String string, String string2) {
        if (this.useProtocolV2) {
            this.symrefs.put(string, string2);
        } else {
            this.advertiseCapability("symref", string + ':' + string2);
        }
    }

    @Deprecated
    public Set send(Map map) {
        return this.send(map.values());
    }

    public Set send(Collection collection) {
        for (Ref ref : RefComparator.sort(collection)) {
            ObjectId objectId = ref.getObjectId();
            if (objectId == null) continue;
            if (this.useProtocolV2) {
                String string = this.symrefs.containsKey(ref.getName()) ? " symref-target:" + (String)this.symrefs.get(ref.getName()) : "";
                String string2 = "";
                if (this.derefTags) {
                    ObjectId objectId2;
                    if (!ref.isPeeled() && this.repository != null) {
                        ref = this.repository.getRefDatabase().peel(ref);
                    }
                    if ((objectId2 = ref.getPeeledObjectId()) != null) {
                        string2 = " peeled:" + objectId2.getName();
                    }
                }
                this.writeOne(objectId.getName() + " " + ref.getName() + string + string2 + "\n");
                continue;
            }
            this.advertiseAny(objectId, ref.getName());
            if (!this.derefTags) continue;
            if (!ref.isPeeled()) {
                if (this.repository == null) continue;
                ref = this.repository.getRefDatabase().peel(ref);
            }
            if (ref.getPeeledObjectId() == null) continue;
            this.advertiseAny(ref.getPeeledObjectId(), ref.getName() + "^{}");
        }
        return this.sent;
    }

    public void advertiseHave(AnyObjectId anyObjectId) {
        this.advertiseAnyOnce(anyObjectId, ".have");
    }

    public boolean isEmpty() {
        return this.first;
    }

    private void advertiseAnyOnce(AnyObjectId anyObjectId, String string) {
        if (!this.sent.contains(anyObjectId)) {
            this.advertiseAny(anyObjectId, string);
        }
    }

    private void advertiseAny(AnyObjectId anyObjectId, String string) {
        this.sent.add(anyObjectId.toObjectId());
        this.advertiseId(anyObjectId, string);
    }

    public void advertiseId(AnyObjectId anyObjectId, String string) {
        this.tmpLine.setLength(0);
        anyObjectId.copyTo(this.tmpId, this.tmpLine);
        this.tmpLine.append(' ');
        this.tmpLine.append(string);
        if (this.first) {
            this.first = false;
            if (!this.capablities.isEmpty()) {
                this.tmpLine.append('\u0000');
                for (String string2 : this.capablities) {
                    this.tmpLine.append(' ');
                    this.tmpLine.append(string2);
                }
                this.tmpLine.append(' ');
            }
        }
        this.tmpLine.append('\n');
        this.writeOne(this.tmpLine);
    }

    protected abstract void writeOne(CharSequence var1);

    protected abstract void end();
}

